/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.core.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemModelChangeEvent;
import org.eclipse.rse.core.events.ISystemModelChangeListener;
import org.eclipse.rse.core.events.ISystemPreferenceChangeEvent;
import org.eclipse.rse.core.events.ISystemPreferenceChangeListener;
import org.eclipse.rse.core.events.ISystemRemoteChangeEvent;
import org.eclipse.rse.core.events.ISystemRemoteChangeListener;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.ISystemResourceChangeListener;
import org.eclipse.rse.core.events.SystemRemoteChangeEvent;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManager;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.filters.ISystemFilterStartHere;
import org.eclipse.rse.core.filters.SystemFilterReference;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISubSystemConfigurator;
import org.eclipse.rse.core.model.ISystemContainer;
import org.eclipse.rse.core.model.ISystemHostPool;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemProfileManager;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.SystemChildrenContentsType;
import org.eclipse.rse.core.model.SystemMessageObject;
import org.eclipse.rse.core.references.IRSEBaseReferencingObject;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.IRemoteObjectIdentifier;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.ISubSystemConfigurationProxy;
import org.eclipse.rse.core.subsystems.ISystemDragDropAdapter;
import org.eclipse.rse.internal.core.RSECoreMessages;
import org.eclipse.rse.internal.core.filters.SystemFilterStartHere;
import org.eclipse.rse.internal.core.model.ISystemProfileOperation;
import org.eclipse.rse.internal.core.model.SystemHostPool;
import org.eclipse.rse.internal.core.model.SystemModelChangeEvent;
import org.eclipse.rse.internal.core.model.SystemModelChangeEventManager;
import org.eclipse.rse.internal.core.model.SystemPreferenceChangeManager;
import org.eclipse.rse.internal.core.model.SystemProfileManager;
import org.eclipse.rse.internal.core.model.SystemRegistry;
import org.eclipse.rse.internal.core.model.SystemRemoteChangeEventManager;
import org.eclipse.rse.internal.core.model.SystemResourceChangeManager;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.swt.widgets.Display;

public class SystemRegistry
implements ISystemRegistry {
    private static Exception lastException;
    private static SystemRegistry registry;
    private final SystemResourceChangeManager listenerManager = new SystemResourceChangeManager();
    private final SystemPreferenceChangeManager preferenceListManager = new SystemPreferenceChangeManager();
    private final SystemModelChangeEventManager modelListenerManager = new SystemModelChangeEventManager();
    private final SystemRemoteChangeEventManager remoteListManager = new SystemRemoteChangeEventManager();
    private ISubSystemConfigurationProxy[] subsystemConfigurationProxies = null;
    private boolean errorLoadingFactory = false;
    private Object viewer = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.rse.internal.core.model.SystemRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        lastException = null;
        registry = null;
    }

    protected SystemRegistry(String logfilePath) {
        registry = this;
        this.restore();
    }

    public void reset() {
        SystemHostPool.reset();
        this.restore();
    }

    public static SystemRegistry getInstance(String logfilePath) {
        if (registry == null) {
            new SystemRegistry(logfilePath);
        }
        return registry;
    }

    public static SystemRegistry getInstance() {
        return registry;
    }

    public Object[] getConnectionChildren(IHost selectedConnection) {
        Object[] result = this.getSubSystems(selectedConnection);
        return result;
    }

    public boolean hasConnectionChildren(IHost selectedConnection) {
        return true;
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public void setSubSystemConfigurationProxies(ISubSystemConfigurationProxy[] proxies) {
        this.subsystemConfigurationProxies = proxies;
    }

    public ISubSystemConfigurationProxy[] getSubSystemConfigurationProxies() {
        return this.subsystemConfigurationProxies;
    }

    public ISubSystemConfigurationProxy[] getSubSystemConfigurationProxiesByCategory(String factoryCategory) {
        Vector<ISubSystemConfigurationProxy> v = new Vector<ISubSystemConfigurationProxy>();
        if (this.subsystemConfigurationProxies != null) {
            int idx = 0;
            while (idx < this.subsystemConfigurationProxies.length) {
                if (this.subsystemConfigurationProxies[idx].getCategory().equals(factoryCategory)) {
                    v.addElement(this.subsystemConfigurationProxies[idx]);
                }
                ++idx;
            }
        }
        ISubSystemConfigurationProxy[] proxies = new ISubSystemConfigurationProxy[v.size()];
        int idx = 0;
        while (idx < v.size()) {
            proxies[idx] = (ISubSystemConfigurationProxy)v.elementAt(idx);
            ++idx;
        }
        return proxies;
    }

    public ISubSystemConfigurationProxy[] getSubSystemConfigurationProxiesBySystemType(IRSESystemType systemType) {
        ArrayList<ISubSystemConfigurationProxy> l = new ArrayList<ISubSystemConfigurationProxy>();
        if (this.subsystemConfigurationProxies != null) {
            int idx = 0;
            while (idx < this.subsystemConfigurationProxies.length) {
                if (Arrays.asList(this.subsystemConfigurationProxies[idx].getSystemTypes()).contains(systemType)) {
                    l.add(this.subsystemConfigurationProxies[idx]);
                }
                ++idx;
            }
        }
        return l.toArray(new ISubSystemConfigurationProxy[l.size()]);
    }

    public ISubSystemConfiguration getSubSystemConfiguration(String id) {
        ISubSystemConfigurationProxy[] proxies = this.getSubSystemConfigurationProxies();
        ISubSystemConfiguration match = null;
        int idx = 0;
        while (match == null && idx < proxies.length) {
            if (proxies[idx].getId().equals(id)) {
                match = proxies[idx].getSubSystemConfiguration();
            }
            ++idx;
        }
        return match;
    }

    public ISubSystemConfiguration[] getSubSystemConfigurationsBySystemType(IRSESystemType systemType, boolean filterDuplicateServiceSubSystemFactories) {
        return this.getSubSystemConfigurationsBySystemType(systemType, filterDuplicateServiceSubSystemFactories, true);
    }

    public ISubSystemConfiguration[] getSubSystemConfigurationsBySystemType(IRSESystemType systemType, boolean filterDuplicates, boolean activate) {
        ArrayList<ISubSystemConfiguration> configurations = new ArrayList<ISubSystemConfiguration>();
        if (this.subsystemConfigurationProxies != null) {
            HashSet<Class> serviceTypes = new HashSet<Class>();
            int idx = 0;
            while (idx < this.subsystemConfigurationProxies.length) {
                ISubSystemConfiguration configuration;
                ISubSystemConfigurationProxy subsystemConfigurationProxy = this.subsystemConfigurationProxies[idx];
                if (subsystemConfigurationProxy.appliesToSystemType(systemType) && (activate || subsystemConfigurationProxy.isSubSystemConfigurationActive()) && (configuration = subsystemConfigurationProxy.getSubSystemConfiguration()) != null) {
                    Class serviceType = configuration.getServiceType();
                    if (filterDuplicates && serviceType != null) {
                        if (!serviceTypes.contains(serviceType)) {
                            serviceTypes.add(serviceType);
                            configurations.add(configuration);
                        }
                    } else {
                        configurations.add(configuration);
                    }
                }
                ++idx;
            }
        }
        ISubSystemConfiguration[] result = configurations.toArray(new ISubSystemConfiguration[configurations.size()]);
        return result;
    }

    public ISystemProfileManager getSystemProfileManager() {
        return SystemProfileManager.getDefault();
    }

    public ISystemProfile[] getActiveSystemProfiles() {
        return this.getSystemProfileManager().getActiveSystemProfiles();
    }

    public ISystemProfile getSystemProfile(String profileName) {
        return this.getSystemProfileManager().getSystemProfile(profileName);
    }

    public ISystemProfile createSystemProfile(String profileName, boolean makeActive) throws Exception {
        ISystemProfileManager mgr = this.getSystemProfileManager();
        ISystemProfile profile = mgr.createSystemProfile(profileName, makeActive);
        this.fireModelChangeEvent(1, 1, profile, null);
        return profile;
    }

    public void renameSystemProfile(ISystemProfile profile, String newName) throws Exception {
        int idx;
        this.loadAll();
        ISubSystemConfigurationProxy[] proxies = this.getSubSystemConfigurationProxies();
        IHost[] connections = this.getHostsByProfile(profile);
        String oldName = profile.getName();
        if (proxies != null) {
            int idx2 = 0;
            while (idx2 < proxies.length) {
                if (proxies[idx2] != null && proxies[idx2].getSubSystemConfiguration() != null) {
                    proxies[idx2].getSubSystemConfiguration().preTestRenameSubSystemProfile(oldName);
                }
                ++idx2;
            }
        }
        ISystemHostPool profilePool = this.getHostPool(profile);
        profilePool.renameHostPool(newName);
        this.getSystemProfileManager().renameSystemProfile(profile, newName);
        if (proxies != null) {
            idx = 0;
            while (idx < proxies.length) {
                ISubSystemConfiguration factory = proxies[idx].getSubSystemConfiguration();
                if (factory != null) {
                    factory.renameSubSystemProfile(oldName, newName);
                }
                ++idx;
            }
        }
        idx = 0;
        while (idx < connections.length) {
            ISubSystem[] subsystems = this.getSubSystems(connections[idx]);
            int jdx = 0;
            while (jdx < subsystems.length) {
                ISubSystem ss = subsystems[jdx];
                ISubSystemConfiguration ssf = ss.getSubSystemConfiguration();
                ssf.renameSubSystemProfile(ss, oldName, newName);
                ++jdx;
            }
            ++idx;
        }
        this.fireModelChangeEvent(8, 1, profile, oldName);
    }

    public ISystemProfile copySystemProfile(ISystemProfile profile, String newName, boolean makeActive, IProgressMonitor monitor) throws Exception {
        Exception lastExc = null;
        boolean failed = false;
        String msg = null;
        String oldName = profile.getName();
        IHost[] newConns = null;
        this.loadAll();
        IHost[] conns = this.getHostsByProfile(profile);
        Vector factories = this.getSubSystemFactories(conns);
        if (this.errorLoadingFactory) {
            return null;
        }
        ISystemProfile newProfile = this.getSystemProfileManager().cloneSystemProfile(profile, newName);
        try {
            ISystemHostPool oldPool = this.getHostPool(profile);
            ISystemHostPool newPool = this.getHostPool(newProfile);
            if (conns != null && conns.length > 0) {
                newConns = new IHost[conns.length];
                String msgNoSubs = RSECoreMessages.MSG_COPYCONNECTION_PROGRESS;
                int idx = 0;
                while (idx < conns.length) {
                    msg = NLS.bind((String)msgNoSubs, (Object)conns[idx].getAliasName());
                    RSECorePlugin.getDefault().getLogger().logDebugMessage(this.getClass().getName(), msg);
                    monitor.subTask(msg);
                    newConns[idx] = oldPool.cloneHost(newPool, conns[idx], conns[idx].getAliasName());
                    monitor.worked(1);
                    ++idx;
                }
            }
            msg = RSECoreMessages.MSG_COPYFILTERPOOLS_PROGRESS;
            monitor.subTask(msg);
            RSECorePlugin.getDefault().getLogger().logDebugMessage(this.getClass().getName(), msg);
            int idx = 0;
            while (idx < factories.size()) {
                ISubSystemConfiguration factory = (ISubSystemConfiguration)factories.elementAt(idx);
                msg = "Copying filterPools for factory " + factory.getName();
                RSECorePlugin.getDefault().getLogger().logDebugMessage(this.getClass().getName(), msg);
                factory.copyFilterPoolManager(profile, newProfile);
                ++idx;
            }
            monitor.worked(1);
            msg = RSECoreMessages.MSG_COPYSUBSYSTEMS_PROGRESS;
            monitor.subTask(msg);
            RSECorePlugin.getDefault().getLogger().logDebugMessage(this.getClass().getName(), msg);
            if (conns != null && conns.length > 0) {
                ISubSystem[] subsystems = null;
                ISubSystemConfiguration factory = null;
                int idx2 = 0;
                while (idx2 < conns.length) {
                    IHost host = conns[idx2];
                    msg = "Copying subsystems for connection " + host.getAliasName();
                    RSECorePlugin.getDefault().getLogger().logDebugMessage(this.getClass().getName(), msg);
                    subsystems = this.getSubSystems(host);
                    if (subsystems != null && subsystems.length > 0 && newConns != null) {
                        int jdx = 0;
                        while (jdx < subsystems.length) {
                            msg = String.valueOf(msg) + ": subsystem " + subsystems[jdx].getName();
                            RSECorePlugin.getDefault().getLogger().logDebugMessage(this.getClass().getName(), msg);
                            factory = subsystems[jdx].getSubSystemConfiguration();
                            factory.cloneSubSystem(subsystems[jdx], newConns[idx2], true);
                            ++jdx;
                        }
                    }
                    host.clonePropertySets(newConns[idx2]);
                    ++idx2;
                }
            }
            profile.clonePropertySets(newProfile);
            monitor.worked(1);
        }
        catch (Exception exc) {
            failed = true;
            lastExc = exc;
        }
        if (failed) {
            try {
                newProfile.suspend();
                if (newConns != null) {
                    int idx = 0;
                    while (idx < newConns.length) {
                        this.deleteHost(newConns[idx]);
                        ++idx;
                    }
                }
                int idx = 0;
                while (idx < this.subsystemConfigurationProxies.length) {
                    ISubSystemConfiguration factory = this.subsystemConfigurationProxies[idx].getSubSystemConfiguration();
                    if (factory != null) {
                        factory.deletingSystemProfile(newProfile);
                    }
                    ++idx;
                }
                this.getSystemProfileManager().deleteSystemProfile(newProfile, true);
            }
            catch (Exception exc) {
                RSECorePlugin.getDefault().getLogger().logError("Exception (ignored) cleaning up from copy-profile exception.", exc);
            }
            throw lastExc;
        }
        this.fireModelChangeEvent(1, 1, newProfile, null);
        RSECorePlugin.getDefault().getLogger().logDebugMessage(this.getClass().getName(), "Copy of system profile " + oldName + " to " + newName + " successful");
        return newProfile;
    }

    public void deleteSystemProfile(ISystemProfile profile) throws Exception {
        ISystemProfileManager manager = this.getSystemProfileManager();
        ISystemProfile defaultProfile = manager.getDefaultPrivateSystemProfile();
        if (profile != defaultProfile) {
            profile.suspend();
            this.loadAll();
            Object[] connections = this.getHostsByProfile(profile);
            int idx = 0;
            while (idx < connections.length) {
                this.deleteHost(connections[idx]);
                ++idx;
            }
            if (this.subsystemConfigurationProxies != null) {
                idx = 0;
                while (idx < this.subsystemConfigurationProxies.length) {
                    ISubSystemConfiguration factory = this.subsystemConfigurationProxies[idx].getSubSystemConfiguration();
                    if (factory != null) {
                        factory.deletingSystemProfile(profile);
                    }
                    ++idx;
                }
            }
            manager.deleteSystemProfile(profile, true);
            if (connections.length > 0) {
                SystemResourceChangeEvent event = new SystemResourceChangeEvent(connections, 60, (Object)this);
                this.fireEvent(event);
            }
            this.fireModelChangeEvent(2, 1, profile, null);
        }
    }

    public void setSystemProfileActive(ISystemProfile profile, boolean makeActive) {
        ISystemProfileManager manager = this.getSystemProfileManager();
        ISystemProfile defaultProfile = manager.getDefaultPrivateSystemProfile();
        if (profile != defaultProfile) {
            ISubSystemConfiguration factory;
            Vector<ISubSystem> activeReferenceVector = new Vector<ISubSystem>();
            if (!makeActive && this.subsystemConfigurationProxies != null) {
                int idx = 0;
                while (idx < this.subsystemConfigurationProxies.length) {
                    ISubSystem[] activeReferences;
                    factory = this.subsystemConfigurationProxies[idx].getSubSystemConfiguration();
                    if (factory != null && (activeReferences = factory.testForActiveReferences(profile)) != null) {
                        int jdx = 0;
                        while (jdx < activeReferences.length) {
                            activeReferenceVector.addElement(activeReferences[jdx]);
                            ++jdx;
                        }
                    }
                    ++idx;
                }
            }
            if (activeReferenceVector.size() > 0) {
                String msg = NLS.bind((String)RSECoreMessages.MSG_LOADING_PROFILE_WARNING_FILTERPOOL_REFS, (Object)profile.getName());
                RSECorePlugin.getDefault().getLogger().logWarning(msg);
                int idx = 0;
                while (idx < activeReferenceVector.size()) {
                    ISubSystem activeReference = (ISubSystem)activeReferenceVector.elementAt(idx);
                    msg = "  " + activeReference.getName();
                    msg = String.valueOf(msg) + NLS.bind((String)RSECoreMessages.MSG_LOADING_PROFILE_WARNING_FILTERPOOL_REF, (Object)activeReference.getHost().getAliasName(), (Object)activeReference.getSystemProfileName());
                    RSECorePlugin.getDefault().getLogger().logWarning(msg);
                    ++idx;
                }
                ISubSystem firstSubSystem = (ISubSystem)activeReferenceVector.elementAt(0);
                String connectionName = String.valueOf(firstSubSystem.getHost().getSystemProfileName()) + "." + firstSubSystem.getHost().getAliasName();
                msg = NLS.bind((String)RSECoreMessages.MSG_LOADING_PROFILE_SHOULDNOTBE_DEACTIVATED, (Object)profile.getName(), (Object)connectionName);
                RSECorePlugin.getDefault().getLogger().logWarning(msg);
            }
            this.getSystemProfileManager().makeSystemProfileActive(profile, makeActive);
            if (this.subsystemConfigurationProxies != null) {
                int idx = 0;
                while (idx < this.subsystemConfigurationProxies.length) {
                    if (this.subsystemConfigurationProxies[idx].isSubSystemConfigurationActive() && (factory = this.subsystemConfigurationProxies[idx].getSubSystemConfiguration()) != null) {
                        factory.changingSystemProfileActiveStatus(profile, makeActive);
                    }
                    ++idx;
                }
            }
            Object[] affectedConnections = this.getHostsByProfile(profile);
            if (!makeActive) {
                if (affectedConnections != null && affectedConnections.length > 0) {
                    int idx = 0;
                    while (idx < affectedConnections.length) {
                        this.disconnectAllSubSystems((IHost)affectedConnections[idx]);
                        ++idx;
                    }
                    SystemResourceChangeEvent event = new SystemResourceChangeEvent(affectedConnections, 60, (Object)this);
                    this.fireEvent(event);
                }
            } else if (affectedConnections != null && affectedConnections.length > 0) {
                SystemResourceChangeEvent event = new SystemResourceChangeEvent(affectedConnections, 51, (Object)this);
                this.fireEvent(event);
            }
            this.fireModelChangeEvent(4, 1, profile, null);
        }
    }

    private ISystemProfile getSystemProfile(ISystemHostPool pool) {
        return pool.getSystemProfile();
    }

    public IConnectorService[] getConnectorServices(IHost host) {
        ArrayList<IConnectorService> services = new ArrayList<IConnectorService>();
        ISubSystem[] subsystems = this.getSubSystems(host);
        int i = 0;
        while (i < subsystems.length) {
            ISubSystem subsystem = subsystems[i];
            IConnectorService service = subsystem.getConnectorService();
            if (!services.contains(service)) {
                services.add(service);
            }
            ++i;
        }
        return services.toArray(new IConnectorService[services.size()]);
    }

    public ISubSystem[] getSubSystems(IHost host, boolean force) {
        return this.getSubSystems(host);
    }

    public ISubSystem[] getSubSystems(IHost host) {
        IRSESystemType systemType = host.getSystemType();
        ArrayList<ISubSystem> subsystems = new ArrayList<ISubSystem>();
        if (this.subsystemConfigurationProxies != null) {
            int i = 0;
            while (i < this.subsystemConfigurationProxies.length) {
                ISubSystemConfigurationProxy proxy = this.subsystemConfigurationProxies[i];
                if (proxy.appliesToSystemType(systemType) && proxy.isSubSystemConfigurationActive()) {
                    ISubSystemConfiguration config = proxy.getSubSystemConfiguration();
                    ISubSystem[] ssArray = config.getSubSystems(host, false);
                    if (ssArray == null) {
                        ssArray = this.createSubSystems(host, new ISubSystemConfiguration[]{config});
                    }
                    subsystems.addAll(Arrays.asList(ssArray));
                }
                ++i;
            }
        }
        ISubSystem[] result = new ISubSystem[subsystems.size()];
        subsystems.toArray(result);
        return result;
    }

    public ISubSystem getSubSystem(String absoluteSubSystemName) {
        ISubSystem result = null;
        int profileDelim = absoluteSubSystemName.indexOf(".");
        int connectionDelim = absoluteSubSystemName.lastIndexOf(":");
        if (profileDelim > 0 && connectionDelim > profileDelim) {
            String srcProfileName = absoluteSubSystemName.substring(0, profileDelim);
            String srcConnectionName = absoluteSubSystemName.substring(profileDelim + 1, connectionDelim);
            String srcSubSystemConfigurationId = absoluteSubSystemName.substring(connectionDelim + 1, absoluteSubSystemName.length());
            ISystemProfile profile = this.getSystemProfile(srcProfileName);
            if (profile != null) {
                result = this.getSubSystem(profile, srcConnectionName, srcSubSystemConfigurationId);
            }
        }
        return result;
    }

    public ISubSystem getSubSystem(ISystemProfile profile, String srcConnectionName, String subsystemConfigurationId) {
        IHost[] connections = this.getHostsByProfile(profile);
        if (connections == null) {
            connections = this.getHosts();
        }
        int i = 0;
        while (i < connections.length) {
            IHost connection = connections[i];
            String connectionName = connection.getAliasName();
            if (connectionName.equals(srcConnectionName)) {
                ISubSystem[] subsystems = this.getSubSystems(connection);
                int s = 0;
                while (s < subsystems.length) {
                    ISubSystem subsystem = subsystems[s];
                    String compareId = subsystem.getConfigurationId();
                    if (compareId.equals(subsystemConfigurationId)) {
                        return subsystem;
                    }
                    if (subsystem.getName().equals(subsystemConfigurationId)) {
                        return subsystem;
                    }
                    ++s;
                }
            }
            ++i;
        }
        return null;
    }

    public String getAbsoluteNameForSubSystem(ISubSystem subSystem) {
        StringBuffer dataStream = new StringBuffer();
        String profileName = subSystem.getSystemProfileName();
        String connectionName = subSystem.getHostAliasName();
        String factoryId = subSystem.getConfigurationId();
        dataStream.append(profileName);
        dataStream.append(".");
        dataStream.append(connectionName);
        dataStream.append(":");
        dataStream.append(factoryId);
        return dataStream.toString();
    }

    public static ISystemDragDropAdapter getSystemDragDropAdapter(Object element) {
        if (element == null) {
            return null;
        }
        Object adapter = null;
        if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = adaptable.getAdapter((Class)clazz)) == null) {
                adapter = Platform.getAdapterManager().getAdapter(element, "org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                if (adapter == null) {
                    return null;
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"Found ISystemViewElementAdapter but no ISystemDragDropAdapter");
                }
            }
        } else {
            IAdapterManager am = Platform.getAdapterManager();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = am.getAdapter(element, clazz.getName())) == null) {
                adapter = am.getAdapter(element, "org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                if (adapter == null) {
                    return null;
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"Found ISystemViewElementAdapter but no ISystemDragDropAdapter");
                }
            }
        }
        return (ISystemDragDropAdapter)adapter;
    }

    public static boolean isSameObjectByAbsoluteName(Object firstObject, String firstObjectFullName, Object secondObject, String secondObjectFullName) {
        if (firstObject == secondObject) {
            return true;
        }
        if (firstObject == null || secondObject == null) {
            return false;
        }
        if (firstObject instanceof SystemMessageObject) {
            return false;
        }
        ISystemDragDropAdapter adA = null;
        ISystemDragDropAdapter adB = null;
        if (firstObjectFullName == null && (adA = SystemRegistry.getSystemDragDropAdapter(firstObject)) != null) {
            firstObjectFullName = adA.getAbsoluteName(firstObject);
        }
        if (secondObjectFullName == null && (adB = SystemRegistry.getSystemDragDropAdapter(secondObject)) != null) {
            secondObjectFullName = adB.getAbsoluteName(secondObject);
        }
        if (firstObjectFullName != null && firstObjectFullName.equals(secondObjectFullName)) {
            ISubSystem ssB;
            ISubSystem ssA;
            if (adA == null) {
                adA = SystemRegistry.getSystemDragDropAdapter(firstObject);
                if (!$assertionsDisabled && adA == null) {
                    throw new AssertionError((Object)("full name \"" + firstObjectFullName + "\" has no ISystemDragDropAdapter!"));
                }
                if (!$assertionsDisabled && !firstObjectFullName.equals(adA.getAbsoluteName(firstObject))) {
                    throw new AssertionError((Object)("full name \"" + firstObjectFullName + "\" differs from adapter response: " + adA.getAbsoluteName(firstObject)));
                }
            }
            if (adB == null) {
                adB = SystemRegistry.getSystemDragDropAdapter(secondObject);
                if (!$assertionsDisabled && adB == null) {
                    throw new AssertionError((Object)("full name \"" + secondObjectFullName + "\" has no ISystemDragDropAdapter!"));
                }
                if (!$assertionsDisabled && !secondObjectFullName.equals(adB.getAbsoluteName(secondObject))) {
                    throw new AssertionError((Object)("full name \"" + firstObjectFullName + "\" differs from adapter response: " + adB.getAbsoluteName(secondObject)));
                }
            }
            return (ssA = adA.getSubSystem(firstObject)) == (ssB = adB.getSubSystem(secondObject));
        }
        return false;
    }

    public String getAbsoluteNameForConnection(IHost connection) {
        StringBuffer dataStream = new StringBuffer();
        String profileName = connection.getSystemProfileName();
        String connectionName = connection.getAliasName();
        dataStream.append(profileName);
        dataStream.append(".");
        dataStream.append(connectionName);
        return dataStream.toString();
    }

    public ISubSystem[] getSubsystems(IHost host, Class subsystemInterface) {
        ArrayList<ISubSystem> matches = new ArrayList<ISubSystem>();
        ISubSystem[] allSS = this.getSubSystems(host);
        int i = 0;
        while (i < allSS.length) {
            ISubSystem ss = allSS[i];
            if (subsystemInterface.isInstance(ss)) {
                matches.add(ss);
            }
            ++i;
        }
        return matches.toArray(new ISubSystem[matches.size()]);
    }

    public ISubSystem[] getServiceSubSystems(IHost host, Class serviceType) {
        ArrayList<ISubSystem> matches = new ArrayList<ISubSystem>();
        ISubSystem[] allSS = this.getSubSystems(host);
        int i = 0;
        while (i < allSS.length) {
            ISubSystem ss = allSS[i];
            Class thisServiceType = ss.getServiceType();
            if (thisServiceType == serviceType) {
                matches.add(ss);
            }
            ++i;
        }
        return matches.toArray(new ISubSystem[matches.size()]);
    }

    public ISubSystem[] getSubSystemsBySubSystemConfigurationCategory(String factoryCategory, IHost host) {
        ISubSystem[] subsystems = this.getSubSystems(host);
        if (subsystems != null && subsystems.length > 0) {
            Vector<ISubSystem> v = new Vector<ISubSystem>();
            int idx = 0;
            while (idx < subsystems.length) {
                if (subsystems[idx].getSubSystemConfiguration().getCategory().equals(factoryCategory)) {
                    v.addElement(subsystems[idx]);
                }
                ++idx;
            }
            ISubSystem[] sss = new ISubSystem[v.size()];
            int idx2 = 0;
            while (idx2 < sss.length) {
                sss[idx2] = (ISubSystem)v.elementAt(idx2);
                ++idx2;
            }
            return sss;
        }
        return new ISubSystem[0];
    }

    public ISubSystemConfiguration[] getSubSystemConfigurations() {
        Vector<ISubSystemConfiguration> v = new Vector<ISubSystemConfiguration>();
        ISubSystemConfigurationProxy[] proxies = this.getSubSystemConfigurationProxies();
        if (proxies != null) {
            int idx = 0;
            while (idx < proxies.length) {
                ISubSystemConfigurationProxy proxy = proxies[idx];
                ISubSystemConfiguration config = proxy.getSubSystemConfiguration();
                if (config != null) {
                    v.add(proxies[idx].getSubSystemConfiguration());
                }
                ++idx;
            }
        }
        ISubSystemConfiguration[] result = new ISubSystemConfiguration[v.size()];
        v.toArray(result);
        return result;
    }

    protected Vector getSubSystemFactories(IHost conn) {
        Vector factories = new Vector();
        this.errorLoadingFactory = false;
        return this.getSubSystemFactories(conn, factories);
    }

    protected Vector getSubSystemFactories(IHost conn, Vector factories) {
        ISubSystem[] subsystems = this.getSubSystems(conn);
        if (subsystems != null) {
            int idx = 0;
            while (idx < subsystems.length) {
                ISubSystemConfiguration ssFactory = subsystems[idx].getSubSystemConfiguration();
                if (ssFactory == null) {
                    this.errorLoadingFactory = true;
                }
                if (ssFactory != null && !factories.contains(ssFactory)) {
                    factories.add(ssFactory);
                }
                ++idx;
            }
        }
        return factories;
    }

    protected Vector getSubSystemFactories(IHost[] conns) {
        Vector factories = new Vector();
        this.errorLoadingFactory = false;
        if (conns != null) {
            int idx = 0;
            while (idx < conns.length) {
                this.getSubSystemFactories(conns[idx], factories);
                ++idx;
            }
        }
        return factories;
    }

    public boolean deleteSubSystem(ISubSystem subsystem) {
        ISubSystemConfiguration ssFactory = subsystem.getSubSystemConfiguration();
        if (ssFactory == null) {
            return false;
        }
        boolean ok = ssFactory.deleteSubSystem(subsystem);
        return ok;
    }

    private ISystemHostPool getHostPool(String profileName) {
        ISystemProfile profile = this.getSystemProfileManager().getSystemProfile(profileName);
        if (profile == null) {
            return null;
        }
        return this.getHostPool(profile);
    }

    private ISystemHostPool getHostPool(ISystemProfile profile) {
        ISystemHostPool result = SystemHostPool.getSystemHostPool(profile);
        return result;
    }

    private ISystemHostPool[] getHostPools() {
        ISystemProfile[] profiles = this.getSystemProfileManager().getActiveSystemProfiles();
        ISystemHostPool[] pools = new ISystemHostPool[profiles.length];
        int idx = 0;
        while (idx < pools.length) {
            try {
                pools[idx] = SystemHostPool.getSystemHostPool(profiles[idx]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++idx;
        }
        return pools;
    }

    public IHost getLocalHost() {
        IHost localConn = null;
        IRSESystemType localType = RSECorePlugin.getTheCoreRegistry().getSystemTypeById("org.eclipse.rse.systemtype.local");
        IHost[] conns = this.getHostsBySystemType(localType);
        if (conns != null && conns.length > 0) {
            return conns[0];
        }
        return localConn;
    }

    public IHost[] getHosts() {
        ISystemHostPool[] pools = this.getHostPools();
        ArrayList<IHost> hosts = new ArrayList<IHost>();
        int idx = 0;
        while (idx < pools.length) {
            IHost[] conns = pools[idx].getHosts();
            if (conns != null) {
                int jdx = 0;
                while (jdx < conns.length) {
                    if (!$assertionsDisabled && conns[jdx] == null) {
                        throw new AssertionError((Object)("Null host in pool " + pools[idx].getName() + " at " + jdx));
                    }
                    hosts.add(conns[jdx]);
                    ++jdx;
                }
            }
            ++idx;
        }
        IHost[] allConns = hosts.toArray(new IHost[hosts.size()]);
        return allConns;
    }

    public IHost[] getHostsByProfile(ISystemProfile profile) {
        ISystemHostPool pool = this.getHostPool(profile);
        return pool.getHosts();
    }

    public IHost[] getHostsBySubSystemConfiguration(ISubSystemConfiguration factory) {
        ISubSystem[] subsystems = factory.getSubSystems(true);
        Vector<IHost> v = new Vector<IHost>();
        int idx = 0;
        while (idx < subsystems.length) {
            IHost conn = subsystems[idx].getHost();
            if (!v.contains(conn)) {
                v.addElement(conn);
            }
            ++idx;
        }
        IHost[] conns = new IHost[v.size()];
        int idx2 = 0;
        while (idx2 < v.size()) {
            conns[idx2] = (IHost)v.elementAt(idx2);
            ++idx2;
        }
        return conns;
    }

    public IHost[] getHostsBySubSystemConfigurationCategory(String factoryCategory) {
        Vector<IHost> v = new Vector<IHost>();
        if (this.subsystemConfigurationProxies != null) {
            int idx = 0;
            while (idx < this.subsystemConfigurationProxies.length) {
                ISubSystem[] subsystems;
                ISubSystemConfiguration factory;
                if (this.subsystemConfigurationProxies[idx].getCategory().equals(factoryCategory) && (factory = this.subsystemConfigurationProxies[idx].getSubSystemConfiguration()) != null && (subsystems = factory.getSubSystems(true)) != null) {
                    int jdx = 0;
                    while (jdx < subsystems.length) {
                        IHost conn = subsystems[jdx].getHost();
                        if (!v.contains(conn)) {
                            v.addElement(conn);
                        }
                        ++jdx;
                    }
                }
                ++idx;
            }
        }
        IHost[] conns = new IHost[v.size()];
        int idx = 0;
        while (idx < v.size()) {
            conns[idx] = (IHost)v.elementAt(idx);
            ++idx;
        }
        return conns;
    }

    public IHost[] getHostsBySystemType(IRSESystemType systemType) {
        ArrayList<IHost> connections = new ArrayList<IHost>();
        if (systemType != null) {
            IHost[] candidates = this.getHosts();
            int i = 0;
            while (i < candidates.length) {
                IHost candidate = candidates[i];
                IRSESystemType candidateType = candidate.getSystemType();
                if (systemType.equals(candidateType)) {
                    connections.add(candidate);
                }
                ++i;
            }
        }
        return connections.toArray(new IHost[connections.size()]);
    }

    public IHost[] getHostsBySystemTypes(IRSESystemType[] systemTypes) {
        List<IRSESystemType> systemTypesList = Arrays.asList(systemTypes);
        IHost[] connections = this.getHosts();
        Vector<IHost> v = new Vector<IHost>();
        int idx = 0;
        while (idx < connections.length) {
            IRSESystemType systemType = connections[idx].getSystemType();
            if (systemTypesList.contains(systemType)) {
                v.addElement(connections[idx]);
            }
            ++idx;
        }
        return v.toArray(new IHost[v.size()]);
    }

    public IHost getHost(ISystemProfile profile, String connectionName) {
        return this.getHostPool(profile).getHost(connectionName);
    }

    public int getHostPosition(IHost conn) {
        ISystemHostPool pool = conn.getHostPool();
        return pool.getHostPosition(conn);
    }

    public int getHostPositionInView(IHost conn) {
        IHost[] conns = this.getHosts();
        int pos = -1;
        int idx = 0;
        while (pos == -1 && idx < conns.length) {
            if (conns[idx] == conn) {
                pos = idx;
            }
            ++idx;
        }
        return pos;
    }

    public int getHostCount(ISystemProfile profile) {
        return this.getHostPool(profile).getHostCount();
    }

    public int getHostCountWithinProfile(IHost conn) {
        return conn.getHostPool().getHostCount();
    }

    public int getHostCount() {
        ISystemHostPool[] pools = this.getHostPools();
        int total = 0;
        int idx = 0;
        while (idx < pools.length) {
            total += pools[idx].getHostCount();
            ++idx;
        }
        return total;
    }

    public Vector getHostAliasNames(ISystemProfile profile) {
        ISystemHostPool pool = this.getHostPool(profile);
        Vector<String> names = new Vector<String>();
        IHost[] conns = pool.getHosts();
        int idx = 0;
        while (idx < conns.length) {
            names.addElement(conns[idx].getAliasName());
            ++idx;
        }
        return names;
    }

    public Vector getHostAliasNamesForAllActiveProfiles() {
        ISystemHostPool[] allPools = this.getHostPools();
        Vector allNames = new Vector();
        int idx = 0;
        while (idx < allPools.length) {
            Vector v = this.getHostAliasNames(this.getSystemProfile(allPools[idx]));
            int jdx = 0;
            while (jdx < v.size()) {
                allNames.addElement(v.elementAt(jdx));
                ++jdx;
            }
            ++idx;
        }
        return allNames;
    }

    public String[] getHostNames(IRSESystemType systemType) {
        Vector<String> v = new Vector<String>();
        if (systemType != null) {
            IHost[] conns = this.getHosts();
            int idx = 0;
            while (idx < conns.length) {
                if (conns[idx].getHostName() != null && !v.contains(conns[idx].getHostName()) && conns[idx].getSystemType().equals(systemType)) {
                    v.addElement(conns[idx].getHostName());
                }
                ++idx;
            }
        }
        if (systemType != null && systemType.isLocal() && v.size() == 0) {
            v.addElement("localhost");
        }
        return v.toArray(new String[v.size()]);
    }

    public IHost createLocalHost(ISystemProfile profile, String name, String userId) {
        IHost localConn = null;
        if (profile == null) {
            profile = this.getSystemProfileManager().getDefaultPrivateSystemProfile();
        }
        if (profile == null) {
            profile = this.getSystemProfileManager().getActiveSystemProfiles()[0];
        }
        try {
            IRSESystemType localType = RSECorePlugin.getTheCoreRegistry().getSystemTypeById("org.eclipse.rse.systemtype.local");
            localConn = this.createHost(profile.getName(), localType, name, "localhost", "", userId, 3, null);
        }
        catch (Exception exc) {
            RSECorePlugin.getDefault().getLogger().logError("Error creating local connection", exc);
        }
        return localConn;
    }

    public IHost createHost(String profileName, IRSESystemType systemType, String connectionName, String hostName, String description, String defaultUserId, int defaultUserIdLocation, ISubSystemConfigurator[] configurators) throws Exception {
        return this.createHost(profileName, systemType, connectionName, hostName, description, defaultUserId, defaultUserIdLocation, true, configurators);
    }

    public IHost createHost(String profileName, IRSESystemType systemType, String hostName, String hostAddress, String description, String defaultUserId, int defaultUserIdLocation, boolean createSubSystems, ISubSystemConfigurator[] configurators) throws Exception {
        SystemRegistry sr = this;
        class CreateHostOperation
        implements ISystemProfileOperation {
            private IHost host;
            private ISubSystem[] subsystems;
            final /* synthetic */ SystemRegistry this$0;
            private final /* synthetic */ String val$profileName;
            private final /* synthetic */ String val$defaultUserId;
            private final /* synthetic */ IRSESystemType val$systemType;
            private final /* synthetic */ String val$hostName;
            private final /* synthetic */ String val$hostAddress;
            private final /* synthetic */ String val$description;
            private final /* synthetic */ int val$defaultUserIdLocation;
            private final /* synthetic */ boolean val$createSubSystems;
            private final /* synthetic */ ISubSystemConfigurator[] val$configurators;

            CreateHostOperation(SystemRegistry systemRegistry, String string, String string2, IRSESystemType iRSESystemType, String string3, String string4, String string5, int n, boolean bl, ISubSystemConfigurator[] iSubSystemConfiguratorArray) {
                this.this$0 = systemRegistry;
                this.val$profileName = string;
                this.val$defaultUserId = string2;
                this.val$systemType = iRSESystemType;
                this.val$hostName = string3;
                this.val$hostAddress = string4;
                this.val$description = string5;
                this.val$defaultUserIdLocation = n;
                this.val$createSubSystems = bl;
                this.val$configurators = iSubSystemConfiguratorArray;
                this.host = null;
                this.subsystems = new ISubSystem[0];
            }

            IHost getHost() {
                return this.host;
            }

            public ISubSystem[] getSubSystems() {
                return this.subsystems;
            }

            public IStatus run() {
                IStatus status = Status.OK_STATUS;
                ISystemHostPool pool = SystemRegistry.access$4(this.this$0, this.val$profileName);
                try {
                    String uid = this.val$defaultUserId;
                    if (uid != null && uid.length() == 0) {
                        uid = null;
                    }
                    this.host = pool.createHost(this.val$systemType, this.val$hostName, this.val$hostAddress, this.val$description, uid, this.val$defaultUserIdLocation);
                    if (this.host == null) {
                        this.host = pool.getHost(this.val$hostName);
                    }
                }
                catch (Exception e) {
                    String pluginId = RSECorePlugin.getDefault().getBundle().getSymbolicName();
                    String message = NLS.bind((String)RSECoreMessages.MSG_CREATEHOST_EXCEPTION, (Object)this.val$hostName);
                    status = new Status(4, pluginId, message, (Throwable)e);
                }
                if (status.isOK()) {
                    if (this.val$createSubSystems) {
                        ISubSystemConfiguration[] configsArray;
                        List<Object> configs = new ArrayList<ISubSystemConfiguration>(10);
                        if (this.val$configurators != null) {
                            int i = 0;
                            while (i < this.val$configurators.length) {
                                configs.add(this.val$configurators[i].getSubSystemConfiguration());
                                ++i;
                            }
                            configsArray = this.this$0.getSubSystemConfigurationsBySystemType(this.val$systemType, false);
                            int i2 = 0;
                            while (i2 < configsArray.length) {
                                boolean isAbsent;
                                ISubSystemConfiguration config = configsArray[i2];
                                boolean isStrange = config.getServiceType() == null;
                                boolean bl = isAbsent = !configs.contains(config);
                                if (isStrange && isAbsent) {
                                    configs.add(config);
                                }
                                ++i2;
                            }
                        } else {
                            configsArray = this.this$0.getSubSystemConfigurationsBySystemType(this.val$systemType, true);
                            configs = Arrays.asList(configsArray);
                        }
                        this.subsystems = new ISubSystem[configs.size()];
                        ISystemProfile profile = this.host.getSystemProfile();
                        int i = 0;
                        Iterator<Object> z = configs.iterator();
                        while (z.hasNext()) {
                            ISubSystemConfiguration config = (ISubSystemConfiguration)z.next();
                            config.getFilterPoolManager(profile, true);
                            ISubSystemConfigurator[] interestingPages = SystemRegistry.access$5(this.this$0, config, this.val$configurators);
                            this.subsystems[i] = config.createSubSystem(this.host, true, interestingPages);
                            ++i;
                        }
                    }
                    this.host.commit();
                }
                return status;
            }
        }
        CreateHostOperation op = new CreateHostOperation(this, profileName, defaultUserId, systemType, hostName, hostAddress, description, defaultUserIdLocation, createSubSystems, configurators);
        IStatus status = SystemProfileManager.run(op);
        lastException = (Exception)status.getException();
        if (lastException != null) {
            RSECorePlugin.getDefault().getLogger().logError(status.getMessage(), lastException);
            throw lastException;
        }
        IHost host = op.getHost();
        if (this.modelListenerManager.hasListeners()) {
            ISubSystem[] subsystems = op.getSubSystems();
            FireNewHostEvents fire = new FireNewHostEvents(host, subsystems, sr, configurators != null);
            Display.getDefault().asyncExec((Runnable)fire);
        }
        return host;
    }

    public ISubSystem[] createSubSystems(IHost host, ISubSystemConfiguration[] configurations) {
        ISubSystem[] subsystems = new ISubSystem[configurations.length];
        int i = 0;
        while (i < configurations.length) {
            subsystems[i] = configurations[i].createSubSystem(host, true, null);
            ++i;
        }
        int j = 0;
        while (j < subsystems.length) {
            if (subsystems[j] != null) {
                this.fireModelChangeEvent(1, 4, subsystems[j], null);
            }
            ++j;
        }
        host.commit();
        return subsystems;
    }

    private ISubSystemConfigurator[] getApplicableConfigurators(ISubSystemConfiguration ssf, ISubSystemConfigurator[] allPages) {
        if (allPages == null || allPages.length == 0) {
            return null;
        }
        int count = 0;
        int idx = 0;
        while (idx < allPages.length) {
            if (allPages[idx].getSubSystemConfiguration() == ssf) {
                ++count;
            }
            ++idx;
        }
        if (count == 0) {
            return null;
        }
        ISubSystemConfigurator[] subPages = new ISubSystemConfigurator[count];
        count = 0;
        int idx2 = 0;
        while (idx2 < allPages.length) {
            if (allPages[idx2].getSubSystemConfiguration() == ssf) {
                subPages[count++] = allPages[idx2];
            }
            ++idx2;
        }
        return subPages;
    }

    public IHost createHost(String profileName, IRSESystemType systemType, String connectionName, String hostName, String description) throws Exception {
        return this.createHost(profileName, systemType, connectionName, hostName, description, true);
    }

    public IHost createHost(String profileName, IRSESystemType systemType, String connectionName, String hostName, String description, boolean createSubSystems) throws Exception {
        return this.createHost(profileName, systemType, connectionName, hostName, description, null, 2, createSubSystems, null);
    }

    public IHost createHost(IRSESystemType systemType, String connectionName, String hostName, String description) throws Exception {
        ISystemProfile profile = this.getSystemProfileManager().getDefaultPrivateSystemProfile();
        if (profile == null) {
            profile = this.getSystemProfileManager().getActiveSystemProfiles()[0];
        }
        return this.createHost(profile.getName(), systemType, connectionName, hostName, description);
    }

    protected IHost getPreviousHost(IHost conn) {
        IHost prevConn = null;
        ISystemHostPool pool = conn.getHostPool();
        int pos = pool.getHostPosition(conn);
        if (pos > 0) {
            prevConn = pool.getHost(pos - 1);
        } else {
            IHost[] allConns = this.getHosts();
            if (allConns != null && (pos = this.getHostPositionInView(conn)) > 0) {
                prevConn = allConns[pos - 1];
            }
        }
        return prevConn;
    }

    public void updateHost(IHost conn, IRSESystemType systemType, String connectionName, String hostName, String description, String defaultUserId, int defaultUserIdLocation) {
        boolean skipUpdate;
        lastException = null;
        boolean connectionNameChanged = !connectionName.equalsIgnoreCase(conn.getAliasName());
        boolean hostNameChanged = !hostName.equalsIgnoreCase(conn.getHostName());
        String orgDefaultUserId = conn.getDefaultUserId();
        boolean defaultUserIdChanged = false;
        if (defaultUserId == null || orgDefaultUserId == null) {
            if (orgDefaultUserId != defaultUserId) {
                defaultUserIdChanged = true;
            }
        } else {
            defaultUserIdChanged = !conn.compareUserIds(defaultUserId, orgDefaultUserId);
        }
        try {
            if (connectionNameChanged) {
                this.renameHost(conn, connectionName);
            }
            conn.getHostPool().updateHost(conn, systemType, connectionName, hostName, description, defaultUserId, defaultUserIdLocation);
        }
        catch (SystemMessageException exc) {
            RSECorePlugin.getDefault().getLogger().logError("Exception in updateConnection for " + connectionName, exc);
            lastException = exc;
            return;
        }
        catch (Exception exc) {
            RSECorePlugin.getDefault().getLogger().logError("Exception in updateConnection for " + connectionName, exc);
            lastException = exc;
            return;
        }
        boolean bl = skipUpdate = defaultUserIdChanged && !hostNameChanged && !connectionNameChanged;
        if (!skipUpdate) {
            this.fireEvent(new SystemResourceChangeEvent(conn, 86, (Object)this));
        }
        if (!skipUpdate) {
            this.fireModelChangeEvent(4, 2, conn, null);
        }
        if (hostNameChanged || defaultUserIdChanged) {
            ISubSystem[] subsystems = this.getSubSystems(conn);
            int idx = 0;
            while (idx < subsystems.length) {
                if (hostNameChanged || subsystems[idx].getConnectorService().supportsUserId() && subsystems[idx].getLocalUserId() == null) {
                    try {
                        if (hostNameChanged && subsystems[idx].isConnected()) {
                            subsystems[idx].disconnect();
                        }
                        if (defaultUserIdChanged && !subsystems[idx].isConnected()) {
                            subsystems[idx].getConnectorService().clearCredentials();
                        }
                        subsystems[idx].getConnectorService().clearPassword(false, true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++idx;
            }
        }
    }

    public void setHostOffline(IHost conn, boolean offline) {
        if (conn.isOffline() != offline) {
            conn.setOffline(offline);
            this.saveHost(conn);
            this.fireEvent(new SystemResourceChangeEvent(conn, 87, null));
        }
    }

    public void deleteHost(IHost conn) {
        Vector affectedSubSystemFactories = this.getSubSystemFactories(conn);
        int idx = 0;
        while (idx < affectedSubSystemFactories.size()) {
            ((ISubSystemConfiguration)affectedSubSystemFactories.elementAt(idx)).deleteSubSystemsByConnection(conn);
            ++idx;
        }
        conn.getHostPool().deleteHost(conn);
        this.fireModelChangeEvent(2, 2, conn, null);
    }

    public void renameHost(IHost conn, String newName) throws Exception {
        String oldName = conn.getAliasName();
        ISubSystem[] subsystems = conn.getSubSystems();
        int i = 0;
        while (i < subsystems.length) {
            ISubSystem ss = subsystems[i];
            ss.getSubSystemConfiguration().renameSubSystemsByConnection(conn, newName);
            ++i;
        }
        conn.getHostPool().renameHost(conn, newName);
        this.fireModelChangeEvent(8, 2, conn, oldName);
    }

    public void moveHosts(String profileName, IHost[] conns, int delta) {
        ISystemHostPool pool = this.getHostPool(profileName);
        pool.moveHosts(conns, delta);
        SystemResourceChangeEvent event = new SystemResourceChangeEvent(conns, 75, (Object)this);
        event.setPosition(delta);
        this.fireEvent(event);
        int idx = 0;
        while (idx < conns.length) {
            this.fireModelChangeEvent(16, 2, conns[idx], null);
            ++idx;
        }
    }

    public IHost copyHost(IHost conn, ISystemProfile targetProfile, String newName, IProgressMonitor monitor) throws Exception {
        IHost newConn;
        String oldName;
        String msg;
        boolean failed;
        Exception lastExc;
        block11: {
            lastExc = null;
            failed = false;
            msg = null;
            oldName = conn.getAliasName();
            ISystemHostPool oldPool = conn.getHostPool();
            ISystemHostPool targetPool = this.getHostPool(targetProfile);
            newConn = null;
            RSECorePlugin.getDefault().getLogger().logDebugMessage(this.getClass().getName(), "Start of system connection copy. From: " + oldName + " to: " + newName);
            this.getSubSystemFactories(conn);
            if (this.errorLoadingFactory) {
                return null;
            }
            newConn = oldPool.cloneHost(targetPool, conn, newName);
            if (newConn != null) break block11;
            return null;
        }
        try {
            msg = RSECoreMessages.MSG_COPYSUBSYSTEMS_PROGRESS;
            RSECorePlugin.getDefault().getLogger().logDebugMessage(this.getClass().getName(), msg);
            ISubSystem[] subsystems = null;
            ISubSystemConfiguration factory = null;
            msg = "Copying subsystems for connection " + conn.getAliasName();
            RSECorePlugin.getDefault().getLogger().logDebugMessage(this.getClass().getName(), msg);
            subsystems = this.getSubSystems(conn);
            if (subsystems != null && subsystems.length > 0) {
                int jdx = 0;
                while (jdx < subsystems.length) {
                    msg = String.valueOf(msg) + ": subsystem " + subsystems[jdx].getName();
                    RSECorePlugin.getDefault().getLogger().logDebugMessage(this.getClass().getName(), msg);
                    factory = subsystems[jdx].getSubSystemConfiguration();
                    factory.cloneSubSystem(subsystems[jdx], newConn, false);
                    ++jdx;
                }
            }
        }
        catch (Exception exc) {
            failed = true;
            lastExc = exc;
        }
        if (failed) {
            try {
                if (newConn != null) {
                    this.deleteHost(newConn);
                }
            }
            catch (Exception exc) {
                RSECorePlugin.getDefault().getLogger().logError("Exception (ignored) cleaning up from copy-connection exception.", exc);
            }
            throw lastExc;
        }
        RSECorePlugin.getDefault().getLogger().logDebugMessage(this.getClass().getName(), "Copy of system connection " + oldName + " to " + newName + " successful");
        if (this.getSystemProfileManager().isSystemProfileActive(targetProfile.getName())) {
            int eventType = 53;
            SystemResourceChangeEvent event = new SystemResourceChangeEvent(newConn, eventType, (Object)this);
            event.setRelativePrevious(this.getPreviousHost(newConn));
            this.fireEvent(event);
        }
        this.fireModelChangeEvent(1, 2, newConn, null);
        return newConn;
    }

    public IHost moveHost(IHost conn, ISystemProfile targetProfile, String newName, IProgressMonitor monitor) throws Exception {
        IHost newConn = null;
        newConn = this.copyHost(conn, targetProfile, newName, monitor);
        if (newConn != null) {
            this.deleteHost(conn);
            RSECorePlugin.getDefault().getLogger().logDebugMessage(this.getClass().getName(), "Move of system connection " + conn.getAliasName() + " to profile " + targetProfile.getName() + " successful");
            this.fireEvent(new SystemResourceChangeEvent(conn, 55, (Object)this));
        }
        return newConn;
    }

    public boolean isAnySubSystemSupportsConnect(IHost conn) {
        Vector v = this.getSubSystemFactories(conn);
        if (v != null) {
            Iterator iter = v.iterator();
            while (iter.hasNext()) {
                ISubSystemConfiguration config;
                Object obj = iter.next();
                if (!(obj instanceof ISubSystemConfiguration) || !(config = (ISubSystemConfiguration)obj).supportsSubSystemConnect()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAnySubSystemConnected(IHost conn) {
        boolean any = false;
        ISubSystem[] subsystems = this.getSubSystems(conn);
        if (subsystems == null) {
            return false;
        }
        int idx = 0;
        while (!any && idx < subsystems.length) {
            ISubSystem ss = subsystems[idx];
            if (ss.isConnected()) {
                any = true;
            }
            ++idx;
        }
        return any;
    }

    public boolean hasInactiveSubsystemConfigurations(IRSESystemType systemType) {
        if (this.subsystemConfigurationProxies != null) {
            int idx = 0;
            while (idx < this.subsystemConfigurationProxies.length) {
                if (!this.subsystemConfigurationProxies[idx].isSubSystemConfigurationActive() && this.subsystemConfigurationProxies[idx].appliesToSystemType(systemType)) {
                    return true;
                }
                ++idx;
            }
        }
        return false;
    }

    public boolean areAllSubSystemsConnected(IHost conn) {
        boolean all = true;
        if (this.hasInactiveSubsystemConfigurations(conn.getSystemType())) {
            return false;
        }
        ISubSystem[] subsystems = this.getSubSystems(conn);
        if (subsystems == null) {
            return true;
        }
        int idx = 0;
        while (all && idx < subsystems.length) {
            ISubSystem ss = subsystems[idx];
            if (!ss.isConnected() && ss.getSubSystemConfiguration().supportsSubSystemConnect()) {
                return false;
            }
            ++idx;
        }
        return all;
    }

    public void disconnectAllSubSystems(IHost conn) {
        ISubSystem[] subsystems = this.getSubSystems(conn);
        if (subsystems == null) {
            return;
        }
        boolean cancelled = false;
        int idx = 0;
        while (idx < subsystems.length && !cancelled) {
            ISubSystem ss = subsystems[idx];
            if (ss.isConnected() && ss.getSubSystemConfiguration().supportsSubSystemConnect()) {
                try {
                    ss.disconnect();
                }
                catch (InterruptedException exc) {
                    System.out.println("Cancelled");
                    cancelled = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++idx;
        }
    }

    public void connectedStatusChange(ISubSystem subsystem, boolean connected, boolean wasConnected) {
        this.connectedStatusChange(subsystem, connected, wasConnected, true);
    }

    public void connectedStatusChange(ISubSystem subsystem, boolean connected, boolean wasConnected, boolean collapseTree) {
        IHost conn = subsystem.getHost();
        IConnectorService effectedConnectorService = subsystem.getConnectorService();
        if (connected != wasConnected) {
            int eventId = 81;
            this.fireEvent(new SystemResourceChangeEvent(conn, eventId, (Object)this));
            SystemResourceChangeEvent event = new SystemResourceChangeEvent(subsystem, eventId, (Object)conn);
            this.fireEvent(event);
            ISubSystem[] sses = this.getSubSystems(conn);
            int i = 0;
            while (i < sses.length) {
                ISubSystem ss = sses[i];
                if (ss != subsystem && ss.getConnectorService().equals(effectedConnectorService)) {
                    SystemResourceChangeEvent sevent = new SystemResourceChangeEvent(ss, eventId, (Object)conn);
                    this.fireEvent(sevent);
                    sevent.setType(86);
                    this.fireEvent(sevent);
                }
                ++i;
            }
            event.setType(86);
            this.fireEvent(event);
        }
        if (!connected && wasConnected && collapseTree) {
            this.invalidateFiltersFor(subsystem);
            this.fireEvent(new SystemResourceChangeEvent(subsystem, 90, (Object)this));
            ISubSystem[] sses = this.getSubSystems(conn);
            int i = 0;
            while (i < sses.length) {
                ISubSystem ss = sses[i];
                if (ss != subsystem && ss.getConnectorService().equals(effectedConnectorService) && !ss.isConnected()) {
                    this.invalidateFiltersFor(ss);
                    SystemResourceChangeEvent sevent = new SystemResourceChangeEvent(ss, 90, (Object)conn);
                    this.fireEvent(sevent);
                }
                ++i;
            }
        }
    }

    public void addSystemResourceChangeListener(ISystemResourceChangeListener l) {
        this.listenerManager.addSystemResourceChangeListener(l);
    }

    public void removeSystemResourceChangeListener(ISystemResourceChangeListener l) {
        this.listenerManager.removeSystemResourceChangeListener(l);
    }

    public boolean isRegisteredSystemResourceChangeListener(ISystemResourceChangeListener l) {
        return this.listenerManager.isRegisteredSystemResourceChangeListener(l);
    }

    public void fireEvent(ISystemResourceChangeEvent event) {
        Object src = event.getSource();
        if (src instanceof ISystemFilter) {
            IRSEBaseReferencingObject[] references = ((ISystemFilter)src).getReferencingObjects();
            int i = 0;
            while (i < references.length) {
                IRSEBaseReferencingObject ref = references[i];
                if (ref instanceof ISystemContainer) {
                    ((ISystemContainer)((Object)ref)).markStale(true);
                }
                ++i;
            }
        }
        if (!this.listenerManager.hasListeners()) {
            return;
        }
        if (this.onMainThread()) {
            this.listenerManager.notify(event);
        } else {
            this.runOnMainThread(new NotifyResourceChangedRunnable(event));
        }
    }

    public void fireEvent(ISystemResourceChangeListener l, ISystemResourceChangeEvent event) {
        if (this.onMainThread()) {
            l.systemResourceChanged(event);
        } else {
            this.runOnMainThread(new ResourceChangedRunnable(event, l));
        }
    }

    public SystemResourceChangeManager getResourceChangeManager() {
        return this.listenerManager;
    }

    public void addSystemModelChangeListener(ISystemModelChangeListener l) {
        this.modelListenerManager.addSystemModelChangeListener(l);
    }

    public void removeSystemModelChangeListener(ISystemModelChangeListener l) {
        this.modelListenerManager.removeSystemModelChangeListener(l);
    }

    private boolean onMainThread() {
        return Display.getCurrent() != null;
    }

    private void runOnMainThread(Runnable runnable) {
        Display.getDefault().asyncExec(runnable);
    }

    public void fireEvent(ISystemModelChangeEvent event) {
        if (!this.modelListenerManager.hasListeners()) {
            return;
        }
        if (this.onMainThread()) {
            this.modelListenerManager.notify(event);
        } else {
            this.runOnMainThread(new NotifyModelChangedRunnable(event));
        }
    }

    public void fireModelChangeEvent(int eventType, int resourceType, Object resource, String oldName) {
        if (!this.modelListenerManager.hasListeners()) {
            return;
        }
        SystemModelChangeEvent modelEvent = new SystemModelChangeEvent();
        modelEvent.setEventType(eventType);
        modelEvent.setResourceType(resourceType);
        modelEvent.setResource(resource);
        modelEvent.setOldName(oldName);
        if (this.onMainThread()) {
            this.modelListenerManager.notify(modelEvent);
        } else {
            this.runOnMainThread(new NotifyModelChangedRunnable(modelEvent));
        }
    }

    public void fireEvent(ISystemModelChangeListener l, ISystemModelChangeEvent event) {
        if (this.onMainThread()) {
            l.systemModelResourceChanged(event);
        } else {
            this.runOnMainThread(new ModelResourceChangedRunnable(event, l));
        }
    }

    public void addSystemRemoteChangeListener(ISystemRemoteChangeListener l) {
        this.remoteListManager.addSystemRemoteChangeListener(l);
    }

    public void removeSystemRemoteChangeListener(ISystemRemoteChangeListener l) {
        this.remoteListManager.removeSystemRemoteChangeListener(l);
    }

    public boolean isRegisteredSystemRemoteChangeListener(ISystemRemoteChangeListener l) {
        return this.remoteListManager.isRegisteredSystemRemoteChangeListener(l);
    }

    public void fireEvent(ISystemRemoteChangeEvent event) {
        if (!this.remoteListManager.hasListeners()) {
            return;
        }
        if (this.onMainThread()) {
            this.remoteListManager.notify(event);
        } else {
            this.runOnMainThread(new RemoteChangedRunnable(event));
        }
    }

    public void fireRemoteResourceChangeEvent(int eventType, Object resource, Object resourceParent, ISubSystem subsystem, String[] oldNames) {
        if (resourceParent instanceof ISystemContainer) {
            ((ISystemContainer)resourceParent).markStale(true);
        }
        this.invalidateFiltersFor(resourceParent, subsystem);
        if (!this.remoteListManager.hasListeners()) {
            return;
        }
        SystemRemoteChangeEvent remoteEvent = new SystemRemoteChangeEvent();
        remoteEvent.setEventType(eventType);
        remoteEvent.setResource(resource);
        remoteEvent.setResourceParent(resourceParent);
        remoteEvent.setOldNames(oldNames);
        remoteEvent.setSubSystem(subsystem);
        if (this.onMainThread()) {
            this.remoteListManager.notify(remoteEvent);
        } else {
            this.runOnMainThread(new RemoteChangedRunnable(remoteEvent));
        }
    }

    public void fireRemoteResourceChangeEvent(int eventType, Object resource, Object resourceParent, ISubSystem subsystem, String[] oldNames, Object originatingViewer) {
        if (resourceParent instanceof ISystemContainer) {
            ((ISystemContainer)resourceParent).markStale(true);
        }
        this.invalidateFiltersFor(resourceParent, subsystem);
        if (!this.remoteListManager.hasListeners()) {
            return;
        }
        SystemRemoteChangeEvent remoteEvent = new SystemRemoteChangeEvent();
        remoteEvent.setEventType(eventType);
        remoteEvent.setResource(resource);
        remoteEvent.setResourceParent(resourceParent);
        remoteEvent.setOldNames(oldNames);
        remoteEvent.setSubSystem(subsystem);
        remoteEvent.setOriginatingViewer(originatingViewer);
        if (this.onMainThread()) {
            this.remoteListManager.notify(remoteEvent);
        } else {
            this.runOnMainThread(new RemoteChangedRunnable(remoteEvent));
        }
    }

    public void fireRemoteResourceChangeEvent(String operation, int eventType, Object resource, Object resourceParent, ISubSystem subsystem, String[] oldNames) {
        if (resourceParent instanceof ISystemContainer) {
            ((ISystemContainer)resourceParent).markStale(true);
        }
        this.invalidateFiltersFor(resourceParent, subsystem);
        if (!this.remoteListManager.hasListeners()) {
            return;
        }
        SystemRemoteChangeEvent remoteEvent = new SystemRemoteChangeEvent();
        remoteEvent.setOperation(operation);
        remoteEvent.setEventType(eventType);
        remoteEvent.setResource(resource);
        remoteEvent.setResourceParent(resourceParent);
        remoteEvent.setOldNames(oldNames);
        remoteEvent.setSubSystem(subsystem);
        if (this.onMainThread()) {
            this.remoteListManager.notify(remoteEvent);
        } else {
            this.runOnMainThread(new RemoteChangedRunnable(remoteEvent));
        }
    }

    public void fireRemoteResourceChangeEvent(String operation, int eventType, Object resource, Object resourceParent, ISubSystem subsystem, String[] oldNames, Object originatingViewer) {
        if (resourceParent instanceof ISystemContainer) {
            ((ISystemContainer)resourceParent).markStale(true);
        }
        this.invalidateFiltersFor(resourceParent, subsystem);
        if (!this.remoteListManager.hasListeners()) {
            return;
        }
        SystemRemoteChangeEvent remoteEvent = new SystemRemoteChangeEvent();
        remoteEvent.setOperation(operation);
        remoteEvent.setEventType(eventType);
        remoteEvent.setResource(resource);
        remoteEvent.setResourceParent(resourceParent);
        remoteEvent.setOldNames(oldNames);
        remoteEvent.setSubSystem(subsystem);
        remoteEvent.setOriginatingViewer(originatingViewer);
        if (this.onMainThread()) {
            this.remoteListManager.notify(remoteEvent);
        } else {
            this.runOnMainThread(new RemoteChangedRunnable(remoteEvent));
        }
    }

    protected IRemoteObjectIdentifier getRemoteObjectIdentifier(Object o) {
        if (o instanceof IRemoteObjectIdentifier) {
            return (IRemoteObjectIdentifier)o;
        }
        IRemoteObjectIdentifier adapter = null;
        if (o instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)o;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.rse.core.subsystems.IRemoteObjectIdentifier");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (IRemoteObjectIdentifier)iAdaptable.getAdapter((Class)clazz)) != null) {
                return adapter;
            }
        } else if (o == null) {
            return null;
        }
        IAdapterManager iAdapterManager = Platform.getAdapterManager();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.rse.core.subsystems.IRemoteObjectIdentifier");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (IRemoteObjectIdentifier)iAdapterManager.getAdapter(o, (Class)clazz)) == null) {
            if (o instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)o;
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((adapter = (ISystemDragDropAdapter)iAdaptable.getAdapter((Class)clazz2)) != null) {
                    return adapter;
                }
            }
            IAdapterManager iAdapterManager2 = Platform.getAdapterManager();
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("org.eclipse.rse.core.subsystems.ISystemDragDropAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (ISystemDragDropAdapter)iAdapterManager2.getAdapter(o, (Class)clazz3);
        }
        return adapter;
    }

    private String getRemoteResourceAbsoluteName(Object remoteResource) {
        if (remoteResource == null) {
            return null;
        }
        String remoteResourceName = null;
        if (remoteResource instanceof String) {
            remoteResourceName = (String)remoteResource;
        } else if (remoteResource instanceof SystemFilterReference) {
            ISystemFilterReference ref = (ISystemFilterReference)remoteResource;
            ISubSystem ss = ref.getSubSystem();
            if (ss.isOffline()) {
                return null;
            }
            remoteResource = ss.getTargetForFilter(ref);
            IRemoteObjectIdentifier rid = this.getRemoteObjectIdentifier(remoteResource);
            if (rid == null) {
                return null;
            }
            remoteResourceName = rid.getAbsoluteName(remoteResource);
        } else {
            IRemoteObjectIdentifier rid = this.getRemoteObjectIdentifier(remoteResource);
            if (rid == null) {
                return null;
            }
            remoteResourceName = rid.getAbsoluteName(remoteResource);
        }
        return remoteResourceName;
    }

    private List findFilterReferencesFor(ISubSystem subsystem) {
        ISystemFilterPoolReferenceManager refmgr;
        ArrayList<ISystemFilterReference> results = new ArrayList<ISystemFilterReference>();
        if (subsystem != null && (refmgr = subsystem.getFilterPoolReferenceManager()) != null) {
            ISystemFilterReference[] refs = refmgr.getSystemFilterReferences(subsystem);
            int i = 0;
            while (i < refs.length) {
                ISystemFilterReference filterRef = refs[i];
                if (!filterRef.isStale() && filterRef.hasContents(SystemChildrenContentsType.getInstance())) {
                    results.add(filterRef);
                }
                ++i;
            }
        }
        return results;
    }

    public List findFilterReferencesFor(Object resource, ISubSystem subsystem) {
        return this.findFilterReferencesFor(resource, subsystem, true);
    }

    public List findFilterReferencesFor(Object resource, ISubSystem subsystem, boolean onlyCached) {
        String elementName = this.getRemoteResourceAbsoluteName(resource);
        ArrayList<ISystemFilterReference> results = new ArrayList<ISystemFilterReference>();
        if (subsystem != null && elementName != null && subsystem.getSubSystemConfiguration().supportsFilters()) {
            ISystemFilterReference[] refs = subsystem.getFilterPoolReferenceManager().getSystemFilterReferences(subsystem);
            int i = 0;
            while (i < refs.length) {
                ISystemFilterReference filterRef = refs[i];
                if (!onlyCached || !filterRef.isStale() && filterRef.hasContents(SystemChildrenContentsType.getInstance())) {
                    if (subsystem.doesFilterMatch(filterRef.getReferencedFilter(), elementName)) {
                        results.add(filterRef);
                    } else if (subsystem.doesFilterListContentsOf(filterRef.getReferencedFilter(), elementName)) {
                        results.add(filterRef);
                    }
                }
                ++i;
            }
        }
        return results;
    }

    public void invalidateFiltersFor(ISubSystem subsystem) {
        if (subsystem != null) {
            List results = this.findFilterReferencesFor(subsystem);
            int i = 0;
            while (i < results.size()) {
                ((ISystemFilterReference)results.get(i)).markStale(true);
                ++i;
            }
        }
    }

    public void invalidateFiltersFor(Object resourceParent, ISubSystem subsystem) {
        if (subsystem != null) {
            List results = this.findFilterReferencesFor(resourceParent, subsystem);
            int i = 0;
            while (i < results.size()) {
                ((ISystemFilterReference)results.get(i)).markStale(true);
                ++i;
            }
        }
    }

    public void fireEvent(ISystemRemoteChangeListener l, ISystemRemoteChangeEvent event) {
        if (this.onMainThread()) {
            l.systemRemoteResourceChanged(event);
        } else {
            this.runOnMainThread(new RemoteResourceChangedRunnable(event, l));
        }
    }

    public void addSystemPreferenceChangeListener(ISystemPreferenceChangeListener l) {
        this.preferenceListManager.addSystemPreferenceChangeListener(l);
    }

    public void removeSystemPreferenceChangeListener(ISystemPreferenceChangeListener l) {
        this.preferenceListManager.removeSystemPreferenceChangeListener(l);
    }

    public void fireEvent(ISystemPreferenceChangeEvent event) {
        if (!this.preferenceListManager.hasListeners()) {
            return;
        }
        if (this.onMainThread()) {
            this.preferenceListManager.notify(event);
        } else {
            this.runOnMainThread(new NotifyPreferenceChangedRunnable(event));
        }
    }

    public void fireEvent(ISystemPreferenceChangeListener l, ISystemPreferenceChangeEvent event) {
        if (!this.preferenceListManager.hasListeners()) {
            return;
        }
        if (this.onMainThread()) {
            l.systemPreferenceChanged(event);
        } else {
            this.runOnMainThread(new PreferenceChangedRunnable(event, l));
        }
    }

    public void loadAll() {
        ISubSystemConfigurationProxy[] proxies = this.getSubSystemConfigurationProxies();
        if (proxies != null) {
            int idx = 0;
            while (idx < proxies.length) {
                proxies[idx].getSubSystemConfiguration();
                ++idx;
            }
        }
        IHost[] connections = this.getHosts();
        int idx = 0;
        while (idx < connections.length) {
            this.getSubSystems(connections[idx]);
            ++idx;
        }
    }

    public Exception getLastException() {
        Exception last = lastException;
        lastException = null;
        return last;
    }

    public boolean save() {
        ISystemProfile[] notSaved = RSECorePlugin.getThePersistenceManager().commitProfiles(5000L);
        return notSaved.length > 0;
    }

    public boolean saveHostPool(ISystemHostPool pool) {
        return pool.commit();
    }

    public boolean saveHost(IHost conn) {
        return conn.commit();
    }

    public boolean restore() {
        boolean ok = true;
        lastException = null;
        return ok;
    }

    public boolean contains(ISchedulingRule rule) {
        return rule == this;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return rule == this;
    }

    public ISystemFilterStartHere getSystemFilterStartHere() {
        return SystemFilterStartHere.getInstance();
    }

    public Object[] getSystemViewRoots() {
        IHost[] connections = this.getHosts();
        ArrayList<IHost> result = new ArrayList<IHost>();
        int i = 0;
        while (i < connections.length) {
            IHost con = connections[i];
            IRSESystemType sysType = con.getSystemType();
            if (sysType != null && sysType.isEnabled()) {
                result.add(con);
            }
            ++i;
        }
        return result.toArray();
    }

    public boolean hasSystemViewRoots() {
        return this.getHostCount() > 0;
    }

    public boolean showingConnections() {
        return true;
    }

    public void setViewer(Object viewer) {
        this.viewer = viewer;
    }

    public Object getViewer() {
        return this.viewer;
    }

    static /* synthetic */ ISystemHostPool access$4(SystemRegistry systemRegistry, String string) {
        return systemRegistry.getHostPool(string);
    }

    static /* synthetic */ ISubSystemConfigurator[] access$5(SystemRegistry systemRegistry, ISubSystemConfiguration iSubSystemConfiguration, ISubSystemConfigurator[] iSubSystemConfiguratorArray) {
        return systemRegistry.getApplicableConfigurators(iSubSystemConfiguration, iSubSystemConfiguratorArray);
    }

    class FireNewHostEvents
    implements Runnable {
        private ISubSystem[] subSystems;
        private IHost conn;
        private ISystemRegistry reg;
        private boolean expandHost;

        public FireNewHostEvents(IHost host, ISubSystem[] subSystems, ISystemRegistry registry, boolean expandHost) {
            this.subSystems = subSystems;
            this.conn = host;
            this.reg = registry;
            this.expandHost = expandHost;
        }

        public void run() {
            int eventType = 53;
            SystemResourceChangeEvent event = new SystemResourceChangeEvent(this.conn, eventType, (Object)this.reg);
            IHost previous = SystemRegistry.this.getPreviousHost(this.conn);
            if (previous != null) {
                event.setRelativePrevious(previous);
            } else {
                event.setType(50);
            }
            SystemRegistry.this.fireEvent(event);
            SystemRegistry.this.fireModelChangeEvent(1, 2, this.conn, null);
            int s = 0;
            while (s < this.subSystems.length) {
                ISubSystem ss = this.subSystems[s];
                SystemRegistry.this.fireModelChangeEvent(1, 4, ss, null);
                ++s;
            }
            if (this.expandHost) {
                SystemResourceChangeEvent expandEvent = new SystemResourceChangeEvent(this.conn, 105, (Object)this.reg);
                SystemRegistry.this.fireEvent(expandEvent);
            }
        }
    }

    class ModelResourceChangedRunnable
    implements Runnable {
        private ISystemModelChangeListener _listener;
        private ISystemModelChangeEvent _event;

        public ModelResourceChangedRunnable(ISystemModelChangeEvent event, ISystemModelChangeListener listener) {
            this._event = event;
            this._listener = listener;
        }

        public void run() {
            this._listener.systemModelResourceChanged(this._event);
        }
    }

    class NotifyModelChangedRunnable
    implements Runnable {
        private ISystemModelChangeEvent _event;

        public NotifyModelChangedRunnable(ISystemModelChangeEvent event) {
            this._event = event;
        }

        public void run() {
            SystemRegistry.this.modelListenerManager.notify(this._event);
        }
    }

    class NotifyPreferenceChangedRunnable
    implements Runnable {
        private ISystemPreferenceChangeEvent _event;

        public NotifyPreferenceChangedRunnable(ISystemPreferenceChangeEvent event) {
            this._event = event;
        }

        public void run() {
            SystemRegistry.this.preferenceListManager.notify(this._event);
        }
    }

    class NotifyResourceChangedRunnable
    implements Runnable {
        private ISystemResourceChangeEvent _event;

        public NotifyResourceChangedRunnable(ISystemResourceChangeEvent event) {
            this._event = event;
        }

        public void run() {
            SystemRegistry.this.listenerManager.notify(this._event);
        }
    }

    class PreferenceChangedRunnable
    implements Runnable {
        private ISystemPreferenceChangeEvent _event;
        private ISystemPreferenceChangeListener _listener;

        public PreferenceChangedRunnable(ISystemPreferenceChangeEvent event, ISystemPreferenceChangeListener listener) {
            this._event = event;
            this._listener = listener;
        }

        public void run() {
            this._listener.systemPreferenceChanged(this._event);
        }
    }

    class RemoteChangedRunnable
    implements Runnable {
        private ISystemRemoteChangeEvent _event;

        public RemoteChangedRunnable(ISystemRemoteChangeEvent event) {
            this._event = event;
        }

        public void run() {
            SystemRegistry.this.remoteListManager.notify(this._event);
        }
    }

    class RemoteResourceChangedRunnable
    implements Runnable {
        private ISystemRemoteChangeListener _listener;
        private ISystemRemoteChangeEvent _event;

        public RemoteResourceChangedRunnable(ISystemRemoteChangeEvent event, ISystemRemoteChangeListener listener) {
            this._event = event;
            this._listener = listener;
        }

        public void run() {
            this._listener.systemRemoteResourceChanged(this._event);
        }
    }

    class ResourceChangedRunnable
    implements Runnable {
        private ISystemResourceChangeListener _listener;
        private ISystemResourceChangeEvent _event;

        public ResourceChangedRunnable(ISystemResourceChangeEvent event, ISystemResourceChangeListener listener) {
            this._event = event;
            this._listener = listener;
        }

        public void run() {
            this._listener.systemResourceChanged(this._event);
        }
    }
}

