/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.preferences.external;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.preferences.ExternalLibraryPreferenceStore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.ui.external.EclipseExternalLibraryWorkspace;
import org.eclipse.xtext.util.Pair;

public class ExternalLibraryTreeContentProvider
implements ILazyTreeContentProvider {
    private Optional<TreeViewer> treeViewerRef;
    private final Map<FileURI, List<IN4JSProject>> locationProjectsCache = new HashMap<FileURI, List<IN4JSProject>>();
    @Inject
    private EclipseExternalLibraryWorkspace externalLibraryWorkspace;
    @Inject
    private ExternalLibraryPreferenceStore externalLibraryPreferenceStore;

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.treeViewerRef = viewer instanceof TreeViewer ? Optional.of((Object)((TreeViewer)viewer)) : Optional.absent();
        this.locationProjectsCache.clear();
    }

    public void updateElement(Object parent, int index) {
        if (this.treeViewerRef.isPresent()) {
            TreeViewer treeViewer = (TreeViewer)this.treeViewerRef.get();
            if (parent instanceof Iterable) {
                Object child = Iterables.get((Iterable)((Iterable)parent), (int)index);
                treeViewer.replace(parent, index, child);
                if (child instanceof FileURI) {
                    treeViewer.setChildCount(child, this.getProjects((FileURI)child).size());
                }
            } else if (parent instanceof FileURI) {
                IN4JSProject child = this.getProjects((FileURI)parent).get(index);
                treeViewer.replace(parent, index, (Object)child);
            }
        }
    }

    public void updateChildCount(Object element, int currentChildCount) {
        if (this.treeViewerRef.isPresent()) {
            TreeViewer treeViewer = (TreeViewer)this.treeViewerRef.get();
            if (element instanceof Iterable) {
                treeViewer.setChildCount(element, Iterables.size((Iterable)((Iterable)element)));
            } else if (element instanceof FileURI) {
                treeViewer.setChildCount(element, this.getProjects((FileURI)element).size());
            } else {
                treeViewer.setChildCount(element, 0);
            }
        }
    }

    public Object getParent(Object element) {
        return null;
    }

    private List<IN4JSProject> getProjects(FileURI location) {
        if (this.locationProjectsCache.isEmpty()) {
            this.initCache();
        }
        return this.locationProjectsCache.get(location);
    }

    private void initCache() {
        this.locationProjectsCache.clear();
        for (FileURI fileURI : this.externalLibraryPreferenceStore.getLocations()) {
            this.locationProjectsCache.putIfAbsent(fileURI, new LinkedList());
        }
        for (Pair pair : this.externalLibraryWorkspace.getProjectsIncludingUnnecessary()) {
            FileURI prjLocation = (FileURI)pair.getFirst();
            FileURI rootLocation = this.externalLibraryWorkspace.getRootLocationForResource(prjLocation);
            N4JSExternalProject project = this.externalLibraryWorkspace.getProject(prjLocation);
            this.locationProjectsCache.putIfAbsent(rootLocation, new LinkedList());
            List<IN4JSProject> list = this.locationProjectsCache.get(rootLocation);
            IN4JSProject iProject = project.getIProject();
            list.add(iProject);
        }
    }
}

