/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.xtext.server;

import com.google.common.collect.ComparisonChain;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.n4js.ide.validation.N4JSIssue;
import org.eclipse.n4js.ide.xtext.server.XWorkspaceManager;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.UriExtensions;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.workspace.IProjectConfig;
import org.eclipse.xtext.workspace.ISourceFolder;

@Singleton
public class IssueAcceptor {
    @Inject
    private UriExtensions uriExtensions;
    @Inject
    private XWorkspaceManager workspaceManager;
    private LanguageClient client;

    public void connect(LanguageClient languageClient) {
        this.client = languageClient;
    }

    public void publishDiagnostics(URI uri, Iterable<? extends Issue> issues) {
        PublishDiagnosticsParams publishDiagnosticsParams = new PublishDiagnosticsParams();
        publishDiagnosticsParams.setUri(this.uriExtensions.toUriString(uri));
        List<Diagnostic> diags = this.toDiagnostics(uri, issues);
        publishDiagnosticsParams.setDiagnostics(diags);
        this.client.publishDiagnostics(publishDiagnosticsParams);
    }

    protected List<Diagnostic> toDiagnostics(URI uri, Iterable<? extends Issue> issues) {
        IProjectConfig projectConfig;
        ISourceFolder iSourceFolder;
        if (!this.workspaceManager.isDocumentOpen(uri) && (iSourceFolder = (projectConfig = this.workspaceManager.getWorkspaceConfig().findProjectContaining(uri)).findSourceFolderContaining(uri)) == null) {
            return Collections.emptyList();
        }
        ArrayList<Diagnostic> sortedDiags = new ArrayList<Diagnostic>();
        for (Issue issue : issues) {
            if (issue.getSeverity() == Severity.IGNORE) continue;
            sortedDiags.add(this.toDiagnostic(issue));
        }
        Comparator<Diagnostic> comparator = new Comparator<Diagnostic>(){

            @Override
            public int compare(Diagnostic d1, Diagnostic d2) {
                Position p1 = d1.getRange().getStart();
                Position p2 = d2.getRange().getStart();
                int result = ComparisonChain.start().compare(p1.getLine(), p2.getLine()).compare(p2.getCharacter(), p2.getCharacter()).result();
                return result;
            }
        };
        Collections.sort(sortedDiags, comparator);
        return sortedDiags;
    }

    protected Diagnostic toDiagnostic(Issue issue) {
        Diagnostic result = new Diagnostic();
        result.setCode(issue.getCode());
        result.setMessage(issue.getMessage());
        result.setSeverity(this.toDiagnosticSeverity(issue.getSeverity()));
        Position start = new Position(IssueAcceptor.toInt(issue.getLineNumber()), IssueAcceptor.toInt(issue.getColumn()));
        Position end = null;
        if (issue instanceof N4JSIssue) {
            N4JSIssue n4jsIssue = (N4JSIssue)issue;
            end = new Position(n4jsIssue.getLineNumberEnd(), n4jsIssue.getColumnEnd());
        } else {
            URI uri = issue.getUriToProblem();
            Document doc = null;
            if (uri != null) {
                doc = this.workspaceManager.getDocument(uri);
            }
            if (doc != null) {
                end = doc.getPosition(issue.getOffset() + issue.getLength());
            }
            if (end == null) {
                end = new Position(start.getLine(), start.getCharacter() + 1);
            }
        }
        result.setRange(new Range(start, end));
        return result;
    }

    private static int toInt(Integer integer) {
        return integer == null ? 0 : integer;
    }

    protected DiagnosticSeverity toDiagnosticSeverity(Severity severity) {
        switch (severity) {
            case ERROR: {
                return DiagnosticSeverity.Error;
            }
            case IGNORE: {
                return DiagnosticSeverity.Hint;
            }
            case INFO: {
                return DiagnosticSeverity.Information;
            }
            case WARNING: {
                return DiagnosticSeverity.Warning;
            }
        }
        return DiagnosticSeverity.Hint;
    }
}

