/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.semver;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.n4js.semver.Semver.NPMVersionRequirement;
import org.eclipse.n4js.semver.Semver.SimpleVersion;
import org.eclipse.n4js.semver.Semver.URLVersionRequirement;
import org.eclipse.n4js.semver.Semver.VersionComparator;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.n4js.semver.Semver.VersionPart;
import org.eclipse.n4js.semver.Semver.VersionRange;
import org.eclipse.n4js.semver.Semver.VersionRangeConstraint;
import org.eclipse.n4js.semver.Semver.VersionRangeSetRequirement;
import org.eclipse.n4js.semver.SemverConverter;

public class SemverMatcher {
    public static boolean canComputeMatch(VersionNumber proband, NPMVersionRequirement npmv) {
        if (proband == null) {
            return false;
        }
        if (npmv instanceof VersionRangeSetRequirement) {
            return true;
        }
        if (npmv instanceof URLVersionRequirement) {
            URLVersionRequirement urlVersion = (URLVersionRequirement)npmv;
            return urlVersion.hasSimpleVersion();
        }
        return false;
    }

    public static boolean matches(VersionNumber proband, NPMVersionRequirement constraint) {
        if (proband == null) {
            return false;
        }
        if (constraint instanceof VersionRangeSetRequirement) {
            return SemverMatcher.matches(proband, (VersionRangeSetRequirement)constraint);
        }
        if (constraint instanceof URLVersionRequirement) {
            return SemverMatcher.matches(proband, (URLVersionRequirement)constraint);
        }
        return true;
    }

    public static boolean matchesStrict(VersionNumber proband, NPMVersionRequirement constraint) {
        return SemverMatcher.canComputeMatch(proband, constraint) && SemverMatcher.matches(proband, constraint);
    }

    public static VersionNumberRelation relation(VersionNumber a, VersionNumber limit) {
        return SemverMatcher.relation(a, limit, RelationKind.SemverMatch);
    }

    public static int compareSemver(VersionNumber a, VersionNumber b) {
        VersionNumberRelation versionRelation = SemverMatcher.relation(a, b, RelationKind.SemverMatch);
        return SemverMatcher.compareResultToInt(versionRelation);
    }

    public static int compareLoose(VersionNumber a, VersionNumber b) {
        VersionNumberRelation versionRelation = SemverMatcher.relation(a, b, RelationKind.LooseCompare);
        return SemverMatcher.compareResultToInt(versionRelation);
    }

    private static int compareResultToInt(VersionNumberRelation versionRelation) {
        switch (versionRelation) {
            case Equal: {
                return 0;
            }
            case Greater: {
                return 1;
            }
            case Smaller: {
                return -1;
            }
            case Unrelated: {
                return -10;
            }
        }
        return -10;
    }

    private static boolean matches(VersionNumber proband, VersionRangeSetRequirement constraint) {
        EList cRanges = constraint.getRanges();
        if (cRanges.isEmpty()) {
            return true;
        }
        if (SemverMatcher.isWildcard(constraint)) {
            return true;
        }
        for (VersionRange cRange : cRanges) {
            List<SimpleVersion> simpleConstraints = SemverConverter.simplify(cRange);
            boolean rangeMatches = SemverMatcher.matches(proband, simpleConstraints);
            if (!rangeMatches) continue;
            return true;
        }
        return false;
    }

    private static boolean isWildcard(VersionRangeSetRequirement constraint) {
        if (constraint.getRanges().size() != 1) {
            return false;
        }
        VersionRange versionRange = (VersionRange)constraint.getRanges().get(0);
        if (!(versionRange instanceof VersionRangeConstraint)) {
            return false;
        }
        VersionRangeConstraint vrc = (VersionRangeConstraint)versionRange;
        if (vrc.getVersionConstraints().size() != 1) {
            return false;
        }
        SimpleVersion simpleVersion = (SimpleVersion)vrc.getVersionConstraints().get(0);
        return simpleVersion.isWildcard();
    }

    private static boolean matches(VersionNumber proband, URLVersionRequirement constraint) {
        if (constraint.hasSimpleVersion()) {
            SimpleVersion simpleVersion = constraint.getSimpleVersion();
            List<SimpleVersion> simpleConstraints = SemverConverter.simplify(simpleVersion);
            return SemverMatcher.matches(proband, simpleConstraints);
        }
        return true;
    }

    private static boolean matches(VersionNumber proband, List<SimpleVersion> simpleConstraints) {
        Collections.sort(simpleConstraints, SemverMatcher::compareToClusterPrereleases);
        int i = 0;
        while (i < simpleConstraints.size()) {
            RelationKind relationKind;
            SimpleVersion simpleConstraint = simpleConstraints.get(i);
            boolean constraintMatchesProband = SemverMatcher.matches(proband, simpleConstraint, relationKind = SemverMatcher.computeSemverRelationKind(proband, i, simpleConstraint));
            if (!constraintMatchesProband) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static RelationKind computeSemverRelationKind(VersionNumber proband, int i, SimpleVersion simpleConstraint) {
        RelationKind relationKind = RelationKind.SemverMatch;
        boolean allowPreReleaseTag = true;
        allowPreReleaseTag &= proband.hasPreReleaseTag();
        allowPreReleaseTag &= !simpleConstraint.getNumber().hasPreReleaseTag();
        if (allowPreReleaseTag &= i > 0) {
            relationKind = RelationKind.SemverMatchAllowPrereleaseTags;
        }
        return relationKind;
    }

    private static int compareToClusterPrereleases(SimpleVersion sv1, SimpleVersion sv2) {
        boolean sv2HasPreReleaseTag;
        boolean sv1HasPreReleaseTag = sv1.getNumber().hasPreReleaseTag();
        if (sv1HasPreReleaseTag == (sv2HasPreReleaseTag = sv2.getNumber().hasPreReleaseTag())) {
            return 0;
        }
        if (sv1HasPreReleaseTag) {
            return -1;
        }
        if (sv2HasPreReleaseTag) {
            return 1;
        }
        throw new IllegalStateException("The Impossible State.");
    }

    private static boolean matches(VersionNumber proband, SimpleVersion constraint, RelationKind relationKind) {
        VersionNumber constraintVN = constraint.getNumber();
        VersionNumberRelation relation = SemverMatcher.relation(proband, constraintVN, relationKind);
        if (relation == VersionNumberRelation.Unrelated) {
            return false;
        }
        VersionComparator versionComparator = (VersionComparator)constraint.getComparators().get(0);
        switch (versionComparator) {
            case GREATER: {
                return relation == VersionNumberRelation.Greater;
            }
            case GREATER_EQUALS: {
                return relation != VersionNumberRelation.Smaller;
            }
            case SMALLER: {
                return relation == VersionNumberRelation.Smaller;
            }
            case SMALLER_EQUALS: {
                return relation != VersionNumberRelation.Greater;
            }
            case EQUALS: 
            case TILDE: 
            case CARET: {
                throw new IllegalStateException("This comparator should have been replaced in SemverConverter#simplify.");
            }
        }
        throw new IllegalStateException("The Impossible State.");
    }

    public static VersionNumberRelation relation(VersionNumber vn, VersionNumber limit, RelationKind relationKind) {
        boolean qHasPR = vn.hasPreReleaseTag();
        boolean lHasPR = limit.hasPreReleaseTag();
        if (relationKind != RelationKind.SemverMatchAllowPrereleaseTags && qHasPR && !lHasPR) {
            return VersionNumberRelation.Unrelated;
        }
        if (qHasPR && lHasPR) {
            boolean equalVersionsNumbers = true;
            equalVersionsNumbers &= Math.min(vn.length(), limit.length()) >= 3;
            if (equalVersionsNumbers &= (equalVersionsNumbers &= (equalVersionsNumbers &= vn.getMajor().getNumber() == limit.getMajor().getNumber()) && vn.getMinor().getNumber() == limit.getMinor().getNumber()) && vn.getPatch().getNumber() == limit.getPatch().getNumber()) {
                return SemverMatcher.relationOfQualifiers(vn, limit);
            }
            if (relationKind != RelationKind.LooseCompare) {
                return VersionNumberRelation.Unrelated;
            }
        }
        int idxMax = Math.min(vn.length(), limit.length());
        int i = 0;
        while (i < idxMax) {
            int nLimit;
            VersionPart pVn = vn.getPart(i);
            VersionPart pLimit = limit.getPart(i);
            if (pVn.isWildcard()) {
                return VersionNumberRelation.Greater;
            }
            if (pLimit.isWildcard()) {
                return VersionNumberRelation.Smaller;
            }
            int nVn = pVn.getNumber();
            if (nVn > (nLimit = pLimit.getNumber().intValue())) {
                return VersionNumberRelation.Greater;
            }
            if (nVn < nLimit) {
                return VersionNumberRelation.Smaller;
            }
            ++i;
        }
        return SemverMatcher.relationOfQualifiers(vn, limit);
    }

    private static VersionNumberRelation relationOfQualifiers(VersionNumber vn, VersionNumber lmt) {
        EList vnPR = vn.getPreReleaseTag();
        EList lmtPR = lmt.getPreReleaseTag();
        if (vnPR == null && lmtPR == null) {
            return VersionNumberRelation.Equal;
        }
        if (vnPR != null && lmtPR == null) {
            return VersionNumberRelation.Smaller;
        }
        if (vnPR == null && lmtPR != null) {
            return VersionNumberRelation.Greater;
        }
        if (vnPR != null && lmtPR != null) {
            int idxMax = Math.min(vnPR.size(), lmtPR.size());
            int i = 0;
            while (i < idxMax) {
                String vnPartStr = (String)vnPR.get(i);
                String lmtPartStr = (String)lmtPR.get(i);
                Integer vnPartInt = SemverMatcher.parseInt(vnPartStr);
                Integer lmtPartInt = SemverMatcher.parseInt(lmtPartStr);
                if (vnPartInt == null && lmtPartInt != null) {
                    return VersionNumberRelation.Greater;
                }
                if (vnPartInt != null && lmtPartInt == null) {
                    return VersionNumberRelation.Smaller;
                }
                if (vnPartInt != null && lmtPartInt != null) {
                    if (vnPartInt > lmtPartInt) {
                        return VersionNumberRelation.Greater;
                    }
                    if (vnPartInt < lmtPartInt) {
                        return VersionNumberRelation.Smaller;
                    }
                }
                if (vnPartInt == null && lmtPartInt == null) {
                    if (vnPartStr.compareTo(lmtPartStr) > 0) {
                        return VersionNumberRelation.Greater;
                    }
                    if (vnPartStr.compareTo(lmtPartStr) < 0) {
                        return VersionNumberRelation.Smaller;
                    }
                }
                ++i;
            }
            if (vnPR.size() > lmtPR.size()) {
                return VersionNumberRelation.Greater;
            }
            if (vnPR.size() < lmtPR.size()) {
                return VersionNumberRelation.Smaller;
            }
            return VersionNumberRelation.Equal;
        }
        return null;
    }

    private static Integer parseInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static enum RelationKind {
        SemverMatch,
        SemverMatchAllowPrereleaseTags,
        LooseCompare;

    }

    public static enum VersionNumberRelation {
        Smaller,
        Greater,
        Equal,
        Unrelated;


        public boolean isSmallerOrEqual() {
            return this == Equal || this == Smaller;
        }

        public boolean isGreaterOrEqual() {
            return this == Equal || this == Greater;
        }
    }
}

