/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.ui;

import com.google.common.base.Strings;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.n4js.tester.TesterModule;
import org.eclipse.n4js.tester.ui.TesterUiModule;
import org.eclipse.n4js.ui.internal.N4JSActivator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class TesterUiActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.n4js.tester.ui";
    private static final String PATH_TO_ICONS = "icons" + File.separator;
    public static final String ICON_TEST = "test.gif";
    public static final String ICON_TEST_SKIPPED = "testignored.gif";
    public static final String ICON_TEST_SKIPPED_NOT_IMPLEMENTED_YET = "testassumptionfailed.gif";
    public static final String ICON_TEST_PASSED = "testok.gif";
    public static final String ICON_TEST_FAILED = "testfail.gif";
    public static final String ICON_TEST_ERROR = "testerr.gif";
    public static final String ICON_TEST_RUNNING = "testrunning.gif";
    public static final String ICON_SUITE = "tsuite.gif";
    public static final String ICON_SUITE_SKIPPED = "tsuiteignored.gif";
    public static final String ICON_SUITE_PASSED = "tsuiteok.gif";
    public static final String ICON_SUITE_FAILED = "tsuitefail.gif";
    public static final String ICON_SUITE_ERROR = "tsuiteerr.gif";
    public static final String ICON_SUITE_RUNNING = "tsuiterunning.gif";
    public static final String ICON_LOCK = "lock.gif";
    public static final String ICON_LAUNCHCONFIG = "launchconfig.gif";
    public static final String ICON_RELAUNCH = "relaunch.gif";
    public static final String ICON_RELAUNCH_FAILED = "relaunchf.gif";
    public static final String ICON_STOP = "stop.gif";
    public static final String ICON_HISTORY = "history_list.gif";
    public static final String ICON_TH_VERTICAL = "th_vertical.gif";
    public static final String ICON_TH_HORIZONTAL = "th_horizontal.gif";
    public static final String ICON_TH_AUTOMATIC = "th_automatic.gif";
    public static final String ICON_SHOW_FAILURES_ONLY = "failures.gif";
    public static final String ICON_SHOW_SKIPPED_ONLY = "testignored.gif";
    private static TesterUiActivator plugin;
    private Injector injector;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        Injector parentInjector = N4JSActivator.getInstance().getInjector("org.eclipse.n4js.N4JS");
        TesterModule testerModule = new TesterModule(parentInjector);
        TesterUiModule testerUiModule = new TesterUiModule(parentInjector);
        this.injector = Guice.createInjector((Module[])new Module[]{testerModule, testerUiModule});
    }

    public void stop(BundleContext context) throws Exception {
        this.injector = null;
        plugin = null;
        super.stop(context);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        reg.put(ICON_TEST, this.imageDescriptor(ICON_TEST));
        reg.put("testignored.gif", this.imageDescriptor("testignored.gif"));
        reg.put(ICON_TEST_SKIPPED_NOT_IMPLEMENTED_YET, this.imageDescriptor(ICON_TEST_SKIPPED_NOT_IMPLEMENTED_YET));
        reg.put(ICON_TEST_PASSED, this.imageDescriptor(ICON_TEST_PASSED));
        reg.put(ICON_TEST_FAILED, this.imageDescriptor(ICON_TEST_FAILED));
        reg.put(ICON_TEST_ERROR, this.imageDescriptor(ICON_TEST_ERROR));
        reg.put(ICON_TEST_RUNNING, this.imageDescriptor(ICON_TEST_RUNNING));
        reg.put(ICON_SUITE, this.imageDescriptor(ICON_SUITE));
        reg.put(ICON_SUITE_SKIPPED, this.imageDescriptor(ICON_SUITE_SKIPPED));
        reg.put(ICON_SUITE_PASSED, this.imageDescriptor(ICON_SUITE_PASSED));
        reg.put(ICON_SUITE_FAILED, this.imageDescriptor(ICON_SUITE_FAILED));
        reg.put(ICON_SUITE_ERROR, this.imageDescriptor(ICON_SUITE_ERROR));
        reg.put(ICON_SUITE_RUNNING, this.imageDescriptor(ICON_SUITE_RUNNING));
        reg.put(ICON_LOCK, this.imageDescriptor(ICON_LOCK));
        reg.put(ICON_LAUNCHCONFIG, this.imageDescriptor(ICON_LAUNCHCONFIG));
        reg.put(ICON_RELAUNCH, this.imageDescriptor(ICON_RELAUNCH));
        reg.put(ICON_RELAUNCH_FAILED, this.imageDescriptor(ICON_RELAUNCH_FAILED));
        reg.put(ICON_STOP, this.imageDescriptor(ICON_STOP));
        reg.put(ICON_HISTORY, this.imageDescriptor(ICON_HISTORY));
        reg.put(ICON_TH_HORIZONTAL, this.imageDescriptor(ICON_TH_HORIZONTAL));
        reg.put(ICON_TH_VERTICAL, this.imageDescriptor(ICON_TH_VERTICAL));
        reg.put(ICON_TH_AUTOMATIC, this.imageDescriptor(ICON_TH_AUTOMATIC));
        reg.put(ICON_SHOW_FAILURES_ONLY, this.imageDescriptor(ICON_SHOW_FAILURES_ONLY));
        reg.put("testignored.gif", this.imageDescriptor("testignored.gif"));
    }

    public ImageDescriptor imageDescriptor(String path) {
        return ResourceLocator.imageDescriptorFromBundle((String)PLUGIN_ID, (String)(String.valueOf(PATH_TO_ICONS) + path)).orElse(null);
    }

    public static TesterUiActivator getDefault() {
        return plugin;
    }

    public static void log(String message, Throwable t) {
        TesterUiActivator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, Strings.nullToEmpty((String)message), t));
    }

    public static final Image getImage(String key) {
        return TesterUiActivator.getDefault().getImageRegistry().get(key);
    }

    public static final ImageDescriptor getImageDescriptor(String key) {
        return TesterUiActivator.getDefault().getImageRegistry().getDescriptor(key);
    }

    public static Injector getInjector() {
        return TesterUiActivator.getDefault().injector;
    }
}

