/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.transform;

import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.Argument;
import org.eclipse.n4js.n4JS.AssignmentExpression;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ExpressionStatement;
import org.eclipse.n4js.n4JS.FunctionOrFieldAccessor;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4ClassifierDefinition;
import org.eclipse.n4js.n4JS.N4GetterDeclaration;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.N4SetterDeclaration;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.SuperLiteral;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TransformationDependency;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.assistants.TypeAssistant;
import org.eclipse.n4js.transpiler.es.assistants.DelegationAssistant;
import org.eclipse.n4js.transpiler.es.transform.ClassDeclarationTransformation;
import org.eclipse.n4js.transpiler.im.ParameterizedPropertyAccessExpression_IM;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryInternal;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@TransformationDependency.ExcludesBefore(value={ClassDeclarationTransformation.class})
public class SuperLiteralTransformation
extends Transformation {
    @Inject
    private TypeAssistant typeAssistant;
    @Inject
    private DelegationAssistant delegationAssistant;

    public void assertPreConditions() {
    }

    public void assertPostConditions() {
    }

    public void analyze() {
    }

    public void transform() {
        Consumer<N4MemberDeclaration> _function = it -> this.transformSuper((N4MemberDeclaration)it);
        this.collectNodes((EObject)this.getState().im, N4MemberDeclaration.class, false).forEach(_function);
    }

    private void transformSuper(N4MemberDeclaration memDecl) {
        Block body;
        N4ClassifierDefinition owner = memDecl.getOwner();
        if (owner instanceof N4ClassDeclaration && memDecl instanceof FunctionOrFieldAccessor && (body = ((FunctionOrFieldAccessor)memDecl).getBody()) != null) {
            this.transformSuper((N4ClassDeclaration)owner, body);
        }
    }

    private void transformSuper(N4ClassDeclaration classDecl, Block block) {
        Procedures.Procedure1 _function = sl -> {
            EObject p = sl.eContainer();
            if (p instanceof ParameterizedCallExpression) {
                boolean _tripleEquals;
                Expression _target = ((ParameterizedCallExpression)p).getTarget();
                boolean bl = _tripleEquals = _target == sl;
                if (_tripleEquals) {
                    this.transformSuperCall(classDecl, (ParameterizedCallExpression)p);
                }
            } else if (p instanceof ParameterizedPropertyAccessExpression_IM) {
                boolean _tripleEquals_1;
                Expression _target_1 = ((ParameterizedPropertyAccessExpression_IM)p).getTarget();
                boolean bl = _tripleEquals_1 = _target_1 == sl;
                if (_tripleEquals_1) {
                    this.transformSuperAccess(classDecl, (ParameterizedPropertyAccessExpression_IM)p);
                }
            }
        };
        IteratorExtensions.forEach((Iterator)Iterators.filter((Iterator)block.eAllContents(), SuperLiteral.class), (Procedures.Procedure1)_function);
    }

    private void transformSuperCall(N4ClassDeclaration classDecl, ParameterizedCallExpression callExpr) {
        SymbolTableEntryOriginal superClassSTE = this.typeAssistant.getSuperClassSTE(classDecl);
        SymbolTableEntryOriginal prototypeSTE = this.getSymbolTableEntryForMember(RuleEnvironmentExtensions.objectType((RuleEnvironment)this.getState().G), "prototype", false, true, true);
        SymbolTableEntryOriginal constructorSTE = this.getSymbolTableEntryForMember(RuleEnvironmentExtensions.objectType((RuleEnvironment)this.getState().G), "constructor", false, false, true);
        SymbolTableEntryOriginal callSTE = this.getSymbolTableEntryForMember((TClassifier)RuleEnvironmentExtensions.functionType((RuleEnvironment)this.getState().G), "call", false, false, true);
        this.setTarget(callExpr, (Expression)this.__NSSafe_PropertyAccessExpr((SymbolTableEntry)superClassSTE, new SymbolTableEntry[]{prototypeSTE, constructorSTE, callSTE}));
        this.addArgument(callExpr, 0, (Expression)TranspilerBuilderBlocks._ThisLiteral());
        this.getState().info.markAsExplicitSuperCall(callExpr);
    }

    public static Expression[] getArgumentsFromExplicitSuperCall(Statement superCallStmnt) {
        Expression expr;
        if (superCallStmnt == null) {
            throw new IllegalArgumentException("superCallStmnt may not be null");
        }
        if (superCallStmnt instanceof ExpressionStatement && (expr = ((ExpressionStatement)superCallStmnt).getExpression()) instanceof ParameterizedCallExpression) {
            Functions.Function1 _function = it -> it.getExpression();
            return (Expression[])Conversions.unwrapArray((Object)IterableExtensions.drop((Iterable)ListExtensions.map((List)((ParameterizedCallExpression)expr).getArguments(), (Functions.Function1)_function), (int)1), Expression.class);
        }
        throw new IllegalArgumentException("explicit super call has an unexpected structure");
    }

    private void transformSuperAccess(N4ClassDeclaration classDecl, ParameterizedPropertyAccessExpression_IM accExpr) {
        SymbolTableEntry _property_IM = accExpr.getProperty_IM();
        SymbolTableEntryOriginal propertySTE = (SymbolTableEntryOriginal)_property_IM;
        N4MemberDeclaration containingFunctionOrAccessor = (N4MemberDeclaration)EcoreUtil2.getContainerOfType((EObject)accExpr, N4MemberDeclaration.class);
        boolean isStatic = containingFunctionOrAccessor != null && containingFunctionOrAccessor.isStatic();
        Expression _xifexpression = null;
        boolean _isMethod = this.isMethod(propertySTE);
        _xifexpression = _isMethod ? this.delegationAssistant.createAccessToSuperClass(classDecl, isStatic) : this.delegationAssistant.createAccessToSuperClassBequestingMember(classDecl, isStatic, propertySTE);
        Expression superTarget = _xifexpression;
        boolean _isMethod_1 = this.isMethod(propertySTE);
        if (_isMethod_1) {
            this.transformSuperMethodAccess(accExpr, superTarget);
        } else if (this.isGetter(propertySTE) || this.isSetter(propertySTE)) {
            this.transformSuperFieldAccessorAccess(accExpr, superTarget, propertySTE);
        } else {
            throw new IllegalStateException("super member access to a SymbolTableEntry that could not be identified as a method or field accessor");
        }
    }

    private void transformSuperMethodAccess(ParameterizedPropertyAccessExpression_IM accExpr, Expression superTarget) {
        this.setTarget(accExpr, superTarget);
        EObject parent = accExpr.eContainer();
        if (parent instanceof ParameterizedCallExpression) {
            SymbolTableEntryOriginal callSTE = this.getSymbolTableEntryForMember((TClassifier)RuleEnvironmentExtensions.functionType((RuleEnvironment)this.getState().G), "call", false, false, true);
            this.setTarget((ParameterizedCallExpression)parent, (Expression)TranspilerBuilderBlocks._PropertyAccessExpr((Expression)accExpr, (SymbolTableEntry[])new SymbolTableEntry[]{callSTE}));
            this.addArgument((ParameterizedCallExpression)parent, 0, (Expression)TranspilerBuilderBlocks._ThisLiteral());
        }
    }

    private void transformSuperFieldAccessorAccess(ParameterizedPropertyAccessExpression_IM accExpr, Expression superTarget, SymbolTableEntryOriginal propertySTE) {
        boolean isSetter = this.isSetter(propertySTE);
        SymbolTableEntryOriginal ObjectSTE = this.getSymbolTableEntryOriginal((IdentifiableElement)RuleEnvironmentExtensions.objectType((RuleEnvironment)this.getState().G), true);
        SymbolTableEntryOriginal getOwnPropertyDescriptorSTE = this.getSymbolTableEntryForMember(RuleEnvironmentExtensions.objectType((RuleEnvironment)this.getState().G), "getOwnPropertyDescriptor", false, true, true);
        SymbolTableEntryOriginal callSTE = this.getSymbolTableEntryForMember((TClassifier)RuleEnvironmentExtensions.functionType((RuleEnvironment)this.getState().G), "call", false, false, true);
        ParameterizedCallExpression __CallExpr = TranspilerBuilderBlocks._CallExpr((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((SymbolTableEntry)ObjectSTE, (SymbolTableEntry[])new SymbolTableEntry[]{getOwnPropertyDescriptorSTE}), (Expression[])new Expression[]{superTarget, TranspilerBuilderBlocks._StringLiteralForSTE((SymbolTableEntry)propertySTE)});
        SymbolTableEntryInternal _xifexpression = null;
        _xifexpression = isSetter ? this.steFor_set() : this.steFor_get();
        ParameterizedCallExpression replacement = TranspilerBuilderBlocks._CallExpr((Expression)TranspilerBuilderBlocks._PropertyAccessExpr((Expression)__CallExpr, (SymbolTableEntry[])new SymbolTableEntry[]{_xifexpression, callSTE}), (Expression[])new Expression[]{TranspilerBuilderBlocks._ThisLiteral()});
        if (isSetter) {
            EObject _eContainer = accExpr.eContainer();
            AssignmentExpression parent = (AssignmentExpression)_eContainer;
            Expression value = parent.getRhs();
            EList _arguments = replacement.getArguments();
            Argument __Argument = TranspilerBuilderBlocks._Argument((Expression)value);
            _arguments.add((Object)__Argument);
            this.replace((Expression)parent, (Expression)replacement);
        } else {
            this.replace((Expression)accExpr, (Expression)replacement);
        }
    }

    private boolean isMethod(SymbolTableEntryOriginal ste) {
        return ste.getOriginalTarget() instanceof TMethod || IterableExtensions.exists((Iterable)ste.getElementsOfThisName(), it -> it instanceof N4MethodDeclaration);
    }

    private boolean isGetter(SymbolTableEntryOriginal ste) {
        return ste.getOriginalTarget() instanceof TGetter || IterableExtensions.exists((Iterable)ste.getElementsOfThisName(), it -> it instanceof N4GetterDeclaration);
    }

    private boolean isSetter(SymbolTableEntryOriginal ste) {
        return ste.getOriginalTarget() instanceof TSetter || IterableExtensions.exists((Iterable)ste.getElementsOfThisName(), it -> it instanceof N4SetterDeclaration);
    }
}

