/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.analysis;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.flowgraphs.analysis.BranchWalkerInternal;
import org.eclipse.n4js.flowgraphs.analysis.DeadFlowContext;
import org.eclipse.n4js.flowgraphs.analysis.FinallyFlowContext;
import org.eclipse.n4js.flowgraphs.analysis.NextEdgesProvider;
import org.eclipse.n4js.flowgraphs.model.ComplexNode;
import org.eclipse.n4js.flowgraphs.model.ControlFlowEdge;
import org.eclipse.n4js.flowgraphs.model.Node;

public class EdgeGuide {
    final NextEdgesProvider edgeProvider;
    final Collection<BranchWalkerInternal> branchWalkers;
    final FinallyFlowContext finallyContext;
    final DeadFlowContext deadContext;
    private ControlFlowEdge edge;

    EdgeGuide(NextEdgesProvider edgeProvider, ControlFlowEdge edge) {
        this(edgeProvider, edge, Sets.newHashSet());
    }

    EdgeGuide(NextEdgesProvider edgeProvider, ControlFlowEdge edge, Collection<BranchWalkerInternal> activePaths) {
        this(edgeProvider, edge, activePaths, null, null);
    }

    EdgeGuide(NextEdgesProvider edgeProvider, ControlFlowEdge edge, Collection<BranchWalkerInternal> activePaths, FinallyFlowContext finallyContext) {
        this(edgeProvider, edge, activePaths, finallyContext, null);
    }

    EdgeGuide(NextEdgesProvider edgeProvider, ControlFlowEdge edge, FinallyFlowContext finallyContext, DeadFlowContext deadContext) {
        this(edgeProvider, edge, Sets.newHashSet(), finallyContext, deadContext);
    }

    EdgeGuide(NextEdgesProvider edgeProvider, ControlFlowEdge edge, Collection<BranchWalkerInternal> activePaths, FinallyFlowContext finallyContext, DeadFlowContext deadContext) {
        this.edgeProvider = edgeProvider;
        this.edge = edge;
        this.branchWalkers = activePaths;
        this.finallyContext = new FinallyFlowContext(finallyContext, edge);
        this.deadContext = DeadFlowContext.create(deadContext, edgeProvider, edge);
        this.setBranchWalkersReachability();
    }

    static List<EdgeGuide> getFirstEdgeGuides(ComplexNode cn, NextEdgesProvider edgeProvider, Collection<BranchWalkerInternal> activatedPaths) {
        ControlFlowEdge nextEdge;
        LinkedList<EdgeGuide> nextEGs = new LinkedList<EdgeGuide>();
        Node node = edgeProvider.getStartNode(cn);
        List<ControlFlowEdge> nextEdges = edgeProvider.getNextEdges(node, new ControlFlowType[0]);
        Iterator<ControlFlowEdge> nextEdgeIt = nextEdges.iterator();
        if (nextEdges.size() == 1) {
            nextEdge = nextEdgeIt.next();
            EdgeGuide eg = new EdgeGuide(edgeProvider.copy(), nextEdge, activatedPaths);
            eg.deadContext.update(eg.getPrevNode());
            nextEGs.add(eg);
        }
        if (nextEdges.size() > 1) {
            while (nextEdgeIt.hasNext()) {
                nextEdge = nextEdgeIt.next();
                HashSet<BranchWalkerInternal> forkedPaths = new HashSet<BranchWalkerInternal>();
                for (BranchWalkerInternal aPath : activatedPaths) {
                    BranchWalkerInternal forkedPath = aPath.callFork();
                    forkedPaths.add(forkedPath);
                }
                EdgeGuide eg = new EdgeGuide(edgeProvider.copy(), nextEdge, forkedPaths);
                eg.deadContext.update(eg.getPrevNode());
                nextEGs.add(eg);
            }
        }
        return nextEGs;
    }

    Node getPrevNode() {
        return this.edgeProvider.getPrevNode(this.edge);
    }

    Node getNextNode() {
        return this.edgeProvider.getNextNode(this.edge);
    }

    List<EdgeGuide> getNextEdgeGuides() {
        ControlFlowEdge nextEdge;
        LinkedList<EdgeGuide> nextEGs = new LinkedList<EdgeGuide>();
        List<ControlFlowEdge> nextEdges = this.edgeProvider.getNextEdges(this.getNextNode(), new ControlFlowType[0]);
        nextEdges = this.finallyContext.filterEdges(nextEdges);
        Iterator<ControlFlowEdge> nextEdgeIt = nextEdges.iterator();
        boolean deadAliveChange = false;
        if (nextEdges.size() == 0) {
            for (BranchWalkerInternal aPath : this.getBranchIterable()) {
                aPath.deactivate();
            }
        }
        if (nextEdges.size() == 1 && !(deadAliveChange = this.isDeadAliveChange(nextEdges.get(0)))) {
            this.edge = nextEdge = nextEdgeIt.next();
            this.finallyContext.update(this.edgeProvider, this.edge);
            this.setBranchWalkersReachability();
            nextEGs.add(this);
        }
        if (deadAliveChange || nextEdges.size() > 1) {
            while (nextEdgeIt.hasNext()) {
                nextEdge = nextEdgeIt.next();
                HashSet<BranchWalkerInternal> forkedPaths = new HashSet<BranchWalkerInternal>();
                for (BranchWalkerInternal aPath : this.getBranchIterable()) {
                    BranchWalkerInternal forkedPath = aPath.callFork();
                    aPath.deactivate();
                    if (forkedPath == null) continue;
                    forkedPaths.add(forkedPath);
                }
                NextEdgesProvider epCopy = this.edgeProvider.copy();
                EdgeGuide edgeGuide = new EdgeGuide(epCopy, nextEdge, forkedPaths, this.finallyContext, this.deadContext);
                nextEGs.add(edgeGuide);
            }
        }
        return nextEGs;
    }

    private void setBranchWalkersReachability() {
        this.deadContext.update(this.edgeProvider, this.edge);
    }

    private boolean isDeadAliveChange(ControlFlowEdge cfEdge) {
        return cfEdge.cfType == ControlFlowType.DeadCode;
    }

    void addActiveBranches(Collection<BranchWalkerInternal> activatedPaths) {
        this.branchWalkers.addAll(activatedPaths);
    }

    Iterable<BranchWalkerInternal> getBranchIterable() {
        return this.branchWalkers;
    }

    ControlFlowEdge getEdge() {
        return this.edge;
    }

    public String toString() {
        return this.edge.toString();
    }

    boolean isEmpty() {
        return this.branchWalkers.isEmpty();
    }

    boolean isMerged() {
        return false;
    }
}

