/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.utils.NodeModulesDiscoveryHelper;
import org.eclipse.n4js.utils.ProjectDescriptionLoader;

public class ProjectDiscoveryHelper {
    @Inject
    NodeModulesDiscoveryHelper nodeModulesDiscoveryHelper;
    @Inject
    ProjectDescriptionLoader projectDescriptionLoader;

    public LinkedHashSet<Path> collectAllProjectDirs(Path ... workspaceRoots) {
        LinkedHashSet<Path> allProjectDirs = new LinkedHashSet<Path>();
        HashMap<File, List<String>> workspacesCache = new HashMap<File, List<String>>();
        Path[] pathArray = workspaceRoots;
        int n = workspaceRoots.length;
        int n2 = 0;
        while (n2 < n) {
            Path workspaceRoot = pathArray[n2];
            NodeModulesDiscoveryHelper.NodeModulesFolder nodeModulesFolder = this.nodeModulesDiscoveryHelper.getNodeModulesFolder(workspaceRoot, workspacesCache);
            if (nodeModulesFolder == null) {
                this.collectProjects(workspaceRoot, false, workspacesCache, allProjectDirs);
            } else if (nodeModulesFolder.isYarnWorkspace) {
                Path yarnProjectDir = nodeModulesFolder.nodeModulesFolder.getParentFile().toPath();
                allProjectDirs.add(yarnProjectDir);
                this.collectYarnWorkspaceProjects(yarnProjectDir, workspacesCache, allProjectDirs);
            } else {
                allProjectDirs.add(workspaceRoot);
            }
            ++n2;
        }
        List<Path> nodeModulesFolders = this.nodeModulesDiscoveryHelper.findNodeModulesFolders(allProjectDirs);
        for (Path nmFolder : new LinkedHashSet<Path>(nodeModulesFolders)) {
            this.collectProjects(nmFolder, true, workspacesCache, allProjectDirs);
        }
        return allProjectDirs;
    }

    private void collectYarnWorkspaceProjects(Path yarnProjectRoot, Map<File, List<String>> workspacesCache, Set<Path> projects) {
        List workspaces = workspacesCache.computeIfAbsent(yarnProjectRoot.toFile(), f -> this.projectDescriptionLoader.loadWorkspacesFromProjectDescriptionAtLocation(new FileURI((File)f)));
        for (String workspaceGlob : workspaces) {
            this.collectGlobMatches(workspaceGlob, yarnProjectRoot, workspacesCache, projects);
        }
    }

    private void collectProjects(final Path root, boolean includeSubtree, final Map<File, List<String>> workspacesCache, final Set<Path> allProjectDirs) {
        int depth;
        FileVisitResult defaultReturn;
        if (!root.toFile().isDirectory()) {
            return;
        }
        if (includeSubtree) {
            defaultReturn = FileVisitResult.CONTINUE;
            depth = Integer.MAX_VALUE;
        } else {
            defaultReturn = FileVisitResult.SKIP_SUBTREE;
            depth = 2;
        }
        try {
            EnumSet<FileVisitOption> none = EnumSet.noneOf(FileVisitOption.class);
            Files.walkFileTree(root, none, depth, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    if (root.equals(dir)) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (dir.endsWith("node_modules")) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    File pckJson = dir.resolve("package.json").toFile();
                    if (pckJson.isFile()) {
                        if (!root.endsWith("node_modules") && ProjectDiscoveryHelper.this.nodeModulesDiscoveryHelper.isYarnWorkspaceRoot(dir.toFile())) {
                            ProjectDiscoveryHelper.this.collectYarnWorkspaceProjects(dir, workspacesCache, allProjectDirs);
                        } else {
                            allProjectDirs.add(dir);
                        }
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return defaultReturn;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void collectGlobMatches(String glob, Path location, final Map<File, List<String>> workspacesCache, final Set<Path> allProjectDirs) {
        final PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + location.resolve(glob));
        try {
            Files.walkFileTree(location, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    if (dir.endsWith("node_modules")) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    if (pathMatcher.matches(dir)) {
                        Path dirName = dir.getName(dir.getNameCount() - 1);
                        if (dirName.toString().startsWith("@")) {
                            ProjectDiscoveryHelper.this.collectProjects(dir, false, workspacesCache, allProjectDirs);
                        } else {
                            File pckJson = dir.resolve("package.json").toFile();
                            if (pckJson.isFile()) {
                                allProjectDirs.add(dir);
                            }
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

