/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.generator.headless.HeadlessHelper;
import org.eclipse.n4js.generator.headless.N4JSCompileException;
import org.eclipse.n4js.ide.xtext.server.XIWorkspaceConfigFactory;
import org.eclipse.n4js.internal.FileBasedWorkspace;
import org.eclipse.n4js.internal.lsp.N4JSWorkspaceConfig;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.utils.ProjectDiscoveryHelper;
import org.eclipse.xtext.workspace.IWorkspaceConfig;

@Singleton
public class FileBasedWorkspaceInitializer
implements XIWorkspaceConfigFactory {
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private HeadlessHelper headlessHelper;
    @Inject
    private FileBasedWorkspace workspace;
    @Inject
    private ProjectDiscoveryHelper projectDiscoveryHelper;
    private URI knownWorkspaceBaseURI = null;

    @Override
    public IWorkspaceConfig getWorkspaceConfig(URI workspaceBaseURI) {
        try {
            if (workspaceBaseURI.equals(this.knownWorkspaceBaseURI)) {
                N4JSWorkspaceConfig n4JSWorkspaceConfig = new N4JSWorkspaceConfig(this.n4jsCore);
                return n4JSWorkspaceConfig;
            }
            this.workspace.clear();
            File workspaceRoot = new File(workspaceBaseURI.toFileString());
            LinkedHashSet allProjectLocations = this.projectDiscoveryHelper.collectAllProjectDirs(new Path[]{workspaceRoot.toPath()});
            ArrayList<FileURI> allProjectURIs = new ArrayList<FileURI>();
            for (Path path : allProjectLocations) {
                allProjectURIs.add(new FileURI(path.toFile()));
            }
            this.headlessHelper.registerProjectsToFileBasedWorkspace(allProjectURIs, this.workspace);
            N4JSWorkspaceConfig n4JSWorkspaceConfig = new N4JSWorkspaceConfig(this.n4jsCore);
            return n4JSWorkspaceConfig;
        }
        catch (N4JSCompileException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            this.knownWorkspaceBaseURI = workspaceBaseURI;
        }
    }
}

