/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

class MinimizedFileSystemElement
implements IWorkbenchAdapter,
IAdaptable {
    private boolean populated = false;
    private List<MinimizedFileSystemElement> folders = null;
    private List<MinimizedFileSystemElement> files = null;
    private String name;
    private boolean isDirectory = false;
    private MinimizedFileSystemElement parent;
    private Object fileSystemObject;

    public MinimizedFileSystemElement(String name, MinimizedFileSystemElement parent, boolean isDirectory) {
        this.name = name;
        this.parent = parent;
        this.isDirectory = isDirectory;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return (T)this;
        }
        return (T)Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    private void addChild(MinimizedFileSystemElement child) {
        if (child.isDirectory()) {
            if (this.folders == null) {
                this.folders = new ArrayList<MinimizedFileSystemElement>(1);
            }
            this.folders.add(child);
        } else {
            if (this.files == null) {
                this.files = new ArrayList<MinimizedFileSystemElement>(1);
            }
            this.files.add(child);
        }
    }

    protected List<MinimizedFileSystemElement> getFiles(IImportStructureProvider provider) {
        if (!this.populated) {
            this.populate(provider);
        }
        if (this.files == null) {
            return Collections.EMPTY_LIST;
        }
        return this.files;
    }

    protected List<MinimizedFileSystemElement> getFolders(IImportStructureProvider provider) {
        if (!this.populated) {
            this.populate(provider);
        }
        return this.getFolders();
    }

    protected List<MinimizedFileSystemElement> getFolders() {
        if (this.folders == null) {
            return Collections.EMPTY_LIST;
        }
        return this.folders;
    }

    protected boolean isPopulated() {
        return this.populated;
    }

    protected boolean notPopulated() {
        return !this.populated;
    }

    private void populate(IImportStructureProvider provider) {
        ArrayList children = provider.getChildren(this.fileSystemObject);
        if (children == null) {
            children = new ArrayList(1);
        }
        for (Object child : children) {
            String elementLabel = provider.getLabel(child);
            boolean isFolder = provider.isFolder(child);
            if (!isFolder && !elementLabel.endsWith(".class")) continue;
            MinimizedFileSystemElement result = new MinimizedFileSystemElement(elementLabel, this, isFolder);
            result.setFileSystemObject(child);
        }
        this.setPopulated();
    }

    protected Object getFileSystemObject() {
        return this.fileSystemObject;
    }

    protected void setFileSystemObject(Object value) {
        this.fileSystemObject = value;
    }

    protected void setPopulated() {
        this.populated = true;
    }

    public Object[] getChildren(Object o) {
        return this.getFolders().toArray();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        if (this.isDirectory()) {
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");
        }
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.name);
    }

    public String getLabel(Object o) {
        return this.name;
    }

    public Object getParent(Object o) {
        return this.parent;
    }
}

