/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.generator.headless;

import com.google.common.base.Joiner;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.n4js.generator.headless.BuildSet;
import org.eclipse.n4js.generator.headless.HeadlessHelper;
import org.eclipse.n4js.generator.headless.N4JSCompileException;
import org.eclipse.n4js.generator.headless.logging.IHeadlessLogger;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.locations.FileURI;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;
import org.eclipse.n4js.utils.collections.Collections2;

public class BuildSetComputer {
    @Inject
    private HeadlessHelper headlessHelper;
    @Inject
    private IHeadlessLogger logger;

    public BuildSet createSingleFileBuildSet(File singleSourceFile, Set<N4JSProjectName> shadowedProjectNames) throws N4JSCompileException {
        return this.createSingleFilesBuildSet(Arrays.asList(singleSourceFile), shadowedProjectNames);
    }

    public BuildSet createSingleFilesBuildSet(List<File> singleSourceFiles, Set<N4JSProjectName> shadowedProjectNames) throws N4JSCompileException {
        return this.createSingleFilesBuildSet(Collections.emptyList(), singleSourceFiles, shadowedProjectNames);
    }

    public BuildSet createSingleFilesBuildSet(List<File> searchPaths, List<File> singleSourceFiles, Set<N4JSProjectName> shadowedProjectNames) throws N4JSCompileException {
        return this.createBuildSet(searchPaths, Collections.emptyList(), singleSourceFiles, shadowedProjectNames);
    }

    public BuildSet createProjectsBuildSet(List<File> projectPaths, Set<N4JSProjectName> shadowedProjectNames) throws N4JSCompileException {
        return this.createProjectsBuildSet(Arrays.asList(new File(".")), projectPaths, shadowedProjectNames);
    }

    public BuildSet createProjectsBuildSet(List<File> searchPaths, List<File> projectPaths, Set<N4JSProjectName> shadowedProjectNames) throws N4JSCompileException {
        return this.createBuildSet(searchPaths, projectPaths, Collections.emptyList(), shadowedProjectNames);
    }

    public BuildSet createAllProjectsBuildSet(List<File> searchPaths, Set<N4JSProjectName> shadowedProjectNames) throws N4JSCompileException {
        List<File> absProjectPaths = this.headlessHelper.toAbsoluteFileList(searchPaths);
        List<File> projectPaths = this.headlessHelper.collectAllProjectPaths(absProjectPaths);
        return this.createBuildSet(searchPaths, projectPaths, Collections.emptyList(), shadowedProjectNames);
    }

    public BuildSet createBuildSet(List<File> searchPaths, List<File> projectPaths, List<File> singleSourceFiles, Set<N4JSProjectName> shadowedProjectNames) throws N4JSCompileException {
        this.logBuildSetComputerConfiguration(searchPaths, projectPaths, singleSourceFiles);
        return this.collectProjects(searchPaths, projectPaths, singleSourceFiles, shadowedProjectNames);
    }

    private void logBuildSetComputerConfiguration(List<File> searchPaths, List<File> projectPaths, List<File> singleSourceFiles) {
        if (this.logger.isCreateDebugOutput()) {
            this.logger.debug("Computing build set with the following arguments");
            this.logger.debug("  Search paths: " + Joiner.on((String)", ").join(searchPaths));
            this.logger.debug("  Projects    : " + Joiner.on((String)", ").join(projectPaths));
            this.logger.debug("  Source files: " + Joiner.on((String)", ").join(singleSourceFiles));
        }
    }

    private BuildSet collectProjects(List<File> searchPaths, List<File> projectPaths, List<File> singleSourceFiles, Set<N4JSProjectName> shadowedProjectNames) throws N4JSCompileException {
        com.google.common.base.Predicate resourceFilter;
        List<File> absSearchPaths = this.headlessHelper.toAbsoluteFileList(searchPaths);
        List<File> absProjectPaths = this.headlessHelper.toAbsoluteFileList(projectPaths);
        List<File> absSingleSourceFiles = this.headlessHelper.toAbsoluteFileList(singleSourceFiles);
        List<File> discoveredProjectLocations = this.headlessHelper.collectAllProjectPaths(absSearchPaths);
        List<File> singleSourceProjectLocations = this.findProjectsForSingleFiles(absSingleSourceFiles);
        List absRequestedProjectLocations = Collections2.concatUnique(absProjectPaths, singleSourceProjectLocations);
        List<FileURI> requestedProjectURIs = this.headlessHelper.createFileURIs(absRequestedProjectLocations);
        List<FileURI> discoveredProjectURIs = this.headlessHelper.createFileURIs(discoveredProjectLocations);
        List<IN4JSProject> requestedProjects = this.headlessHelper.getN4JSProjects(requestedProjectURIs);
        List<IN4JSProject> discoveredProjects = this.headlessHelper.getN4JSProjects(discoveredProjectURIs);
        LinkedHashMap<N4JSProjectName, IN4JSProject> discoveredResolvedMap = new LinkedHashMap<N4JSProjectName, IN4JSProject>();
        for (IN4JSProject prj : discoveredProjects) {
            discoveredResolvedMap.put(prj.getProjectName(), prj);
        }
        for (IN4JSProject prj : requestedProjects) {
            discoveredResolvedMap.remove(prj.getProjectName());
        }
        LinkedList<IN4JSProject> discoveredResolvedList = new LinkedList<IN4JSProject>(discoveredResolvedMap.values());
        Predicate<IN4JSProject> pred = p -> shadowedProjectNames.contains(p.getProjectName());
        requestedProjects.removeIf(pred);
        discoveredResolvedList.removeIf(pred);
        if (absSingleSourceFiles.isEmpty()) {
            resourceFilter = Predicates.alwaysTrue();
        } else {
            HashSet<FileURI> singleSourceURIs = new HashSet<FileURI>(this.headlessHelper.createFileURIs(absSingleSourceFiles));
            resourceFilter = Predicates.in(singleSourceURIs);
        }
        return new BuildSet(requestedProjects, discoveredResolvedList, (Predicate<FileURI>)resourceFilter);
    }

    private List<File> findProjectsForSingleFiles(List<File> sourceFiles) throws N4JSCompileException {
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (File sourceFile : sourceFiles) {
            FileURI sourceFileURI = new FileURI(sourceFile);
            FileURI projectURI = (FileURI)sourceFileURI.getProjectRoot();
            if (projectURI == null) {
                throw new N4JSCompileException("No project for file '" + sourceFile.toString() + "' found.");
            }
            result.add(projectURI);
        }
        return result.stream().map(u -> new File(u.toFileString())).collect(Collectors.toList());
    }
}

