/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.factories;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.n4js.flowgraphs.factories.CFEChildren;
import org.eclipse.n4js.flowgraphs.factories.ReentrantASTIterator;
import org.eclipse.n4js.flowgraphs.model.ComplexNode;
import org.eclipse.n4js.flowgraphs.model.HelperNode;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.flowgraphs.model.RepresentingNode;
import org.eclipse.n4js.n4JS.ControlFlowElement;

class StandardCFEFactory {
    StandardCFEFactory() {
    }

    static ComplexNode buildComplexNode(ReentrantASTIterator astpp, ControlFlowElement cfe) {
        return StandardCFEFactory.buildComplexNode(astpp, cfe, true);
    }

    static ComplexNode buildComplexNodeHidden(ReentrantASTIterator astpp, ControlFlowElement cfe) {
        return StandardCFEFactory.buildComplexNode(astpp, cfe, false);
    }

    private static ComplexNode buildComplexNode(ReentrantASTIterator astpp, ControlFlowElement cfe, boolean isRepresenting) {
        String extName;
        ComplexNode cNode = new ComplexNode(astpp.container(), cfe);
        HelperNode entryNode = new HelperNode("entry", astpp.pos(), cfe);
        List<Node> argumentNodes = CFEChildren.get(astpp, cfe);
        if (argumentNodes.isEmpty()) {
            entryNode = null;
            extName = "entryExit";
        } else {
            extName = "exit";
        }
        Node exitNode = isRepresenting ? new RepresentingNode(extName, astpp.pos(), cfe) : new HelperNode(extName, astpp.pos(), cfe);
        cNode.addNode(entryNode);
        for (Node arg : argumentNodes) {
            cNode.addNode(arg);
        }
        cNode.addNode(exitNode);
        LinkedList<Node> nodes = new LinkedList<Node>();
        nodes.add(entryNode);
        nodes.addAll(argumentNodes);
        nodes.add(exitNode);
        cNode.connectInternalSucc(nodes);
        if (argumentNodes.isEmpty()) {
            cNode.setEntryNode(exitNode);
        } else {
            cNode.setEntryNode(entryNode);
        }
        cNode.setExitNode(exitNode);
        return cNode;
    }
}

