/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.ui.services;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xpect.XpectInvocation;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.Issue;
import org.junit.ComparisonFailure;

public class LiveTestIssueFactory {
    private static final String _PREF = "org.eclipse.xpect.live_test_execution.";
    public static final String ISSUE_CODE_TEST_ERROR = "org.eclipse.xpect.live_test_execution.test_error";
    public static final String ISSUE_CODE_TEST_EXP_CHANGE = "org.eclipse.xpect.live_test_execution.expectation_change";
    public static final String ISSUE_CODE_TEST_EXP_DELETE = "org.eclipse.xpect.live_test_execution.expectation_delete";
    public static final String ISSUE_CODE_TEST_EXP_INSERT = "org.eclipse.xpect.live_test_execution.expectation_insert";
    public static final String ISSUE_CODE_TEST_FAIL = "org.eclipse.xpect.live_test_execution.test_fail";
    public static final String ISSUE_CODE_TEST_IGNORE = "org.eclipse.xpect.live_test_execution.test_ignore";
    public static final String ISSUE_CODE_TEST_SUCCESS = "org.eclipse.xpect.live_test_execution.test_success";

    protected Issue.IssueImpl createIssue(XpectInvocation inv) {
        Issue.IssueImpl issue = new Issue.IssueImpl();
        issue.setType(CheckType.FAST);
        issue.setUriToProblem(EcoreUtil.getURI((EObject)inv));
        return issue;
    }

    protected Issue.IssueImpl createIssueOnInvocation(XpectInvocation inv) {
        Issue.IssueImpl issue = this.createIssue(inv);
        ITextRegion region = this.findXPECTKeywordRegion(inv);
        if (region != null) {
            issue.setOffset(Integer.valueOf(region.getOffset()));
            issue.setLength(Integer.valueOf(region.getLength()));
        } else {
            issue.setOffset(Integer.valueOf(0));
            issue.setLength(Integer.valueOf(1));
        }
        return issue;
    }

    public Issue createSuccessIssue(XpectInvocation inv) {
        Issue.IssueImpl issue = this.createIssueOnInvocation(inv);
        issue.setMessage("Xpect test passed successfully.");
        issue.setCode(ISSUE_CODE_TEST_SUCCESS);
        issue.setSeverity(Severity.INFO);
        return issue;
    }

    protected void exceptionToIssues(XpectInvocation inv, AssertionError exception, IAcceptor<Issue> result) {
        Issue.IssueImpl issue = this.createIssueOnInvocation(inv);
        issue.setMessage("Xpect test failed: " + ((Throwable)((Object)exception)).getMessage());
        issue.setCode(ISSUE_CODE_TEST_FAIL);
        issue.setSeverity(Severity.ERROR);
        result.accept((Object)issue);
    }

    protected void exceptionToIssues(XpectInvocation inv, ComparisonFailure exception, IAcceptor<Issue> result) {
        ComparisonFailure cf = exception;
        String actualDoc = cf.getActual();
        String expectedDoc = inv.getFile().getDocument();
        int fromStart = 0;
        int fromEnd = 1;
        int length = Math.min(actualDoc.length(), expectedDoc.length());
        while (fromStart < length && actualDoc.charAt(fromStart) == expectedDoc.charAt(fromStart)) {
            ++fromStart;
        }
        while (fromEnd < length && actualDoc.charAt(actualDoc.length() - fromEnd) == expectedDoc.charAt(expectedDoc.length() - fromEnd)) {
            ++fromEnd;
        }
        while (!(fromStart <= 0 || Character.isWhitespace(expectedDoc.charAt(fromStart)) && expectedDoc.charAt(fromStart) != '\n' && expectedDoc.charAt(fromStart) != '\r')) {
            --fromStart;
        }
        while (fromEnd > 0 && !Character.isWhitespace(expectedDoc.charAt(expectedDoc.length() - fromEnd))) {
            --fromEnd;
        }
        if (fromStart + fromEnd >= expectedDoc.length()) {
            String text = actualDoc.substring(fromStart, actualDoc.length() - fromEnd + 1);
            Issue.IssueImpl issue = this.createIssue(inv);
            issue.setMessage("Xpect test failed because the actual test result has '" + text + "' here.");
            issue.setOffset(Integer.valueOf(fromStart));
            issue.setLength(Integer.valueOf(0));
            issue.setCode(ISSUE_CODE_TEST_EXP_INSERT);
            issue.setData(new String[]{text});
            result.accept((Object)issue);
        } else {
            int endIndex = actualDoc.length() - fromEnd;
            if (endIndex <= ++fromStart) {
                Issue.IssueImpl issue = this.createIssue(inv);
                issue.setMessage("Xpect test failed because this text is not part of the actual test result.");
                issue.setOffset(Integer.valueOf(fromStart));
                issue.setLength(Integer.valueOf(expectedDoc.length() - fromStart - fromEnd));
                issue.setCode(ISSUE_CODE_TEST_EXP_DELETE);
                result.accept((Object)issue);
            } else {
                String text = actualDoc.substring(fromStart, endIndex);
                Issue.IssueImpl issue = this.createIssue(inv);
                issue.setMessage("Xpect test failed because in the actual test result this text is: " + text);
                issue.setOffset(Integer.valueOf(fromStart));
                issue.setLength(Integer.valueOf(expectedDoc.length() - fromStart - fromEnd));
                issue.setCode(ISSUE_CODE_TEST_EXP_CHANGE);
                issue.setData(new String[]{text});
                result.accept((Object)issue);
            }
        }
    }

    public void exceptionToIssues(XpectInvocation inv, Throwable exception, IAcceptor<Issue> result) {
        if (exception instanceof ComparisonFailure) {
            this.exceptionToIssues(inv, (ComparisonFailure)exception, result);
        } else if (exception instanceof AssertionError) {
            this.exceptionToIssues(inv, (AssertionError)((Object)exception), result);
        } else {
            Issue.IssueImpl issue = this.createIssueOnInvocation(inv);
            issue.setMessage("Xpect test failed: " + exception.getMessage());
            issue.setCode(ISSUE_CODE_TEST_ERROR);
            issue.setSeverity(Severity.ERROR);
            result.accept((Object)issue);
        }
    }

    protected ITextRegion findXPECTKeywordRegion(XpectInvocation inv) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)inv);
        for (ILeafNode l : node.getLeafNodes()) {
            if (!(l.getGrammarElement() instanceof Keyword) || !l.getText().equals("XPECT")) continue;
            return l.getTextRegion();
        }
        return null;
    }
}

