/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.json.ui.contentassist;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.n4js.json.services.JSONGrammarAccess;
import org.eclipse.n4js.json.ui.contentassist.StyledTemplateProposal;
import org.eclipse.n4js.json.ui.labeling.JSONImageDescriptorCache;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.templates.XtextTemplateContextTypeRegistry;

public class JSONProposalFactory {
    @Inject
    private XtextTemplateContextTypeRegistry contextTypeRegistry;
    @Inject
    private JSONGrammarAccess grammarAccess;
    private static final String GEN_NAME_VALUE_TEMPLATE_STRING = "\"${name}\": \"${value}\"";
    private static final String GEN_NAME_ARRAY_TEMPLATE_STRING = "\"${name}\": [${value}]";
    private static final String GEN_NAME_OBJECT_TEMPLATE_STRING = "\"${name}\": {${value}}";

    private static final String getNAME_VALUE_TEMPLATE_STRING(String name) {
        return "\"" + name + "\": \"${value}\"";
    }

    private static final String getNAME_ARRAY_TEMPLATE_STRING(String name) {
        return "\"" + name + "\": [${value}]";
    }

    private static final String getNAME_OBJECT_TEMPLATE_STRING(String name) {
        return "\"" + name + "\": {${value}}";
    }

    public ICompletionProposal createGenericNameValueProposal(ContentAssistContext context) {
        return this.createNameValueProposal(context, "<value>", "", "Generic name value pair", true);
    }

    public ICompletionProposal createGenericNameArrayProposal(ContentAssistContext context) {
        return this.createNameArrayProposal(context, "<array>", "", "Generic name array pair", true);
    }

    public ICompletionProposal createGenericNameObjectProposal(ContentAssistContext context) {
        return this.createNameObjectProposal(context, "<object>", "", "Generic name object pair", true);
    }

    public ICompletionProposal createNameValueProposal(ContentAssistContext context, String name, String value, String description) {
        return this.createNameValueProposal(context, name, value, description, false);
    }

    public ICompletionProposal createNameArrayProposal(ContentAssistContext context, String name, String array, String description) {
        return this.createNameArrayProposal(context, name, array, description, false);
    }

    public ICompletionProposal createNameObjectProposal(ContentAssistContext context, String name, String object, String description) {
        return this.createNameObjectProposal(context, name, object, description, false);
    }

    private ICompletionProposal createNameValueProposal(ContentAssistContext context, String name, String value, String description, boolean isGenericProposal) {
        Image image = (Image)JSONImageDescriptorCache.ImageRef.JSON_VALUE.asImage().orNull();
        String rawTemplate = isGenericProposal ? GEN_NAME_VALUE_TEMPLATE_STRING : JSONProposalFactory.getNAME_VALUE_TEMPLATE_STRING(name);
        return this.createProposal(context, name, value, description, rawTemplate, image, isGenericProposal);
    }

    private ICompletionProposal createNameArrayProposal(ContentAssistContext context, String name, String array, String description, boolean isGenericProposal) {
        Image image = (Image)JSONImageDescriptorCache.ImageRef.JSON_ARRAY.asImage().orNull();
        String rawTemplate = isGenericProposal ? GEN_NAME_ARRAY_TEMPLATE_STRING : JSONProposalFactory.getNAME_ARRAY_TEMPLATE_STRING(name);
        return this.createProposal(context, name, array, description, rawTemplate, image, isGenericProposal);
    }

    private ICompletionProposal createNameObjectProposal(ContentAssistContext context, String name, String object, String description, boolean isGenericProposal) {
        Image image = (Image)JSONImageDescriptorCache.ImageRef.JSON_OBJECT.asImage().orNull();
        String rawTemplate = isGenericProposal ? GEN_NAME_OBJECT_TEMPLATE_STRING : JSONProposalFactory.getNAME_OBJECT_TEMPLATE_STRING(name);
        return this.createProposal(context, name, object, description, rawTemplate, image, isGenericProposal);
    }

    private ICompletionProposal createProposal(ContentAssistContext context, String name, String value, String description, String rawTemplate, Image image, boolean isGenericProposal) {
        TemplateContextType contextType = this.getTemplateContextType();
        IXtextDocument document = context.getDocument();
        DocumentTemplateContext tContext = new DocumentTemplateContext(contextType, (IDocument)document, context.getOffset(), 0);
        Region replaceRegion = context.getReplaceRegion();
        if (isGenericProposal) {
            tContext.setVariable("name", name);
        }
        tContext.setVariable("value", value);
        return new StyledTemplateProposal(context, name, description, rawTemplate, isGenericProposal, (TemplateContext)tContext, (IRegion)replaceRegion, image);
    }

    private TemplateContextType getTemplateContextType() {
        return this.contextTypeRegistry.getContextType(this.contextTypeRegistry.getId(this.grammarAccess.getNameValuePairRule()));
    }

    static StyledString createStyledString(String primary, String secondary) {
        return JSONProposalFactory.createStyledString(primary, secondary, null);
    }

    static StyledString createStyledString(String primary, String secondary, StyledString.Styler styler) {
        StyledString styledString = new StyledString();
        if (styler != null) {
            styledString.append(primary, styler);
        } else {
            styledString.append(primary);
        }
        if (!Strings.isNullOrEmpty((String)secondary)) {
            styledString.append(" - " + secondary, StyledString.QUALIFIER_STYLER);
        }
        return styledString;
    }
}

