/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.dataflow.symbols;

import java.util.LinkedList;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.Symbol;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.SymbolFactory;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ParameterizedPropertyAccessExpression;

public class SymbolOfParameterizedPropertyAccessExpression
extends Symbol {
    private final SymbolFactory symbolFactory;
    final ParameterizedPropertyAccessExpression ppae;
    final Symbol contextSymbol;

    SymbolOfParameterizedPropertyAccessExpression(SymbolFactory symbolFactory, ParameterizedPropertyAccessExpression ppae) {
        this.symbolFactory = symbolFactory;
        this.ppae = ppae;
        this.contextSymbol = this.getContextSymbol();
    }

    public ParameterizedPropertyAccessExpression getASTLocation() {
        return this.ppae;
    }

    @Override
    public String getName() {
        String name = this.ppae.getProperty().getName();
        Expression tgtExpr = this.ppae.getTarget();
        Symbol tgtSymbol = this.symbolFactory.create((ControlFlowElement)tgtExpr);
        if (tgtSymbol != null) {
            name = String.valueOf(tgtSymbol.getName()) + "." + name;
        }
        return name;
    }

    @Override
    public EObject getDeclaration() {
        return this.ppae.getProperty();
    }

    @Override
    public Expression getContext() {
        return this.ppae.getTarget();
    }

    @Override
    public Symbol getContextSymbol() {
        if (this.contextSymbol != null) {
            return this.contextSymbol;
        }
        return this.symbolFactory.create((ControlFlowElement)this.getContext());
    }

    @Override
    protected Object createSymbolKey() {
        LinkedList<Object> keyChain = new LinkedList<Object>();
        keyChain.add(this.getDeclaration());
        Expression lastContext = this.getContext();
        Symbol tgtSymbol = this.getContextSymbol();
        while (tgtSymbol != null) {
            keyChain.add(tgtSymbol.getDeclaration());
            lastContext = tgtSymbol.getContext();
            tgtSymbol = tgtSymbol.getContextSymbol();
        }
        if (lastContext != null) {
            keyChain.add(lastContext);
        }
        int hash = Objects.hash(keyChain.toArray(new Object[keyChain.size()]));
        return hash;
    }

    @Override
    public boolean isStrucuralAlias(Symbol symbol) {
        if (!(symbol instanceof SymbolOfParameterizedPropertyAccessExpression)) {
            return false;
        }
        SymbolOfParameterizedPropertyAccessExpression s = (SymbolOfParameterizedPropertyAccessExpression)symbol;
        return this.ppae.getProperty().equals(s.ppae.getProperty());
    }
}

