/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.analysers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.n4js.flowgraphs.analysis.BranchWalkerInternal;
import org.eclipse.n4js.flowgraphs.analysis.GraphExplorerInternal;
import org.eclipse.n4js.flowgraphs.analysis.GraphVisitorInternal;
import org.eclipse.n4js.flowgraphs.analysis.TraverseDirection;
import org.eclipse.n4js.flowgraphs.dataflow.EffectInfo;
import org.eclipse.n4js.flowgraphs.dataflow.EffectType;
import org.eclipse.n4js.flowgraphs.dataflow.guards.Guard;
import org.eclipse.n4js.flowgraphs.dataflow.guards.GuardStructure;
import org.eclipse.n4js.flowgraphs.dataflow.guards.GuardStructureFactory;
import org.eclipse.n4js.flowgraphs.dataflow.guards.GuardType;
import org.eclipse.n4js.flowgraphs.dataflow.guards.InstanceofGuard;
import org.eclipse.n4js.flowgraphs.dataflow.symbols.Symbol;
import org.eclipse.n4js.flowgraphs.model.ControlFlowEdge;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.IdentifierRef;

public class InstanceofGuardAnalyser
extends GraphVisitorInternal {
    Map<ControlFlowElement, InstanceofBranchWalker> elementsToBranch = new HashMap<ControlFlowElement, InstanceofBranchWalker>();
    Multimap<IdentifierRef, InstanceofGuard> guardsOnIRef = HashMultimap.create();

    public InstanceofGuardAnalyser() {
        super(TraverseDirection.Forward);
    }

    public Collection<InstanceofGuard> getAlwaysHoldingTypes(ControlFlowElement cfe) {
        if (cfe instanceof IdentifierRef) {
            return this.guardsOnIRef.get((Object)((IdentifierRef)cfe));
        }
        return Collections.emptyList();
    }

    @Override
    protected void initializeContainerInternal(ControlFlowElement curContainer) {
        this.requestActivation(new InstanceofGraphExplorer());
    }

    class InstanceofBranchWalker
    extends BranchWalkerInternal {
        Multimap<Symbol, InstanceofGuard> guards = HashMultimap.create();

        InstanceofBranchWalker() {
        }

        @Override
        protected BranchWalkerInternal fork() {
            InstanceofBranchWalker ibw = new InstanceofBranchWalker();
            ibw.guards.putAll(this.guards);
            return ibw;
        }

        @Override
        protected void visit(Node node) {
            ControlFlowElement cfe = node.getControlFlowElement();
            InstanceofGuardAnalyser.this.elementsToBranch.put(cfe, this);
            Collection<EffectInfo> writeEInfos = EffectInfo.findAll(node.effectInfos, EffectType.Write);
            if (!writeEInfos.isEmpty()) {
                for (EffectInfo ei : writeEInfos) {
                    this.guards.removeAll((Object)ei.symbol);
                    InstanceofGuardAnalyser.this.guardsOnIRef.removeAll((Object)ei.location);
                }
            }
            if (cfe instanceof IdentifierRef) {
                IdentifierRef iRef = (IdentifierRef)cfe;
                Symbol cfeSymbol = InstanceofGuardAnalyser.this.getSymbolFactory().create(cfe);
                if (cfeSymbol != null && cfeSymbol.definingContainers.size() < 2) {
                    Collection guardsOnCfe = this.guards.get((Object)cfeSymbol);
                    InstanceofGuardAnalyser.this.guardsOnIRef.replaceValues((Object)iRef, (Iterable)guardsOnCfe);
                }
            }
        }

        @Override
        protected void visit(Node lastVisitNode, Node end, ControlFlowEdge edge) {
            GuardStructure guardStructure = GuardStructureFactory.create(InstanceofGuardAnalyser.this.getSymbolFactory(), edge);
            if (guardStructure != null) {
                for (Guard guard : guardStructure.allGuards()) {
                    if (guard.type != GuardType.InstanceOf) continue;
                    InstanceofGuard instanceofGuard = (InstanceofGuard)guard;
                    switch (guard.asserts) {
                        case AlwaysHolds: {
                            this.guards.put((Object)guard.getSymbol(), (Object)instanceofGuard);
                            break;
                        }
                        case NeverHolds: {
                            break;
                        }
                        case MayHolds: {
                            break;
                        }
                    }
                }
            }
        }
    }

    class InstanceofGraphExplorer
    extends GraphExplorerInternal {
        InstanceofGraphExplorer() {
        }

        @Override
        protected BranchWalkerInternal firstBranchWalker() {
            return new InstanceofBranchWalker();
        }

        @Override
        protected BranchWalkerInternal joinBranchWalkers(List<BranchWalkerInternal> branchWalkers) {
            InstanceofBranchWalker joinedIBW = new InstanceofBranchWalker();
            Iterator<BranchWalkerInternal> bwiIter = branchWalkers.iterator();
            if (!bwiIter.hasNext()) {
                return joinedIBW;
            }
            InstanceofBranchWalker ibw = (InstanceofBranchWalker)bwiIter.next();
            joinedIBW.guards.putAll(ibw.guards);
            while (bwiIter.hasNext()) {
                ibw = (InstanceofBranchWalker)bwiIter.next();
                if (ibw.isDeadCodeBranch()) continue;
                joinedIBW.guards.keySet().retainAll(ibw.guards.keySet());
                for (Symbol symbol : joinedIBW.guards.keySet()) {
                    joinedIBW.guards.get((Object)symbol).retainAll(ibw.guards.get((Object)symbol));
                }
            }
            return joinedIBW;
        }
    }
}

