/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.binaries;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.n4js.binaries.BinariesCommandFactory;
import org.eclipse.n4js.binaries.BinariesConstants;
import org.eclipse.n4js.binaries.Binary;
import org.eclipse.n4js.binaries.BinaryStatus;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.n4js.semver.SemverHelper;
import org.eclipse.n4js.semver.SemverMatcher;
import org.eclipse.n4js.semver.model.SemverSerializer;
import org.eclipse.n4js.utils.StatusHelper;
import org.eclipse.n4js.utils.process.ProcessResult;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.IParseResult;

@Singleton
public class BinariesValidator {
    private static final Logger LOGGER = Logger.getLogger(BinariesValidator.class);
    @Inject
    private StatusHelper status;
    @Inject
    private BinariesCommandFactory commandFactory;
    @Inject
    private SemverHelper semverHelper;

    public IStatus validate(Binary binary) {
        String stdOutString;
        IParseResult parseResult;
        String stdErrString;
        IStatus simpleValidation = this.binaryExists(binary);
        if (!simpleValidation.isOK()) {
            return simpleValidation;
        }
        File file = this.findExecutableFile(binary);
        if (!file.canExecute()) {
            return this.error(binary, "Cannot execute '" + binary.getLabel() + "' binary at: " + file + ".");
        }
        ProcessResult result = this.commandFactory.checkBinaryVersionCommand(binary).execute();
        if (!result.isOK()) {
            return this.error(binary, "Expected exit code 0 when checking version of '" + binary.getLabel() + "' got " + result.getExitCode() + "' instead.\n" + result.getStdErr());
        }
        if (LOGGER.isDebugEnabled() && !(stdErrString = result.getStdErr()).isEmpty()) {
            LOGGER.debug((Object)stdErrString);
        }
        if ((parseResult = this.semverHelper.getParseResult((stdOutString = result.getStdOut()).trim())).hasSyntaxErrors()) {
            INode firstErrorNode = (INode)parseResult.getSyntaxErrors().iterator().next();
            String syntaxErr = firstErrorNode.getSyntaxErrorMessage().getMessage();
            String msg = "Error in binary '" + binary.getLabel() + "' when parsing version '" + stdOutString + "': " + syntaxErr;
            return this.error(binary, msg);
        }
        VersionNumber versionNumber = this.semverHelper.parseVersionNumber(parseResult);
        if (versionNumber == null) {
            String msg = "Error in binary '" + binary.getLabel() + "' when parsing version '" + stdOutString + "': No version number found.";
            return this.error(binary, msg);
        }
        VersionNumber minimumVersion = binary.getMinimumVersion();
        SemverMatcher.VersionNumberRelation versionRelation = SemverMatcher.relation((VersionNumber)versionNumber, (VersionNumber)minimumVersion);
        if (!versionRelation.isGreaterOrEqual()) {
            String minimumVersionText = SemverSerializer.serialize((VersionNumber)minimumVersion);
            String parsedVersionText = SemverSerializer.serialize((VersionNumber)versionNumber);
            String msg = "The required minimum version of '" + binary.getLabel() + "' is '" + minimumVersionText + "'. Currently configured version is '" + parsedVersionText + "' which is '" + versionRelation + "' than the minimum version but it must be greater or equal.";
            return this.error(binary, msg);
        }
        return Status.OK_STATUS;
    }

    public IStatus binaryExists(Binary binary) {
        String[] stringArray = BinariesConstants.EXECUTABLE_FILE_EXTENSIONS;
        int n = BinariesConstants.EXECUTABLE_FILE_EXTENSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String exec = stringArray[n2];
            File file = new File(String.valueOf(binary.getBinaryAbsolutePath()) + exec);
            if (file.exists()) {
                if (file.isFile()) {
                    return Status.OK_STATUS;
                }
                return this.error(binary, "Invalid '" + binary.getLabel() + "' configuration. Expected file at: " + file + ". Got a directory instead.");
            }
            ++n2;
        }
        return this.error(binary, "'" + binary.getLabel() + "' binary does not exist at " + binary.getBinaryAbsolutePath() + ". Please check your preferences.");
    }

    public File findExecutableFile(Binary binary) {
        String[] stringArray = BinariesConstants.EXECUTABLE_FILE_EXTENSIONS;
        int n = BinariesConstants.EXECUTABLE_FILE_EXTENSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String exec = stringArray[n2];
            File file = new File(String.valueOf(binary.getBinaryAbsolutePath()) + exec);
            if (file.isFile()) {
                return file;
            }
            ++n2;
        }
        return null;
    }

    private IStatus error(Binary binary, String message) {
        return this.error(binary, message, null);
    }

    private IStatus error(Binary binary, String message, Throwable t) {
        IStatus delegate = this.status.createError(message, 4405777, t);
        return new BinaryStatus(delegate, binary);
    }
}

