/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.concurrent.TimeUnit;

public class SimpleTimeFormat
extends Format {
    private static final String NO_DECIMAL = "%.0f %s";
    private static final String WITH_DECIMAL = "%.4g %s";

    public static String convert(long duration) {
        return SimpleTimeFormat.convertWithFormat(duration, WITH_DECIMAL);
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj instanceof Double) {
            return toAppendTo.append(SimpleTimeFormat.convertWithFormat(((Double)obj).longValue(), NO_DECIMAL));
        }
        throw new RuntimeException("Unexpected call.");
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        throw new RuntimeException("Unexpected call.");
    }

    private static String convertWithFormat(long duration, String format) {
        long nanos = Math.abs(duration);
        TimeUnit unit = SimpleTimeFormat.chooseUnit(nanos);
        double value = (double)nanos / (double)TimeUnit.NANOSECONDS.convert(1L, unit);
        String converted = String.format(format, value, SimpleTimeFormat.abbreviate(unit));
        if (duration < 0L) {
            return "-" + converted;
        }
        return converted;
    }

    private static TimeUnit chooseUnit(long nanos) {
        if (TimeUnit.DAYS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.DAYS;
        }
        if (TimeUnit.HOURS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.HOURS;
        }
        if (TimeUnit.MINUTES.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MINUTES;
        }
        if (TimeUnit.SECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.SECONDS;
        }
        if (TimeUnit.MILLISECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MILLISECONDS;
        }
        if (TimeUnit.MICROSECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MICROSECONDS;
        }
        return TimeUnit.NANOSECONDS;
    }

    private static String abbreviate(TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "\u03bcs";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "min";
            }
            case HOURS: {
                return "h";
            }
            case DAYS: {
                return "d";
            }
        }
        throw new RuntimeException("Unsupported unit " + unit.name());
    }
}

