/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesbuilder;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.AnnotableElement;
import org.eclipse.n4js.n4JS.Annotation;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.GenericDeclaration;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.N4MethodDeclaration;
import org.eclipse.n4js.n4JS.N4Modifier;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.PropertyNameOwner;
import org.eclipse.n4js.n4JS.SuperLiteral;
import org.eclipse.n4js.n4JS.ThisLiteral;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.typeRefs.ThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.MemberAccessModifier;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesbuilder.AbstractFunctionDefinitionTypesBuilder;
import org.eclipse.n4js.typesbuilder.N4JSTypesBuilderHelper;
import org.eclipse.n4js.utils.EcoreUtilN4;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Singleton
class N4JSMethodTypesBuilder
extends AbstractFunctionDefinitionTypesBuilder {
    @Inject
    @Extension
    private N4JSTypesBuilderHelper _n4JSTypesBuilderHelper;

    N4JSMethodTypesBuilder() {
    }

    boolean relinkMethod(N4MethodDeclaration methodDecl, TClassifier classifier, boolean preLinkingPhase, int idx) {
        Object _eGet = methodDecl.eGet((EStructuralFeature)N4JSPackage.eINSTANCE.getTypeDefiningElement_DefinedType(), false);
        EObject methodDefinedType = (EObject)_eGet;
        if (methodDefinedType != null && !methodDefinedType.eIsProxy()) {
            throw new IllegalStateException("TMethod already created for N4MethodDeclaration");
        }
        if (methodDecl.getName() == null && !methodDecl.hasComputedPropertyName() && !methodDecl.isCallableConstructor()) {
            return false;
        }
        TMember _get = (TMember)classifier.getOwnedMembers().get(idx);
        TMethod methodType = (TMethod)_get;
        this._n4JSTypesBuilderHelper.ensureEqualName((NamedElement)methodDecl, (IdentifiableElement)methodType);
        this.relinkFormalParameters((TFunction)methodType, (FunctionDefinition)methodDecl, preLinkingPhase);
        methodType.setAstElement((EObject)methodDecl);
        methodDecl.setDefinedType((Type)methodType);
        return true;
    }

    boolean relinkCallableCtor(N4MethodDeclaration methodDecl, TClassifier classifier, boolean preLinkingPhase) {
        boolean _not_1;
        boolean _not;
        Object _eGet = methodDecl.eGet((EStructuralFeature)N4JSPackage.eINSTANCE.getTypeDefiningElement_DefinedType(), false);
        EObject methodDefinedType = (EObject)_eGet;
        if (methodDefinedType != null && !methodDefinedType.eIsProxy()) {
            throw new IllegalStateException("TMethod already created for N4MethodDeclaration");
        }
        boolean _isCallableConstructor = methodDecl.isCallableConstructor();
        boolean bl = _not = !_isCallableConstructor;
        if (_not) {
            throw new RuntimeException("Provided method was neither constructor nor callable constructor.");
        }
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)methodDecl.getName());
        boolean bl2 = _not_1 = !_isNullOrEmpty;
        if (_not_1) {
            String _name = methodDecl.getName();
            String _plus = "Callable ctor cannot have a name, had " + _name;
            throw new RuntimeException(_plus);
        }
        boolean _hasComputedPropertyName = methodDecl.hasComputedPropertyName();
        if (_hasComputedPropertyName) {
            throw new RuntimeException("Callable constructor cannot have computed name.");
        }
        TMethod methodType = classifier.getCallableCtor();
        this.relinkFormalParameters((TFunction)methodType, (FunctionDefinition)methodDecl, preLinkingPhase);
        methodType.setAstElement((EObject)methodDecl);
        methodDecl.setDefinedType((Type)methodType);
        return true;
    }

    TMethod createMethod(N4MethodDeclaration methodDecl, boolean preLinkingPhase) {
        Object _eGet = methodDecl.eGet((EStructuralFeature)N4JSPackage.eINSTANCE.getTypeDefiningElement_DefinedType(), false);
        EObject methodDefinedType = (EObject)_eGet;
        if (methodDefinedType != null && !methodDefinedType.eIsProxy()) {
            throw new IllegalStateException("TMethod already created for N4MethodDeclaration");
        }
        if (methodDecl.getName() == null && !methodDecl.hasComputedPropertyName() && !methodDecl.isCallableConstructor()) {
            return null;
        }
        TMethod methodType = TypesFactory.eINSTANCE.createTMethod();
        this._n4JSTypesBuilderHelper.setMemberName((TMember)methodType, (PropertyNameOwner)methodDecl);
        methodType.setDeclaredAbstract(methodDecl.isAbstract());
        methodType.setDeclaredStatic(methodDecl.isDeclaredStatic());
        methodType.setDeclaredFinal(methodDecl.isDeclaredFinal());
        methodType.setDeclaredOverride(AnnotationDefinition.OVERRIDE.hasAnnotation((AnnotableElement)methodDecl));
        methodType.setConstructor(methodDecl.isConstructor());
        methodType.setDeclaredAsync(methodDecl.isAsync());
        methodType.setDeclaredGenerator(methodDecl.isGenerator());
        boolean providesDefaultImpl = AnnotationDefinition.PROVIDES_DEFAULT_IMPLEMENTATION.hasAnnotation((AnnotableElement)methodDecl);
        methodType.setHasNoBody(methodDecl.getBody() == null && !providesDefaultImpl);
        methodType.setLacksThisOrSuperUsage(this.hasNonNullBody(methodDecl.getBody()) && !this.containsThisOrSuperUsage(methodDecl.getBody()));
        BuiltInTypeScope builtInTypeScope = BuiltInTypeScope.get((ResourceSet)methodDecl.eResource().getResourceSet());
        this.setMemberAccessModifier(methodType, methodDecl);
        this.addTypeVariables((TFunction)methodType, (GenericDeclaration)methodDecl, preLinkingPhase);
        this.addFormalParameters((TFunction)methodType, (FunctionDefinition)methodDecl, builtInTypeScope, preLinkingPhase);
        this.setReturnTypeConsideringThis(methodType, methodDecl, builtInTypeScope, preLinkingPhase);
        this._n4JSTypesBuilderHelper.setDeclaredThisTypeFromAnnotation((TFunction)methodType, (FunctionDefinition)methodDecl, preLinkingPhase);
        this._n4JSTypesBuilderHelper.copyAnnotations((TAnnotableElement)methodType, (AnnotableElement)methodDecl, preLinkingPhase);
        methodType.setAstElement((EObject)methodDecl);
        methodDecl.setDefinedType((Type)methodType);
        return methodType;
    }

    private void setMemberAccessModifier(TMethod methodType, N4MethodDeclaration n4Method) {
        Procedures.Procedure1 _function = modifier -> methodType.setDeclaredMemberAccessModifier(modifier);
        this._n4JSTypesBuilderHelper.setMemberAccessModifier((Procedures.Procedure1<? super MemberAccessModifier>)_function, (Collection<? extends N4Modifier>)n4Method.getDeclaredModifiers(), (List<Annotation>)n4Method.getAnnotations());
    }

    private void setReturnTypeConsideringThis(TMethod methodType, N4MethodDeclaration methodDecl, BuiltInTypeScope builtInTypeScope, boolean preLinkingPhase) {
        if (methodDecl.isConstructor() || methodDecl.getReturnTypeRef() instanceof ThisTypeRef) {
            methodType.setReturnTypeRef((TypeRef)TypeUtils.createDeferredTypeRef());
        } else {
            this.setReturnType((TFunction)methodType, (FunctionDefinition)methodDecl, builtInTypeScope, preLinkingPhase);
        }
    }

    private boolean hasNonNullBody(Block body) {
        return body != null && body.getAllStatements() != null;
    }

    private boolean containsThisOrSuperUsage(Block body) {
        Functions.Function1 _function = stmt -> this.isThisOrSuperUsage((EObject)stmt) || IteratorExtensions.exists((Iterator)EcoreUtilN4.getAllContentsFiltered((EObject)stmt, it -> {
            boolean _isFnDefOrDecl = this.isFnDefOrDecl((EObject)it);
            return !_isFnDefOrDecl;
        }), it -> this.isThisOrSuperUsage((EObject)it));
        return IteratorExtensions.exists((Iterator)body.getAllStatements(), (Functions.Function1)_function);
    }

    private boolean isFnDefOrDecl(EObject ast) {
        return ast instanceof FunctionDeclaration || ast instanceof FunctionDefinition;
    }

    private boolean isThisOrSuperUsage(EObject expr) {
        return expr instanceof SuperLiteral || expr instanceof ThisLiteral;
    }
}

