/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec.adoc;

import java.io.File;
import org.eclipse.n4js.jsdoc2spec.SpecFile;
import org.eclipse.n4js.jsdoc2spec.adoc.FileSystem;
import org.eclipse.n4js.jsdoc2spec.adoc.IndexEntry;
import org.eclipse.n4js.jsdoc2spec.adoc.IndexEntryWriter;
import org.eclipse.n4js.jsdoc2spec.adoc.SpecListingFile;
import org.eclipse.n4js.jsdoc2spec.adoc.SpecModuleFile;

class PDFContentFileWriter
extends IndexEntryWriter {
    PDFContentFileWriter() {
    }

    @Override
    protected String getFileName() {
        return "book.adoc";
    }

    @Override
    protected SpecFile createSpecFile(File file, String content) {
        return new SpecListingFile(file, content);
    }

    @Override
    protected void appendEntry(IndexEntry ie) {
        if (this.lastIE == null) {
            PDFContentFileWriter.printHeading(this.strb, ie);
        }
        if (this.lastIE != null && this.lastIE.adocPath.equals(ie.adocPath)) {
            return;
        }
        if (ie.project.endsWith("tests")) {
            return;
        }
        boolean superDirChanged = false;
        if (superDirChanged || !this.isEqualSourceFolder(ie, this.lastIE)) {
            superDirChanged = true;
            this.strb.append("== Source Folder ");
            this.strb.append(ie.path);
            this.strb.append(":");
            this.strb.append(ie.project);
            this.strb.append(":");
            this.strb.append(ie.folder);
            this.strb.append(FileSystem.NL);
        }
        if (superDirChanged || !this.isEqualPackage(ie, this.lastIE)) {
            superDirChanged = true;
            this.strb.append("=== Package ");
            this.strb.append(ie.packageName);
            this.strb.append(FileSystem.NL);
        }
        this.appendElement(ie);
    }

    private boolean isEqualSourceFolder(IndexEntry ie1, IndexEntry ie2) {
        if (ie1 == null || ie2 == null) {
            return false;
        }
        boolean equalSourceFolder = true;
        equalSourceFolder &= ie1.path.equals(ie2.path);
        equalSourceFolder &= ie1.project.equals(ie2.project);
        return equalSourceFolder &= ie1.folder.equals(ie2.folder);
    }

    private boolean isEqualPackage(IndexEntry ie1, IndexEntry ie2) {
        if (ie1 == null || ie2 == null) {
            return false;
        }
        return ie1.packageName.equals(ie2.packageName);
    }

    private void appendElement(IndexEntry ie) {
        this.strb.append("==== Module ");
        this.strb.append(ie.moduleName);
        this.strb.append(FileSystem.NL);
        this.strb.append("include::");
        this.strb.append("modules" + File.separator + ie.adocPath);
        int headerLength = SpecModuleFile.getHeaderLength();
        this.strb.append("[leveloffset=3, lines=" + headerLength + "..-1]" + FileSystem.NL);
        this.strb.append(FileSystem.NL);
    }

    private static void printHeading(StringBuilder strb, IndexEntry ie) {
        strb.append("include::{find}config.adoc[]" + FileSystem.NL);
        strb.append(":docinfodir: ../headers/apiBook" + FileSystem.NL);
        strb.append(":linkattrs:" + FileSystem.NL);
        strb.append(":docinfo:" + FileSystem.NL);
        strb.append(":toc: left");
        strb.append(String.valueOf(FileSystem.NL) + FileSystem.NL);
        strb.append("= Content of Repository ");
        strb.append(ie.repository);
        strb.append(String.valueOf(FileSystem.NL) + FileSystem.NL);
    }
}

