/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditorMessages;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.texteditor.AnnotationPreferenceLookup;
import org.eclipse.ui.texteditor.AnnotationTypeLookup;
import org.eclipse.ui.texteditor.HyperlinkDetectorRegistry;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.spelling.SpellingService;

public final class EditorsUI {
    public static final String PLUGIN_ID = "org.eclipse.ui.editors";
    public static final String DEFAULT_TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    public static final int CHARSET_MAPPING_FAILED = 1;
    public static final int STATE_VALIDATION_FAILED = 4;
    public static final int DERIVED_FILE = 5;

    public static AnnotationTypeLookup getAnnotationTypeLookup() {
        return EditorsPlugin.getDefault().getAnnotationTypeLookup();
    }

    public static AnnotationPreferenceLookup getAnnotationPreferenceLookup() {
        return EditorsPlugin.getDefault().getAnnotationPreferenceLookup();
    }

    public static IPreferenceStore getPreferenceStore() {
        return EditorsPlugin.getDefault().getPreferenceStore();
    }

    public static void useAnnotationsPreferencePage(IPreferenceStore store) {
        MarkerAnnotationPreferences.useAnnotationsPreferencePage(store);
    }

    public static void useQuickDiffPreferencePage(IPreferenceStore store) {
        MarkerAnnotationPreferences.useQuickDiffPreferencePage(store);
        store.setToDefault("quickdiff.quickDiff");
        store.setToDefault("quickdiff.characterMode");
        store.setToDefault("quickdiff.defaultProvider");
    }

    private EditorsUI() {
    }

    @Deprecated
    public static Preferences getPluginPreferences() {
        return EditorsPlugin.getDefault().getPluginPreferences();
    }

    public static SpellingService getSpellingService() {
        return EditorsPlugin.getDefault().getSpellingService();
    }

    public static ISharedTextColors getSharedTextColors() {
        return EditorsPlugin.getDefault().getSharedTextColors();
    }

    public static HyperlinkDetectorRegistry getHyperlinkDetectorRegistry() {
        return EditorsPlugin.getDefault().getHyperlinkDetectorRegistry();
    }

    public static final String getTooltipAffordanceString() {
        if (!EditorsUI.getPreferenceStore().getBoolean("showTextHoverAffordance")) {
            return null;
        }
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService == null) {
            return null;
        }
        String keySequence = bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.edit.text.showInformation");
        if (keySequence == null) {
            return "";
        }
        return NLSUtility.format(TextEditorMessages.Editor_toolTip_affordance, keySequence);
    }
}

