/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.universal;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.internal.intro.universal.BaseData;
import org.eclipse.ui.internal.intro.universal.ExtensionData;
import org.eclipse.ui.internal.intro.universal.SeparatorData;
import org.eclipse.ui.intro.config.IntroElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GroupData {
    boolean fDefault = false;
    private String path;
    private ArrayList<BaseData> children = new ArrayList();

    public GroupData(String path, boolean defaultGroup) {
        this.fDefault = defaultGroup;
        this.path = path;
    }

    public GroupData(Element element) {
        this.path = element.getNodeName().equals("hidden") ? "hidden" : element.getAttribute("path");
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                if (child.getNodeName().equals("extension")) {
                    this.loadExtension((Element)child);
                } else if (child.getNodeName().equals("separator")) {
                    this.loadSeparator((Element)child);
                }
            }
            ++i;
        }
        String df = element.getAttribute("default");
        if (df != null && df.equalsIgnoreCase("true")) {
            this.fDefault = true;
        }
    }

    public boolean isHidden() {
        return this.path.equals("hidden");
    }

    public boolean isDefault() {
        return this.fDefault;
    }

    public void addAnchors(List<IntroElement> result) {
        int i = 0;
        while (i < this.children.size()) {
            BaseData edata = this.children.get(i);
            String id = edata.getId();
            IntroElement element = null;
            String tagName = "anchor";
            if (edata instanceof SeparatorData) {
                tagName = "hr";
            }
            element = new IntroElement(tagName);
            element.setAttribute("id", id);
            result.add(element);
            ++i;
        }
    }

    public void add(BaseData ed) {
        this.children.add(ed);
        ed.setParent(this);
    }

    public void add(int index, BaseData ed) {
        this.children.add(index, ed);
        ed.setParent(this);
    }

    public void remove(BaseData ed) {
        this.children.remove(ed);
        ed.setParent(null);
    }

    public void addImplicitExtension(String id, String name) {
        ExtensionData ed = new ExtensionData(id, name, "low", true);
        this.add(ed);
    }

    private void loadSeparator(Element element) {
        String id = element.getAttribute("id");
        SeparatorData sd = new SeparatorData(id);
        this.add(sd);
    }

    private void loadExtension(Element element) {
        String id = element.getAttribute("id");
        String name = element.getAttribute("name");
        String importance = element.getAttribute("importance");
        ExtensionData ed = new ExtensionData(id, name, importance, false);
        this.add(ed);
    }

    public BaseData[] getChildren() {
        return this.children.toArray(new BaseData[this.children.size()]);
    }

    public int getExtensionCount() {
        int count = 0;
        int i = 0;
        while (i < this.children.size()) {
            BaseData data = this.children.get(i);
            if (data instanceof ExtensionData) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public String getPath() {
        return this.path;
    }

    public boolean contains(String id) {
        return this.find(id) != null;
    }

    BaseData find(String extensionId) {
        int i = 0;
        while (i < this.children.size()) {
            BaseData data = this.children.get(i);
            if (data.getId().equals(extensionId)) {
                return data;
            }
            ++i;
        }
        return null;
    }

    public int getIndexOf(BaseData ed) {
        return this.children.indexOf(ed);
    }

    public int getIndexOf(String baseId) {
        int i = 0;
        while (i < this.children.size()) {
            BaseData bd = this.children.get(i);
            if (bd.getId().equals(baseId)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean canMoveUp(BaseData ed) {
        int index = this.children.indexOf(ed);
        return index > 0;
    }

    public boolean canMoveDown(BaseData ed) {
        int index = this.children.indexOf(ed);
        return index != -1 && index < this.children.size() - 1;
    }

    public void moveUp(BaseData ed) {
        int index = this.children.indexOf(ed);
        BaseData swapped = this.children.get(index - 1);
        this.children.set(index, swapped);
        this.children.set(index - 1, ed);
    }

    public void moveDown(BaseData ed) {
        int index = this.children.indexOf(ed);
        BaseData swapped = this.children.get(index + 1);
        this.children.set(index, swapped);
        this.children.set(index + 1, ed);
    }

    public void addSeparator(BaseData after) {
        int index;
        SeparatorData sd = new SeparatorData();
        sd.id = "" + sd.hashCode();
        if (after != null && (index = this.children.indexOf(after)) != -1) {
            this.children.add(index + 1, sd);
            return;
        }
        this.children.add(sd);
    }

    public void write(PrintWriter writer, String indent) {
        writer.print(indent);
        if (this.isHidden()) {
            writer.print("<hidden>");
        } else {
            writer.print("<group path=\"" + this.path + "\"");
            if (this.fDefault) {
                writer.println(" default=\"true\">");
            } else {
                writer.println(">");
            }
        }
        int i = 0;
        while (i < this.children.size()) {
            BaseData ed = this.children.get(i);
            ed.write(writer, String.valueOf(indent) + "   ");
            ++i;
        }
        writer.print(indent);
        if (this.isHidden()) {
            writer.println("</hidden>");
        } else {
            writer.println("</group>");
        }
    }
}

