/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.runner.extension;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.n4js.projectModel.names.N4JSProjectName;

public enum RuntimeEnvironment {
    ES5("n4js-es5"),
    V8("RE_V8"),
    NODEJS("n4js-node"),
    NODEJS_MANGELHAFT("n4js-node-mangelhaft"),
    CHROME("n4js-chrome"),
    IOJS("RE_IOJS");

    private final N4JSProjectName projectName;

    private RuntimeEnvironment(String projectName) {
        this.projectName = new N4JSProjectName(projectName);
        DataMap.data.put(this.projectName, this);
    }

    public N4JSProjectName getProjectName() {
        return this.projectName;
    }

    public static RuntimeEnvironment fromProjectName(N4JSProjectName representation) {
        return DataMap.data.get(representation);
    }

    private static class DataMap {
        static Map<N4JSProjectName, RuntimeEnvironment> data = new HashMap<N4JSProjectName, RuntimeEnvironment>();

        private DataMap() {
        }
    }
}

