/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.util;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.xtext.ui.editor.XtextEditor;

public class EditorsUtil {
    static Logger logger = Logger.getLogger(EditorsUtil.class);

    public static final Optional<IWorkbenchPage> getActivePage() {
        AtomicReference wrappedPage = new AtomicReference();
        Display.getDefault().syncExec(() -> wrappedPage.set(EditorsUtil.unsafeGetWorkbenchPage()));
        IWorkbenchPage page = (IWorkbenchPage)wrappedPage.get();
        if (page == null) {
            logger.warn((Object)"Cannot obtain IWorkbenchPage, will return empty Optional");
        }
        return Optional.ofNullable(page);
    }

    private static final IWorkbenchPage unsafeGetWorkbenchPage() {
        IWorkbenchPage page = null;
        if (PlatformUI.isWorkbenchRunning()) {
            IWorkbench wb = PlatformUI.getWorkbench();
            IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
            page = win.getActivePage();
        }
        return page;
    }

    public static final void forceCloseAllEditors() {
        Display.getDefault().syncExec(() -> {
            IWorkbenchPage page = EditorsUtil.unsafeGetWorkbenchPage();
            if (page != null) {
                boolean allClosed = page.closeAllEditors(false);
                logger.info((Object)("All closed: " + allClosed));
            } else {
                logger.info((Object)" Closing all editors: No active page.");
            }
        });
    }

    public static final void forceCloseEditor(IEditorPart editor) {
        Display.getDefault().syncExec(() -> {
            IWorkbenchPage page = EditorsUtil.unsafeGetWorkbenchPage();
            if (page != null) {
                boolean allClosed = page.closeEditor(editor, false);
                logger.info((Object)("Editor closed: " + allClosed));
            } else {
                logger.info((Object)" Closing all editors: No active page.");
            }
        });
    }

    public static final Optional<XtextEditor> openXtextEditor(URI uri, String editorExtensionID) {
        String platformStr = uri.toString().replace("platform:/resource/", "");
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformStr));
        Optional<IWorkbenchPage> page = EditorsUtil.getActivePage();
        Optional<IEditorPart> internalFileEditor = EditorsUtil.getFileEditor(file, page.get(), editorExtensionID);
        if (!page.isPresent() || !internalFileEditor.isPresent()) {
            logger.warn((Object)("Cannot obtain editor components for " + file.getRawLocationURI()));
            return Optional.empty();
        }
        IEditorPart ieditorPart = internalFileEditor.get();
        if (!(ieditorPart instanceof XtextEditor)) {
            logger.warn((Object)("cannot obtain Xtext editor for file " + file.getRawLocation()));
            return Optional.empty();
        }
        EditorsUtil.waitForEditorToBeActive(ieditorPart, page.get());
        return Optional.ofNullable((XtextEditor)ieditorPart);
    }

    private static final void waitForEditorToBeActive(IEditorPart internalFileEditor, IWorkbenchPage page) {
        long start;
        long end = start = System.currentTimeMillis();
        do {
            end = System.currentTimeMillis();
        } while (page.getActiveEditor() != internalFileEditor && end - start < 5000L);
        if (page.getActiveEditor() != internalFileEditor) {
            logger.warn((Object)"selected editor was not activated within timout");
        }
    }

    private static final Optional<IEditorPart> getFileEditor(IFile file, IWorkbenchPage page, String editorID) {
        AtomicReference wrappedEditor = new AtomicReference();
        Display.getDefault().syncExec(() -> {
            try {
                wrappedEditor.set(IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)editorID, (boolean)true));
            }
            catch (Exception e) {
                logger.error((Object)("exception when opening editor for " + file.getRawLocationURI()), (Throwable)e);
            }
        });
        IEditorPart internalFileEditor = (IEditorPart)wrappedEditor.get();
        if (internalFileEditor == null) {
            logger.warn((Object)("cannot obtain editor for a file " + file.getRawLocationURI()));
        }
        return Optional.ofNullable(internalFileEditor);
    }
}

