/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.sourcelookup;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.internal.debug.core.JavaDebugUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;

public class StackFrameShowInSourceAdapter
implements IShowInSource {
    private IJavaStackFrame fFrame;
    private ShowInContext fLazyContext = null;

    public StackFrameShowInSourceAdapter(IJavaStackFrame frame) {
        this.fFrame = frame;
    }

    public ShowInContext getShowInContext() {
        if (this.fLazyContext == null) {
            this.fLazyContext = new LazyShowInContext();
        }
        return this.fLazyContext;
    }

    class LazyShowInContext
    extends ShowInContext {
        boolean resolved;

        public LazyShowInContext() {
            super(null, null);
            this.resolved = false;
        }

        public ISelection getSelection() {
            if (!this.resolved) {
                try {
                    this.resolved = true;
                    IType type = JavaDebugUtils.resolveDeclaringType((IJavaStackFrame)StackFrameShowInSourceAdapter.this.fFrame);
                    if (type != null) {
                        this.setSelection((ISelection)new StructuredSelection((Object)type));
                    }
                }
                catch (CoreException coreException) {}
            }
            return super.getSelection();
        }
    }
}

