/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Environment implements Enumerator
{
    STANDALONE_TEST(0, "STANDALONE_TEST", "STANDALONE_TEST"),
    PLUGIN_TEST(1, "PLUGIN_TEST", "PLUGIN_TEST"),
    WORKBENCH(2, "WORKBENCH", "WORKBENCH");

    public static final int STANDALONE_TEST_VALUE = 0;
    public static final int PLUGIN_TEST_VALUE = 1;
    public static final int WORKBENCH_VALUE = 2;
    private static final Environment[] VALUES_ARRAY;
    public static final List<Environment> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Environment[]{STANDALONE_TEST, PLUGIN_TEST, WORKBENCH};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Environment get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Environment result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Environment getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Environment result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Environment get(int value) {
        switch (value) {
            case 0: {
                return STANDALONE_TEST;
            }
            case 1: {
                return PLUGIN_TEST;
            }
            case 2: {
                return WORKBENCH;
            }
        }
        return null;
    }

    private Environment(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

