/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.organize.imports;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.ImportSpecifier;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.organize.imports.ImportProvidedElement;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class RecordingImportState {
    public List<Pair<ImportDeclaration, List<ImportDeclaration>>> duplicatedImportDeclarations = CollectionLiterals.newArrayList();
    public List<ImportSpecifier> unusedImports = CollectionLiterals.newArrayList();
    public List<ImportSpecifier> brokenImports = CollectionLiterals.newArrayList();
    public List<Pair<Pair<String, TModule>, List<ImportProvidedElement>>> duplicateImportsOfSameElement = CollectionLiterals.newArrayList();
    public List<Pair<String, List<ImportProvidedElement>>> localNameCollision = CollectionLiterals.newArrayList();
    public List<ImportProvidedElement> allUsedTypeNameToSpecifierTuples = CollectionLiterals.newArrayList();

    public boolean registerDuplicatesOfImportDeclaration(ImportDeclaration declaration, List<ImportDeclaration> duplicates) {
        Pair _mappedTo = Pair.of((Object)declaration, duplicates);
        return this.duplicatedImportDeclarations.add((Pair<ImportDeclaration, List<ImportDeclaration>>)_mappedTo);
    }

    public boolean isDuplicatingImportDeclaration(ImportDeclaration importDeclaration) {
        Functions.Function1 _function = dupePair -> ((ImportDeclaration)dupePair.getKey()).getModule() == importDeclaration.getModule() && ((List)dupePair.getValue()).contains(importDeclaration);
        return IterableExtensions.exists(this.duplicatedImportDeclarations, (Functions.Function1)_function);
    }

    public boolean registerUnusedImport(ImportSpecifier specifier) {
        return this.unusedImports.add(specifier);
    }

    public boolean registerBrokenImport(ImportSpecifier specifier) {
        return this.brokenImports.add(specifier);
    }

    public List<ImportProvidedElement> cleanup() {
        List<ImportProvidedElement> _xblockexpression = null;
        Consumer<List> _function = it -> it.clear();
        Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new List[]{this.unusedImports, this.brokenImports, this.allUsedTypeNameToSpecifierTuples})).forEach(_function);
        this.localNameCollision.clear();
        this.duplicatedImportDeclarations.clear();
        this.duplicateImportsOfSameElement.clear();
        this.allUsedTypeNameToSpecifierTuples = null;
        _xblockexpression = null;
        return _xblockexpression;
    }

    public List<ImportProvidedElement> registerAllUsedTypeNameToSpecifierTuples(List<ImportProvidedElement> pairs) {
        this.allUsedTypeNameToSpecifierTuples = pairs;
        return this.allUsedTypeNameToSpecifierTuples;
    }

    public void removeDuplicatedImportsOfSameelement(List<ImportDeclaration> declarations, Adapter nodelessMarker) {
        Consumer<Pair> _function = e -> {
            Consumer<ImportProvidedElement> _function_1 = e2 -> this.removeFrom(CollectionLiterals.newArrayList((Object[])new ImportSpecifier[]{e2.getImportSpecifier()}), declarations, nodelessMarker);
            ((List)e.getValue()).forEach(_function_1);
        };
        this.duplicateImportsOfSameElement.forEach(_function);
    }

    public void removeLocalNameCollisions(List<ImportDeclaration> declarations, Adapter nodelessMarker) {
        Consumer<Pair> _function = e -> {
            Consumer<ImportProvidedElement> _function_1 = e2 -> this.removeFrom(CollectionLiterals.newArrayList((Object[])new ImportSpecifier[]{e2.getImportSpecifier()}), declarations, nodelessMarker);
            ((List)e.getValue()).forEach(_function_1);
        };
        this.localNameCollision.forEach(_function);
    }

    public void removeDuplicatedImportDeclarations(List<ImportDeclaration> declarations) {
        Consumer<Pair> _function = decl2dupes -> declarations.removeAll((Collection)decl2dupes.getValue());
        this.duplicatedImportDeclarations.forEach(_function);
    }

    public void removeUnusedImports(List<ImportDeclaration> declarations, Adapter nodelessMarker) {
        this.removeFrom(this.unusedImports, declarations, nodelessMarker);
    }

    public void removeBrokenImports(List<ImportDeclaration> declarations, Adapter nodelessMarker) {
        this.removeFrom(this.brokenImports, declarations, nodelessMarker);
    }

    private void removeFrom(List<ImportSpecifier> tobeRemoved, List<ImportDeclaration> declarations, Adapter nodelessMarker) {
        Consumer<ImportSpecifier> _function = it -> {
            boolean _matched = false;
            if (it instanceof NamespaceImportSpecifier) {
                _matched = true;
                declarations.remove(((NamespaceImportSpecifier)it).eContainer());
            }
            if (!_matched && it instanceof NamedImportSpecifier) {
                _matched = true;
                EObject _eContainer = ((NamedImportSpecifier)it).eContainer();
                ImportDeclaration imp = (ImportDeclaration)_eContainer;
                if (imp != null) {
                    boolean _tripleNotEquals;
                    EList _importSpecifiers = imp.getImportSpecifiers();
                    boolean bl = _tripleNotEquals = _importSpecifiers != null;
                    if (_tripleNotEquals) {
                        imp.getImportSpecifiers().remove(it);
                        imp.eAdapters().add((Object)nodelessMarker);
                    }
                    if (imp.getImportSpecifiers() == null || imp.getImportSpecifiers().isEmpty()) {
                        declarations.remove(imp);
                    }
                }
            }
        };
        tobeRemoved.forEach(_function);
    }

    public Set<String> calcRemovedImportedNames() {
        HashSet ret = CollectionLiterals.newHashSet();
        for (ImportProvidedElement e : this.allUsedTypeNameToSpecifierTuples) {
            if (!e.isUsed() || e.getImportSpecifier().eContainer() != null) continue;
            ret.add(e.getLocalName());
        }
        return ret;
    }

    public boolean registerDuplicateImportsOfSameElement(String name, TModule module, List<ImportProvidedElement> elements) {
        Pair _mappedTo = Pair.of((Object)name, (Object)module);
        Pair _mappedTo_1 = Pair.of((Object)_mappedTo, elements);
        return this.duplicateImportsOfSameElement.add((Pair<Pair<String, TModule>, List<ImportProvidedElement>>)_mappedTo_1);
    }

    public boolean registerLocalNameCollision(String string, List<ImportProvidedElement> elements) {
        boolean _xblockexpression = false;
        Functions.Function1 _function = it -> {
            String _key = (String)it.getKey();
            return Objects.equal((Object)_key, (Object)string);
        };
        Pair key = (Pair)IterableExtensions.findFirst(this.localNameCollision, (Functions.Function1)_function);
        boolean _xifexpression = false;
        if (key != null) {
            _xifexpression = ((List)key.getValue()).addAll(elements);
        } else {
            List _list = IterableExtensions.toList(elements);
            Pair _mappedTo = Pair.of((Object)string, (Object)_list);
            _xifexpression = this.localNameCollision.add((Pair<String, List<ImportProvidedElement>>)_mappedTo);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }
}

