/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.util;

import com.google.inject.Injector;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.xpect.XjmTest;
import org.eclipse.xpect.XpectJavaModel;
import org.eclipse.xpect.XpectJavaModelFactory;
import org.eclipse.xpect.registry.ILanguageInfo;
import org.eclipse.xpect.util.ResourceSetsByClassloaderContext;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.access.impl.ClasspathTypeProvider;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.resource.XtextResourceSet;

public class XpectJavaModelManager {
    public static XpectJavaModel createJavaModel(Class<?> clazz) {
        XtextResourceSet rs = new XtextResourceSet();
        ClassLoader classLoader = clazz.getClassLoader();
        rs.setClasspathURIContext((Object)classLoader);
        new ClasspathTypeProvider(classLoader, (ResourceSet)rs, null);
        JvmTypeReference typeReference = XpectJavaModelManager.getTypeReferences().getTypeForName(clazz, (Notifier)rs, new JvmTypeReference[0]);
        return XpectJavaModelManager.createJavaModel((ResourceSet)rs, (JvmDeclaredType)typeReference.getType());
    }

    private static XpectJavaModel createJavaModel(JvmDeclaredType type) {
        XpectJavaModelFactory fact = XpectJavaModelFactory.eINSTANCE;
        XpectJavaModel result = fact.createXpectJavaModel();
        XjmTest test = fact.createXjmTest();
        test.setJvmClass(type);
        result.setTestOrSuite(test);
        return result;
    }

    private static XpectJavaModel createJavaModel(ResourceSet resourceSet, JvmDeclaredType type) {
        XpectJavaModel javaModel = XpectJavaModelManager.createJavaModel(type);
        ResourceImpl res = new ResourceImpl(XpectJavaModelManager.createURI(type.getQualifiedName()));
        res.getContents().add((Object)javaModel);
        resourceSet.getResources().add((Object)res);
        return javaModel;
    }

    private static URI createURI(String qualifiedName) {
        return URI.createURI((String)("xpectjavamodel:/" + qualifiedName));
    }

    private static XpectJavaModel find(ResourceSet rs, String qualifiedName) {
        Resource resource = rs.getResource(XpectJavaModelManager.createURI(qualifiedName), false);
        if (resource != null) {
            for (EObject o : resource.getContents()) {
                if (!(o instanceof XpectJavaModel)) continue;
                return (XpectJavaModel)o;
            }
        }
        return null;
    }

    public static XpectJavaModel getOrCreate(JvmDeclaredType type) {
        ResourceSet resourceSet = type.eResource().getResourceSet();
        XpectJavaModel result = XpectJavaModelManager.find(resourceSet, type.getQualifiedName());
        if (result != null) {
            return result;
        }
        return XpectJavaModelManager.createJavaModel(resourceSet, type);
    }

    public static XpectJavaModel getOrCreate(ResourceSet rs, Class<?> clazz) {
        XtextResourceSet xtextResourceSet = ResourceSetsByClassloaderContext.get(rs, clazz.getClassLoader());
        XpectJavaModel result = XpectJavaModelManager.find((ResourceSet)xtextResourceSet, clazz.getName());
        if (result != null) {
            return result;
        }
        JvmTypeReference type = XpectJavaModelManager.getTypeReferences().getTypeForName(clazz, (Notifier)xtextResourceSet, new JvmTypeReference[0]);
        result = XpectJavaModelManager.createJavaModel((ResourceSet)xtextResourceSet, (JvmDeclaredType)type.getType());
        return result;
    }

    private static TypeReferences getTypeReferences() {
        Injector injector = ILanguageInfo.Registry.INSTANCE.getLanguageByFileExtension("xpect").getInjector();
        return (TypeReferences)injector.getInstance(TypeReferences.class);
    }
}

