/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.project;

import com.google.inject.Inject;
import java.util.Collections;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.n4js.N4JSGlobals;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.ui.ImageDescriptorCache;
import org.eclipse.n4js.ui.internal.N4JSActivator;
import org.eclipse.n4js.ui.wizard.project.N4JSNewProjectWizardCreationPage;
import org.eclipse.n4js.ui.wizard.project.N4JSProjectCreator;
import org.eclipse.n4js.ui.wizard.project.N4JSProjectInfo;
import org.eclipse.n4js.ui.wizard.project.N4JSTestedProjectWizardPage;
import org.eclipse.n4js.ui.wizard.utils.WizardHelper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.ui.wizard.IProjectCreator;
import org.eclipse.xtext.ui.wizard.IProjectInfo;
import org.eclipse.xtext.ui.wizard.XtextNewProjectWizard;

public class N4JSNewProjectWizard
extends XtextNewProjectWizard {
    private static final ImageDescriptor NEW_PROJECT_WIZBAN_DESC = (ImageDescriptor)ImageDescriptorCache.ImageRef.NEW_PROJECT_WIZBAN.asImageDescriptor().orNull();
    private static final String DIALOG_SETTINGS_SECTION_KEY = "org.eclipse.n4js.ui.wizard.project.N4JSNewProjectWizard.dialogSettings";
    private static final String CREATE_GREETER_SETTINGS_KEY = "createGreeterFile";
    private static final String VENDOR_ID_SETTINGS_KEY = "vendorId";
    private final N4JSProjectInfo projectInfo;
    @Inject
    private IResourceDescriptions resourceDescriptions;
    @Inject
    private WizardHelper wizardHelper;
    private N4JSNewProjectWizardCreationPage newProjectWizardCreationPage;

    @Inject
    public N4JSNewProjectWizard(IProjectCreator projectCreator) {
        super(projectCreator);
        this.setWindowTitle("New N4JS Project");
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(NEW_PROJECT_WIZBAN_DESC);
        this.projectInfo = new N4JSProjectInfo();
        IDialogSettings workbenchDialogSettings = N4JSActivator.getInstance().getDialogSettings();
        IDialogSettings projectWizardSettings = workbenchDialogSettings.getSection(DIALOG_SETTINGS_SECTION_KEY);
        if (projectWizardSettings == null) {
            projectWizardSettings = workbenchDialogSettings.addNewSection(DIALOG_SETTINGS_SECTION_KEY);
        }
        this.setDialogSettings(projectWizardSettings);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings.get(CREATE_GREETER_SETTINGS_KEY) != null) {
            this.projectInfo.setCreateGreeterFile(dialogSettings.getBoolean(CREATE_GREETER_SETTINGS_KEY));
        }
        if (dialogSettings.get(VENDOR_ID_SETTINGS_KEY) != null) {
            this.projectInfo.setVendorId(dialogSettings.get(VENDOR_ID_SETTINGS_KEY));
        }
    }

    public void addPages() {
        this.newProjectWizardCreationPage = new N4JSNewProjectWizardCreationPage(this.projectInfo);
        this.addPage((IWizardPage)this.newProjectWizardCreationPage);
        this.addPage((IWizardPage)new N4JSTestedProjectWizardPage(this.projectInfo, this.resourceDescriptions));
    }

    public boolean performFinish() {
        this.getDialogSettings().put(CREATE_GREETER_SETTINGS_KEY, this.projectInfo.getCreateGreeterFile());
        this.getDialogSettings().put(VENDOR_ID_SETTINGS_KEY, this.projectInfo.getVendorId());
        if (super.performFinish()) {
            IProject project;
            boolean requiresNpmInstall = N4JSGlobals.PROJECT_TYPES_REQUIRING_N4JS_RUNTIME.contains(this.projectInfo.getProjectType());
            if (requiresNpmInstall && (project = ((N4JSProjectCreator)this.getCreator()).getCreatedProject()) != null) {
                this.wizardHelper.runNpmInstallInWizard(this.getContainer(), Collections.singletonList(project));
            }
            return true;
        }
        return false;
    }

    public boolean canFinish() {
        return !ProjectType.TEST.equals((Object)this.projectInfo.getProjectType()) && this.newProjectWizardCreationPage.isPageComplete() || super.canFinish();
    }

    protected IProjectInfo getProjectInfo() {
        this.newProjectWizardCreationPage.updateSelectedWorkingSets();
        return this.projectInfo;
    }
}

