/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.building;

import java.util.Collections;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.ui.building.N4ClusteringBuilderState;
import org.eclipse.n4js.ui.building.N4JSGenerateImmediatelyBuilderState;
import org.eclipse.n4js.utils.resources.IBuildSuppressingResourceDescriptionManager;
import org.eclipse.xtext.builder.clustering.CopiedResourceDescription;
import org.eclipse.xtext.builder.clustering.CurrentDescriptions;
import org.eclipse.xtext.builder.debug.IBuildLogger;
import org.eclipse.xtext.builder.impl.BuildData;
import org.eclipse.xtext.builder.resourceloader.IResourceLoader;
import org.eclipse.xtext.resource.CompilerPhases;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.clustering.IResourceClusteringPolicy;
import org.eclipse.xtext.resource.impl.DefaultResourceDescriptionDelta;

class WriteNewResourceDescriptionsImplementation {
    private static final Logger LOGGER = Logger.getLogger(N4JSGenerateImmediatelyBuilderState.class);
    private final CompilerPhases compilerPhases;
    private final IResourceClusteringPolicy clusteringPolicy;
    private final IResourceLoader globalIndexResourceLoader;
    private final BuildData buildData;
    private final IResourceDescriptions oldState;
    private final CurrentDescriptions newState;
    private final N4ClusteringBuilderState state;
    private final SubMonitor progress;
    private final ResourceSet resourceSet;
    private final IProject currentProject;
    private final IBuildLogger buildLogger;
    private IResourceLoader.LoadOperation loadOperation;

    public WriteNewResourceDescriptionsImplementation(N4ClusteringBuilderState state, BuildData buildData, IResourceDescriptions oldState, CurrentDescriptions newState, IProgressMonitor monitor, IBuildLogger buildLogger, IResourceLoader globalIndexResourceLoader, IResourceClusteringPolicy clusteringPolicy, CompilerPhases compilerPhases) {
        this.compilerPhases = compilerPhases;
        this.clusteringPolicy = clusteringPolicy;
        this.globalIndexResourceLoader = globalIndexResourceLoader;
        this.state = state;
        this.buildData = buildData;
        this.oldState = oldState;
        this.newState = newState;
        this.progress = SubMonitor.convert((IProgressMonitor)monitor, (int)buildData.getToBeUpdated().size());
        this.buildLogger = buildLogger;
        this.resourceSet = buildData.getResourceSet();
        this.currentProject = state.getBuiltProject(buildData);
    }

    public void writeNewResourceDescriptions() {
        try {
            this.compilerPhases.setIndexing((Notifier)this.resourceSet, true);
            this.doWriteResourceDescriptions();
        }
        finally {
            this.compilerPhases.setIndexing((Notifier)this.resourceSet, false);
            if (this.loadOperation != null) {
                this.loadOperation.cancel();
            }
        }
    }

    private void doWriteResourceDescriptions() {
        int counter = 0;
        Set toBeUpdated = this.buildData.getToBeUpdated();
        this.createLoadOperation(toBeUpdated);
        while (this.loadOperation.hasNext()) {
            this.checkCancelled();
            if (!this.continueProcessing(counter)) {
                this.state.clearResourceSet(this.resourceSet);
                counter = 0;
            }
            IResourceLoader.LoadResult nextOp = this.loadOperation.next();
            this.indexNextResource(nextOp);
            ++counter;
        }
    }

    private void indexNextResource(IResourceLoader.LoadResult loadResult) {
        URI uri = null;
        Resource resource = null;
        try {
            try {
                uri = loadResult.getUri();
                this.progress.subTask("Indexing " + uri.lastSegment());
                this.buildLogger.log((Object)("Indexing " + uri));
                resource = this.state.addResource(loadResult.getResource(), this.resourceSet);
                this.registerDelta(uri, resource);
            }
            catch (RuntimeException ex) {
                if (ex instanceof IResourceLoader.LoadOperationException) {
                    uri = ((IResourceLoader.LoadOperationException)ex).getUri();
                }
                if (uri == null) {
                    LOGGER.error((Object)"Error loading resource", (Throwable)ex);
                } else {
                    IResourceDescription oldDescription;
                    if (this.resourceSet.getURIConverter().exists(uri, Collections.emptyMap())) {
                        LOGGER.error((Object)("Error loading resource from: " + uri.toString()), (Throwable)ex);
                    }
                    if (resource != null) {
                        this.resourceSet.getResources().remove(resource);
                    }
                    if ((oldDescription = this.oldState.getResourceDescription(uri)) != null) {
                        this.newState.register((IResourceDescription.Delta)new DefaultResourceDescriptionDelta(oldDescription, null));
                    }
                }
                this.progress.worked(1);
            }
        }
        finally {
            this.progress.worked(1);
        }
    }

    private void registerDelta(URI uri, Resource resource) {
        IResourceDescription.Manager manager = this.state.getResourceDescriptionManager(resource, uri);
        if (manager != null) {
            if (manager instanceof IBuildSuppressingResourceDescriptionManager && !((IBuildSuppressingResourceDescriptionManager)manager).isToBeBuilt(uri, resource)) {
                return;
            }
            IResourceDescription description = manager.getResourceDescription(resource);
            CopiedResourceDescription copiedDescription = new CopiedResourceDescription(description);
            this.newState.register(manager.createDelta(this.oldState.getResourceDescription(uri), (IResourceDescription)copiedDescription));
            this.buildData.queueURI(uri);
        }
    }

    private void createLoadOperation(Set<URI> toBeUpdated) {
        this.loadOperation = this.globalIndexResourceLoader.create(this.resourceSet, this.currentProject);
        this.loadOperation.load(toBeUpdated);
    }

    private boolean continueProcessing(int clusterIndex) {
        return this.clusteringPolicy.continueProcessing(this.resourceSet, null, clusterIndex);
    }

    private void checkCancelled() {
        if (this.progress.isCanceled()) {
            if (this.loadOperation != null) {
                this.loadOperation.cancel();
            }
            throw new OperationCanceledException();
        }
    }
}

