/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.preferences;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.n4js.utils.ComponentDescriptor;
import org.eclipse.n4js.utils.IComponentProperties;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreInitializer;
import org.eclipse.xtext.ui.editor.preferences.PreferenceStoreAccessImpl;

public abstract class AbstractN4JSPreferenceStoreAccessor<T extends ComponentDescriptor> {
    private final PreferenceStoreAccessImpl scopedAccessor;
    @Inject
    @Named(value="builderPreferenceInitializer")
    private IPreferenceStoreInitializer preferenceInitializer;

    public AbstractN4JSPreferenceStoreAccessor(PreferenceStoreAccessImpl scopedAccessor) {
        this.scopedAccessor = scopedAccessor;
    }

    protected abstract IComponentProperties<T>[] getComponentPropertiesValues();

    public void populateCompilerConfiguration(String outputName, T compilerDescriptor) {
        this.preferenceInitializer.initialize((IPreferenceStoreAccess)this.scopedAccessor);
        boolean initialLoad = false;
        Object currentlyStoredCompilerDescriptor = compilerDescriptor.getCurrentlyStoredComponentDescriptor();
        if (currentlyStoredCompilerDescriptor == null) {
            currentlyStoredCompilerDescriptor = compilerDescriptor;
            initialLoad = true;
        }
        Map originalSettings = currentlyStoredCompilerDescriptor.fillMap(outputName);
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        ComponentDescriptor newCompilerDescriptor = compilerDescriptor.copy();
        IComponentProperties<T>[] iComponentPropertiesArray = this.getComponentPropertiesValues();
        int n = iComponentPropertiesArray.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentProperties<T> prop = iComponentPropertiesArray[n2];
            if (prop.getType() == Boolean.class) {
                prop.setValueInCompilerDescriptor(newCompilerDescriptor, outputName, (Object)preferenceStore.getBoolean(prop.getKey(outputName)));
            } else {
                prop.setValueInCompilerDescriptor(newCompilerDescriptor, outputName, (Object)preferenceStore.getString(prop.getKey(outputName)));
            }
            ++n2;
        }
        Map currentSettings = newCompilerDescriptor.fillMap(outputName);
        Map<String, MapDifference.ValueDifference<String>> changes = this.getPreferenceChanges(originalSettings, currentSettings);
        if (!initialLoad) {
            compilerDescriptor.setChanges(changes);
        }
        compilerDescriptor.setCurrentlyStoredComponentDescriptor(newCompilerDescriptor);
    }

    private Map<String, MapDifference.ValueDifference<String>> getPreferenceChanges(Map<String, String> originalSettings, Map<String, String> currentSettings) {
        MapDifference mapDifference = Maps.difference(currentSettings, originalSettings);
        Map entriesDiffering = mapDifference.entriesDiffering();
        return entriesDiffering;
    }

    private IPreferenceStore getPreferenceStore() {
        return this.scopedAccessor.getWritablePreferenceStore();
    }
}

