/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.utils;

import com.google.inject.Inject;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.n4js.ui.utils.IssueUtilN4;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.FQNPrefixMatcher;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.IContentProposalProvider;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ImportUtil {
    @Inject
    private ContentAssistContext.Factory contentAssistContextFactory;
    @Inject
    private IContentProposalProvider contentProposalProvider;
    @Inject
    @Extension
    private IssueUtilN4 _issueUtilN4;

    public List<ICompletionProposal> findImportCandidates(Issue issue, boolean allowCompletion) {
        ISourceViewer _viewer = this._issueUtilN4.getViewer(issue);
        IXtextDocument _document = this._issueUtilN4.getDocument(issue);
        Integer _offset = issue.getOffset();
        Integer _length = issue.getLength();
        int _plus = _offset + _length;
        return this.findImportCandidates(_viewer, _document, _plus, allowCompletion);
    }

    public List<ICompletionProposal> findImportCandidates(ISourceViewer viewer, IXtextDocument doc, int offset, boolean allowCompletion) {
        IUnitOfWork _function = resource -> {
            ContentAssistContext[] contentAssistContexts;
            List _xblockexpression = null;
            CollectingAcceptor collector = new CollectingAcceptor();
            ContentAssistContext[] contentAssistContextArray = contentAssistContexts = this.createContentAssistContexts(viewer, offset, (XtextResource)resource, allowCompletion);
            int n2 = contentAssistContexts.length;
            int n3 = 0;
            while (n3 < n2) {
                ContentAssistContext contentAssistContext = contentAssistContextArray[n3];
                this.contentProposalProvider.createProposals(contentAssistContext, (ICompletionProposalAcceptor)collector);
                ++n3;
            }
            _xblockexpression = IterableExtensions.toList(collector.get());
            return _xblockexpression;
        };
        return (List)doc.readOnly(_function);
    }

    private ContentAssistContext[] createContentAssistContexts(ISourceViewer viewer, int offset, XtextResource resource, boolean allowCompletion) {
        try {
            ContentAssistContext[] result = this.contentAssistContextFactory.create((ITextViewer)viewer, offset, resource);
            if (allowCompletion) {
                return result;
            }
            Functions.Function1 _function = it -> this.disallowCompletion((ContentAssistContext)it);
            return (ContentAssistContext[])Conversions.unwrapArray((Object)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)result)), (Functions.Function1)_function), ContentAssistContext.class);
        }
        catch (Throwable _t) {
            if (_t instanceof BadLocationException) {
                BadLocationException e = (BadLocationException)_t;
                throw new RuntimeException((Throwable)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private ContentAssistContext disallowCompletion(ContentAssistContext context) {
        ContentAssistContext.Builder _copy = context.copy();
        PrefixMatcher _matcher = context.getMatcher();
        ExactMatcher _exactMatcher = new ExactMatcher(_matcher);
        return _copy.setMatcher((PrefixMatcher)_exactMatcher).toContext();
    }

    private static class CollectingAcceptor
    implements ICompletionProposalAcceptor {
        private final LinkedHashSet<ICompletionProposal> proposals = CollectionLiterals.newLinkedHashSet();

        private CollectingAcceptor() {
        }

        public LinkedHashSet<ICompletionProposal> get() {
            return this.proposals;
        }

        public void accept(ICompletionProposal proposal) {
            this.proposals.add(proposal);
        }

        public boolean canAcceptMoreProposals() {
            return true;
        }
    }

    private static class ExactMatcher
    extends PrefixMatcher {
        private final PrefixMatcher delegate;

        public ExactMatcher(PrefixMatcher delegate) {
            this.delegate = delegate;
        }

        public boolean isCandidateMatchingPrefix(String name, String prefix) {
            int _length_1;
            int _length;
            boolean _not;
            boolean _isCandidateMatchingPrefix = this.delegate.isCandidateMatchingPrefix(name, prefix);
            boolean bl = _not = !_isCandidateMatchingPrefix;
            if (_not) {
                return false;
            }
            String lastSegment = name;
            if (this.delegate instanceof FQNPrefixMatcher) {
                boolean _greaterEqualsThan;
                FQNPrefixMatcher.LastSegmentFinder lsf = ((FQNPrefixMatcher)this.delegate).getLastSegmentFinder();
                char delimiter = ((FQNPrefixMatcher)this.delegate).getDelimiter();
                int _indexOf = lastSegment.indexOf(delimiter);
                boolean bl2 = _greaterEqualsThan = _indexOf >= 0;
                if (_greaterEqualsThan && (lastSegment = lsf.getLastSegment(name, delimiter)) == null) {
                    return false;
                }
            }
            return (_length = lastSegment.length()) == (_length_1 = prefix.length());
        }
    }
}

