/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.model;

import java.util.List;
import java.util.StringJoiner;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.naming.QualifiedName;

public class ClassifierReference {
    public String classifierModuleSpecifier;
    public String classifierName;
    public URI uri;

    public ClassifierReference(String classifierModuleSpecifier, String classifierName) {
        this.classifierModuleSpecifier = classifierModuleSpecifier;
        this.classifierName = classifierName;
        this.uri = null;
    }

    public ClassifierReference(QualifiedName qualifiedName, URI uri) {
        this.classifierName = qualifiedName.getLastSegment();
        List frontSegments = qualifiedName.getSegments();
        if (frontSegments.size() > 0) {
            StringJoiner joiner = new StringJoiner("/");
            for (String segment : frontSegments.subList(0, frontSegments.size() - 1)) {
                joiner.add(segment);
            }
            this.classifierModuleSpecifier = joiner.toString();
        } else {
            this.classifierModuleSpecifier = "";
        }
        this.uri = uri;
    }

    public String getFullSpecifier() {
        if (!this.classifierName.isEmpty()) {
            return String.valueOf(this.classifierModuleSpecifier.isEmpty() ? "" : String.valueOf(this.classifierModuleSpecifier) + "/") + this.classifierName;
        }
        return "";
    }

    public boolean isComplete() {
        return !this.classifierName.isEmpty() && !this.classifierModuleSpecifier.isEmpty() && this.uri != null;
    }
}

