/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.analysers;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.flowgraphs.FGUtils;
import org.eclipse.n4js.flowgraphs.analysis.GraphVisitor;
import org.eclipse.n4js.flowgraphs.analysis.TraverseDirection;
import org.eclipse.n4js.flowgraphs.factories.CFEMapper;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.ExpressionStatement;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.TextRegion;

public class DeadCodeAnalyser
extends GraphVisitor {
    Set<ControlFlowElement> allLiveNodes = new HashSet<ControlFlowElement>();
    Set<ControlFlowElement> allDeadNodes = new HashSet<ControlFlowElement>();

    public DeadCodeAnalyser() {
        super(TraverseDirection.Forward);
    }

    @Override
    protected void visit(ControlFlowElement cfe) {
        if (this.isLiveCode()) {
            this.allLiveNodes.add(cfe);
        }
        if (this.isDeadCodeNode()) {
            this.allDeadNodes.add(cfe);
        }
    }

    public Set<ControlFlowElement> getReachableCFEs() {
        return this.allLiveNodes;
    }

    public Set<ControlFlowElement> getUnreachableCFEs() {
        return this.allDeadNodes;
    }

    public boolean isDeadCode(ControlFlowElement cfe) {
        if (FGUtils.isControlStatement(cfe = CFEMapper.map(cfe))) {
            Set<ControlFlowElement> succs = this.flowAnalyzer.getSuccessors(cfe);
            for (ControlFlowElement succ : succs) {
                if (this.isDeadCode(succ)) continue;
                return false;
            }
            return true;
        }
        if (this.allLiveNodes.contains(cfe)) {
            return false;
        }
        Set<ControlFlowElement> preds = this.flowAnalyzer.getPredecessorsSkipInternal(cfe);
        if (preds.isEmpty()) {
            return true;
        }
        HashSet<ControlFlowElement> visited = new HashSet<ControlFlowElement>();
        while (!preds.isEmpty()) {
            ControlFlowElement pred = preds.iterator().next();
            preds.remove(pred);
            if (visited.contains(pred)) continue;
            if (this.allLiveNodes.contains(pred)) {
                return false;
            }
            preds.addAll(this.flowAnalyzer.getPredecessorsSkipInternal(pred));
            visited.add(pred);
        }
        return true;
    }

    public Set<DeadCodeRegion> getDeadCodeRegions() {
        Collection<Set<ControlFlowElement>> deadCodeGroups = this.separateOnTheirBlocks(this.getUnreachableCFEs());
        HashSet<DeadCodeRegion> deadCodeRegions = new HashSet<DeadCodeRegion>();
        for (Set<ControlFlowElement> deadCodeGroup : deadCodeGroups) {
            DeadCodeRegion textRegion = this.getDeadCodeRegion(deadCodeGroup);
            deadCodeRegions.add(textRegion);
        }
        return deadCodeRegions;
    }

    private Collection<Set<ControlFlowElement>> separateOnTheirBlocks(Set<ControlFlowElement> unreachableElems) {
        HashMap unreachablesMap = new HashMap();
        for (ControlFlowElement unreachableElem : unreachableElems) {
            HashSet<ControlFlowElement> moreUnreachableElems;
            EObject cfeBlock = this.getReachableContainer(unreachableElems, unreachableElem, moreUnreachableElems = new HashSet<ControlFlowElement>());
            if (cfeBlock == null) continue;
            if (!unreachablesMap.containsKey(cfeBlock)) {
                unreachablesMap.put(cfeBlock, new HashSet());
            }
            Set unreachableInBlock = (Set)unreachablesMap.get(cfeBlock);
            unreachableInBlock.add(unreachableElem);
            unreachableInBlock.addAll(moreUnreachableElems);
        }
        return unreachablesMap.values();
    }

    private EObject getReachableContainer(Set<ControlFlowElement> unreachableElems, ControlFlowElement unreachableElem, Set<ControlFlowElement> moreUnreachableElems) {
        EObject blockContainer;
        boolean isDeadContainer;
        EObject block;
        EObject elemContainer = unreachableElem.eContainer();
        if (elemContainer instanceof ExpressionStatement) {
            moreUnreachableElems.add((ControlFlowElement)((ExpressionStatement)elemContainer));
        }
        if ((block = EcoreUtil2.getContainerOfType((EObject)unreachableElem, Block.class)) == null) {
            block = EcoreUtil2.getContainerOfType((EObject)unreachableElem, Script.class);
        }
        if (isDeadContainer &= (isDeadContainer &= (isDeadContainer = (blockContainer = block.eContainer()) instanceof ControlFlowElement) && FGUtils.isControlStatement((ControlFlowElement)blockContainer)) && this.isDeadCode((ControlFlowElement)blockContainer)) {
            ControlFlowElement cfe = (ControlFlowElement)blockContainer;
            moreUnreachableElems.add(cfe);
            return this.getReachableContainer(unreachableElems, cfe, moreUnreachableElems);
        }
        return block;
    }

    private DeadCodeRegion getDeadCodeRegion(Set<ControlFlowElement> deadCodeGroup) {
        int startIdx = Integer.MAX_VALUE;
        int endIdx = 0;
        int firstElementOffset = Integer.MAX_VALUE;
        ControlFlowElement firstElement = null;
        for (ControlFlowElement deadCodeElement : deadCodeGroup) {
            ICompositeNode compNode = NodeModelUtils.findActualNodeFor((EObject)deadCodeElement);
            int elemStartIdx = compNode.getOffset();
            int elemEndIdx = elemStartIdx + compNode.getLength();
            startIdx = Math.min(startIdx, elemStartIdx);
            endIdx = Math.max(endIdx, elemEndIdx);
            if (elemStartIdx >= firstElementOffset) continue;
            firstElementOffset = elemStartIdx;
            firstElement = deadCodeElement;
        }
        ControlFlowElement containerCFE = this.flowAnalyzer.getContainer(firstElement);
        ControlFlowElement reachablePredecessor = this.findPrecedingStatement(firstElement);
        return new DeadCodeRegion(startIdx, endIdx - startIdx, containerCFE, reachablePredecessor);
    }

    private ControlFlowElement findPrecedingStatement(ControlFlowElement cfe) {
        Block block;
        EList stmts;
        int index;
        EObject stmtContainer;
        ControlFlowElement precedingStatement = null;
        Statement stmt = (Statement)EcoreUtil2.getContainerOfType((EObject)cfe, Statement.class);
        if (stmt != null && (stmtContainer = stmt.eContainer()) != null && stmtContainer instanceof Block && (index = (stmts = (block = (Block)stmtContainer).getStatements()).indexOf((Object)stmt)) > 0) {
            precedingStatement = (ControlFlowElement)stmts.get(index - 1);
        }
        return precedingStatement;
    }

    public static class DeadCodeRegion
    extends TextRegion {
        final ControlFlowElement reachablePredecessor;
        final ControlFlowElement container;

        DeadCodeRegion(int offset, int length, ControlFlowElement container, ControlFlowElement reachablePredecessor) {
            super(offset, length);
            this.container = container;
            this.reachablePredecessor = reachablePredecessor;
        }

        public ControlFlowElement getContainer() {
            return this.container;
        }

        public ControlFlowElement getReachablePredecessor() {
            return this.reachablePredecessor;
        }
    }
}

