/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tests.outline;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.swt.widgets.Display;

public class DisplaySafeSyncer {
    private volatile CountDownLatch latch;

    public void start() {
        if (this.latch == null) {
            this.latch = new CountDownLatch(1);
        }
    }

    public void awaitSignal(long timeout) throws TimeoutException, InterruptedException {
        if (this.latch == null) {
            throw new IllegalStateException("Syncher must be initialized");
        }
        long waitTime = 0L;
        while (waitTime < timeout) {
            if (this.latch.await(10L, TimeUnit.MILLISECONDS)) {
                this.latch = null;
                return;
            }
            waitTime += 10L;
            if (Display.getCurrent() == null) continue;
            Display.getCurrent().readAndDispatch();
        }
        throw new TimeoutException("Timeout in Syncer (timeout " + timeout + " ms)");
    }

    public void signal() {
        if (this.latch != null) {
            this.latch.countDown();
        }
    }
}

