/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.workspace;

import com.google.common.primitives.Ints;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SuffixText
extends Composite {
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport((Object)this);
    public static final String TEXT_PROPERTY = "text";
    public static final String SUFFIX_PROPERTY = "suffix";
    public static final String SUFFIX_VISIBILITY_PROPERTY = "suffixVisible";
    private static Color INACTIVE_COLOR = Display.getCurrent().getSystemColor(33);
    private String suffix = "";
    private String text = "";
    private final Text editableText;
    private final StyledText suffixText;
    private boolean mousePressed = false;
    private boolean suffixVisible = true;
    private final GC gc = new GC((Drawable)this.getDisplay());
    private ControlDecoration contentProposalDecoration;

    public SuffixText(Composite parent, int style) {
        super(parent, style);
        this.setLayout(new SuffixLayout());
        this.suffixText = this.createSuffixText();
        this.editableText = new Text((Composite)this, 0);
        this.configureListeners();
        this.setBackground(this.getDisplay().getSystemColor(25));
        this.setCursor(this.getDisplay().getSystemCursor(19));
    }

    private StyledText createSuffixText() {
        StyledText styledText = new StyledText((Composite)this, 0x40000000);
        styledText.setText("");
        styledText.setForeground(INACTIVE_COLOR);
        styledText.setBackground(this.getDisplay().getSystemColor(37));
        styledText.setEditable(false);
        styledText.setEnabled(false);
        styledText.setLeftMargin(0);
        return styledText;
    }

    private void configureListeners() {
        MouseListener focusCatcher = new MouseListener(){

            public void mouseUp(MouseEvent e) {
                SuffixText.this.mousePressed = false;
            }

            public void mouseDown(MouseEvent e) {
                SuffixText.this.editableText.forceFocus();
                SuffixText.this.editableText.setSelection(SuffixText.this.editableText.getText().length());
                SuffixText.this.mousePressed = true;
            }

            public void mouseDoubleClick(MouseEvent e) {
                SuffixText.this.editableText.setSelection(0, SuffixText.this.editableText.getText().length());
            }
        };
        this.addMouseListener(focusCatcher);
        this.suffixText.addMouseListener(focusCatcher);
        this.addMouseListener(focusCatcher);
        this.addPaintListener(paintEvent -> this.setBackground(this.editableText.getBackground()));
        this.editableText.addModifyListener(modifyEvent -> {
            this.layout();
            this.setText(this.editableText.getText());
        });
        this.addPropertyChangeListener(propertyChange -> {
            if (propertyChange.getPropertyName() == SUFFIX_PROPERTY) {
                this.layout(true);
            }
        });
        this.addPropertyChangeListener(propertyChange -> {
            if (propertyChange.getPropertyName() == SUFFIX_VISIBILITY_PROPERTY) {
                this.suffixText.setVisible(this.suffixVisible);
            }
        });
        this.editableText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                SuffixText.this.setDecorationVisibility(false);
            }

            public void focusGained(FocusEvent e) {
                SuffixText.this.setDecorationVisibility(true);
            }
        });
        this.gc.setFont(this.editableText.getFont());
        MouseMoveListener mouseMoveSelectionListener = mouseMoveEvent -> {
            int userInputRightEdgeOffset;
            if (this.mousePressed && mouseMoveEvent.x < (userInputRightEdgeOffset = this.editableText.getBounds().x + this.editableText.getBounds().width)) {
                String inputString = this.editableText.getText();
                int selectedPixels = userInputRightEdgeOffset - mouseMoveEvent.x;
                int i = 1;
                while (inputString.length() - i >= 0 && this.gc.textExtent((String)this.editableText.getText().substring((int)(inputString.length() - i), (int)(inputString.length() - 1))).x < selectedPixels) {
                    ++i;
                }
                int startIndex = Ints.max((int[])new int[]{0, inputString.length() - i + 1});
                this.editableText.setSelection(startIndex, inputString.length());
            }
        };
        this.addMouseMoveListener(mouseMoveSelectionListener);
    }

    public void dispose() {
        super.dispose();
        this.gc.dispose();
    }

    protected void checkSubclass() {
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
        this.firePropertyChange(SUFFIX_PROPERTY, this.suffix, this.suffix);
        this.suffixText.setText(this.suffix);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.firePropertyChange(TEXT_PROPERTY, this.text, this.text);
        if (!this.editableText.getText().equals(text)) {
            this.editableText.setText(text);
        }
    }

    public void setSuffixVisible(boolean state) {
        this.suffixVisible = state;
        this.firePropertyChange(SUFFIX_VISIBILITY_PROPERTY, this.suffixVisible, this.suffixVisible);
    }

    public boolean isSuffixVisible() {
        return this.suffixVisible;
    }

    public boolean setFocus() {
        return this.editableText.setFocus();
    }

    public Text getInternalText() {
        return this.editableText;
    }

    public void createDecoration(Image decorationImage) {
        this.contentProposalDecoration = new ControlDecoration((Control)this, 16512);
        this.contentProposalDecoration.setImage(decorationImage);
        this.contentProposalDecoration.hide();
    }

    private void setDecorationVisibility(boolean state) {
        if (this.contentProposalDecoration != null) {
            if (state) {
                this.contentProposalDecoration.show();
            } else {
                this.contentProposalDecoration.hide();
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    private class SuffixLayout
    extends Layout {
        private static final int AVOID_CLIPPING_PADDING = 16;
        private final int verticalSpacing = Platform.getOS().equals("win32") ? 4 : 2;

        private SuffixLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Control[] children;
            int width = 0;
            int height = 0;
            Point textDimension = this.textDimensions();
            Control[] controlArray = children = composite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                if (child instanceof Text) {
                    String textContent = ((Text)child).getText();
                    textDimension = SuffixText.this.gc.textExtent(textContent);
                    width += textDimension.x;
                    height += textDimension.y;
                }
                if (child instanceof Label) {
                    Point computedSize = child.computeSize(0, 0);
                    width += computedSize.x;
                }
                ++n2;
            }
            return new Point(width, height + 4);
        }

        private Point textDimensions() {
            Point tDimensions = SuffixText.this.gc.textExtent(SuffixText.this.editableText.getText());
            return tDimensions;
        }

        private Point labelDimensions() {
            Point labelDimensions = SuffixText.this.gc.textExtent(SuffixText.this.suffix);
            labelDimensions.x += 16;
            return labelDimensions;
        }

        private int marginTopCenter(int height, int totalHeight) {
            return Double.valueOf(Math.floor((double)(totalHeight - height) / 2.0)).intValue();
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle clientArea = composite.getClientArea();
            Control[] children = composite.getChildren();
            Point labelDimension = this.labelDimensions();
            Point textDimension = this.textDimensions();
            Control[] controlArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                int verticalCenterY;
                Control child = controlArray[n2];
                if (child instanceof Text) {
                    verticalCenterY = this.marginTopCenter(textDimension.y, clientArea.height);
                    child.setBounds(0, verticalCenterY, clientArea.width, textDimension.y);
                }
                if (child instanceof StyledText) {
                    verticalCenterY = this.marginTopCenter(textDimension.y, clientArea.height);
                    child.setBounds(textDimension.x + this.verticalSpacing, verticalCenterY, labelDimension.x, labelDimension.y);
                }
                ++n2;
            }
        }
    }
}

