/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesystem.utils;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.scoping.members.TypingStrategyFilter;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExprOrRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.IntersectionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRefStructural;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsFactory;
import org.eclipse.n4js.ts.typeRefs.UnionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.Wildcard;
import org.eclipse.n4js.ts.types.AnyType;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.PrimitiveType;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.TStructField;
import org.eclipse.n4js.ts.types.TStructGetter;
import org.eclipse.n4js.ts.types.TStructMember;
import org.eclipse.n4js.ts.types.TStructMethod;
import org.eclipse.n4js.ts.types.TStructSetter;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.ts.utils.SuperTypesList;
import org.eclipse.n4js.ts.utils.TypeCompareHelper;
import org.eclipse.n4js.ts.utils.TypeHelper;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.utils.GenericsComputer;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.utils.TypeSystemHelperStrategy;
import org.eclipse.n4js.utils.ContainerTypesHelper;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

class JoinComputer
extends TypeSystemHelperStrategy {
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    @Extension
    private TypeCompareHelper _typeCompareHelper;
    @Inject
    @Extension
    private TypeHelper _typeHelper;
    @Inject
    private ContainerTypesHelper containerTypesHelper;
    @Inject
    private GenericsComputer genericsComputer;

    JoinComputer() {
    }

    public TypeRef join(RuleEnvironment G, Iterable<? extends TypeRef> typeRefsToJoin) {
        boolean _tripleEquals;
        if (typeRefsToJoin == null) {
            return null;
        }
        Iterable typeRefs = IterableExtensions.filterNull(typeRefsToJoin);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)typeRefs);
        if (_isEmpty) {
            return null;
        }
        int _size = IterableExtensions.size((Iterable)typeRefs);
        boolean bl = _tripleEquals = _size == 1;
        if (_tripleEquals) {
            return (TypeRef)IterableExtensions.head((Iterable)typeRefs);
        }
        Iterable unionTypeRefs = Iterables.filter((Iterable)typeRefs, UnionTypeExpression.class);
        Functions.Function1 _function = it -> !(it instanceof UnionTypeExpression);
        Iterable nonUnionTypeRefs = IterableExtensions.filter((Iterable)typeRefs, (Functions.Function1)_function);
        TypeRef nonUnionJoin = this.joinNonUnionTypes(G, nonUnionTypeRefs);
        boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)unionTypeRefs);
        if (_isEmpty_1) {
            return nonUnionJoin;
        }
        return this.joinNonUnionTypeWithUniontypes(G, nonUnionJoin, unionTypeRefs);
    }

    private TypeRef joinNonUnionTypeWithUniontypes(RuleEnvironment G, TypeRef nonUnionJoin, Iterable<UnionTypeExpression> unionTypeRefs) {
        if (nonUnionJoin == null && IterableExtensions.size(unionTypeRefs) == 1) {
            return this.tsh.simplify(G, (UnionTypeExpression)IterableExtensions.head(unionTypeRefs));
        }
        UnionTypeExpression union = TypeRefsFactory.eINSTANCE.createUnionTypeExpression();
        if (nonUnionJoin != null) {
            union.getTypeRefs().add((Object)((TypeRef)TypeUtils.copyIfContained((EObject)nonUnionJoin)));
        }
        Functions.Function1 _function = it -> (UnionTypeExpression)TypeUtils.copyIfContained((EObject)it);
        Iterables.addAll((Collection)union.getTypeRefs(), (Iterable)IterableExtensions.map(unionTypeRefs, (Functions.Function1)_function));
        return this.tsh.simplify(G, union);
    }

    private TypeRef joinNonUnionTypes(RuleEnvironment G, Iterable<? extends TypeRef> nonUnionTypeRefs) {
        boolean _tripleEquals;
        boolean _isEmpty = IterableExtensions.isEmpty(nonUnionTypeRefs);
        if (_isEmpty) {
            return null;
        }
        int _size = IterableExtensions.size(nonUnionTypeRefs);
        boolean bl = _tripleEquals = _size == 1;
        if (_tripleEquals) {
            return (TypeRef)IterableExtensions.head(nonUnionTypeRefs);
        }
        ArrayList commonSuperTypesIgnoreTypeArgs = null;
        Type firstType = ((TypeRef)IterableExtensions.head(nonUnionTypeRefs)).getDeclaredType();
        if (firstType != null && IterableExtensions.forall(nonUnionTypeRefs, it -> {
            Type _declaredType = it.getDeclaredType();
            return _declaredType == firstType;
        })) {
            TypeRef head = (TypeRef)IterableExtensions.head(nonUnionTypeRefs);
            if (!head.isParameterized() && IterableExtensions.forall(nonUnionTypeRefs, it -> {
                boolean _isUseSiteStructuralTyping = it.isUseSiteStructuralTyping();
                return !_isUseSiteStructuralTyping;
            })) {
                return head;
            }
            commonSuperTypesIgnoreTypeArgs = Collections.singletonList(head);
        } else {
            boolean _greaterThan;
            commonSuperTypesIgnoreTypeArgs = this.commonSuperTypesTypeargsIgnored(G, nonUnionTypeRefs);
            boolean _isEmpty_1 = commonSuperTypesIgnoreTypeArgs.isEmpty();
            if (_isEmpty_1) {
                return RuleEnvironmentExtensions.anyTypeRef(G);
            }
            int _size_1 = commonSuperTypesIgnoreTypeArgs.size();
            boolean bl2 = _greaterThan = _size_1 > 1;
            if (_greaterThan) {
                int i = 0;
                while (i < commonSuperTypesIgnoreTypeArgs.size()) {
                    this.removeAllSuperTypesOfType(commonSuperTypesIgnoreTypeArgs, (TypeRef)commonSuperTypesIgnoreTypeArgs.get(i), G);
                    ++i;
                }
            }
        }
        ArrayList commonSuperTypesParameterized = null;
        Functions.Function1 _function = it -> {
            boolean _isParameterized = it.isParameterized();
            return !_isParameterized;
        };
        boolean _forall = IterableExtensions.forall(commonSuperTypesIgnoreTypeArgs, (Functions.Function1)_function);
        if (_forall) {
            commonSuperTypesParameterized = commonSuperTypesIgnoreTypeArgs;
        } else {
            commonSuperTypesParameterized = Lists.newArrayListWithCapacity((int)commonSuperTypesIgnoreTypeArgs.size());
            for (TypeRef superTypeIgnoreTypeArgs : commonSuperTypesIgnoreTypeArgs) {
                boolean _equals;
                boolean _not;
                boolean _isParameterized = superTypeIgnoreTypeArgs.isParameterized();
                boolean bl3 = _not = !_isParameterized;
                if (_not) {
                    commonSuperTypesParameterized.add((TypeRef)TypeUtils.copyIfContained((EObject)superTypeIgnoreTypeArgs));
                    continue;
                }
                Set<TypeRef> parameterizedSuperTypes = this.collectParameterizedSuperType(nonUnionTypeRefs, superTypeIgnoreTypeArgs.getDeclaredType(), G);
                int _size_2 = parameterizedSuperTypes.size();
                boolean bl4 = _equals = _size_2 == 1;
                if (_equals) {
                    commonSuperTypesParameterized.add((TypeRef)TypeUtils.copyIfContained((EObject)((TypeRef)IterableExtensions.head(parameterizedSuperTypes))));
                    continue;
                }
                TypeRef merged = (TypeRef)TypeUtils.copy((EObject)((TypeRef)IterableExtensions.head(parameterizedSuperTypes)));
                merged.getTypeArgs().clear();
                int i_1 = 0;
                while (i_1 < merged.getDeclaredType().getTypeVars().size()) {
                    boolean _equals_1;
                    Functions.Function1 _function_2;
                    TypeRef lowerBound;
                    int currentIndex = i_1;
                    Functions.Function1 _function_1 = it -> this.ts.upperBound(G, (TypeArgument)it.getTypeArgs().get(currentIndex));
                    TypeRef upperBound = this.join(G, IterableExtensions.map(parameterizedSuperTypes, (Functions.Function1)_function_1));
                    int _compare = this._typeCompareHelper.compare((TypeArgument)upperBound, (TypeArgument)(lowerBound = this.tsh.meet(G, IterableExtensions.map(parameterizedSuperTypes, (Functions.Function1)(_function_2 = it -> this.ts.lowerBound(G, (TypeArgument)it.getTypeArgs().get(currentIndex)))))));
                    boolean bl5 = _equals_1 = _compare == 0;
                    if (_equals_1) {
                        merged.getTypeArgs().add((Object)((TypeArgument)TypeUtils.copyIfContained((EObject)upperBound)));
                    } else {
                        Wildcard wildcard = TypeRefsFactory.eINSTANCE.createWildcard();
                        if (upperBound.isTopType() && !lowerBound.isBottomType()) {
                            wildcard.setDeclaredLowerBound((TypeRef)TypeUtils.copyIfContained((EObject)lowerBound));
                        } else {
                            wildcard.setDeclaredUpperBound((TypeRef)TypeUtils.copyIfContained((EObject)upperBound));
                        }
                        merged.getTypeArgs().add((Object)wildcard);
                    }
                    ++i_1;
                }
                commonSuperTypesParameterized.add(merged);
            }
        }
        Functions.Function1 _function_1 = it -> {
            Type _declaredType = it.getDeclaredType();
            return _declaredType instanceof ContainerType;
        };
        boolean _forall_1 = IterableExtensions.forall(nonUnionTypeRefs, (Functions.Function1)_function_1);
        if (_forall_1) {
            TypingStrategy _xifexpression = null;
            Functions.Function1 _function_2 = it -> {
                TypingStrategy _typingStrategy = it.getTypingStrategy();
                return _typingStrategy == TypingStrategy.STRUCTURAL_FIELDS;
            };
            boolean _exists = IterableExtensions.exists(nonUnionTypeRefs, (Functions.Function1)_function_2);
            if (_exists) {
                _xifexpression = TypingStrategy.STRUCTURAL_FIELDS;
            } else {
                TypingStrategy _xifexpression_1 = null;
                Functions.Function1 _function_3 = it -> {
                    TypingStrategy _typingStrategy = it.getTypingStrategy();
                    return _typingStrategy == TypingStrategy.STRUCTURAL;
                };
                boolean _exists_1 = IterableExtensions.exists(nonUnionTypeRefs, (Functions.Function1)_function_3);
                _xifexpression_1 = _exists_1 ? TypingStrategy.STRUCTURAL : TypingStrategy.DEFAULT;
                _xifexpression = _xifexpression_1;
            }
            TypingStrategy typingStrategy = _xifexpression;
            if (typingStrategy != TypingStrategy.DEFAULT) {
                ParameterizedTypeRefStructural ptrs = TypeRefsFactory.eINSTANCE.createParameterizedTypeRefStructural();
                TypeRef _xifexpression_2 = null;
                TypeRef _head = (TypeRef)IterableExtensions.head((Iterable)commonSuperTypesParameterized);
                if (_head instanceof ParameterizedTypeRef) {
                    _xifexpression_2 = (TypeRef)TypeUtils.copyIfContained((EObject)((TypeRef)IterableExtensions.head((Iterable)commonSuperTypesParameterized)));
                } else {
                    ParameterizedTypeRef _objectTypeRef = RuleEnvironmentExtensions.objectTypeRef(G);
                    ParameterizedTypeRef _copyIfContained = null;
                    if (_objectTypeRef != null) {
                        _copyIfContained = (ParameterizedTypeRef)TypeUtils.copyIfContained((EObject)_objectTypeRef);
                    }
                    _xifexpression_2 = _copyIfContained;
                }
                TypeRef trTemplate = _xifexpression_2;
                ptrs.setDefinedTypingStrategy(typingStrategy);
                ptrs.setDeclaredType(trTemplate.getDeclaredType());
                ptrs.getTypeArgs().addAll((Collection)trTemplate.getTypeArgs());
                TypingStrategyFilter filter = new TypingStrategyFilter(typingStrategy);
                HashMap<String, TMember> structuralMembersByName = new HashMap<String, TMember>();
                HashSet<String> structuralMembersWithDifferentTypeOrAlreadyContained = new HashSet<String>();
                Type _declaredType = ptrs.getDeclaredType();
                Functions.Function1 _function_4 = it -> filter.apply((TMember)it);
                Functions.Function1 _function_5 = it -> it.getName();
                Iterables.addAll(structuralMembersWithDifferentTypeOrAlreadyContained, (Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(this.containerTypesHelper.fromContext(RuleEnvironmentExtensions.getContextResource(G)).members((ContainerType)_declaredType), (Functions.Function1)_function_4), (Functions.Function1)_function_5));
                Functions.Function1 _function_6 = it -> {
                    Type _declaredType_2;
                    Type _declaredType_1 = it.getDeclaredType();
                    return _declaredType_1 != (_declaredType_2 = ptrs.getDeclaredType());
                };
                Iterable _filter = IterableExtensions.filter(nonUnionTypeRefs, (Functions.Function1)_function_6);
                for (TypeRef tr : _filter) {
                    Type _declaredType_1 = tr.getDeclaredType();
                    Functions.Function1 _function_7 = it -> filter.apply((TMember)it);
                    Iterable _concat = Iterables.concat((Iterable)tr.getStructuralMembers(), (Iterable)IterableExtensions.filter(this.containerTypesHelper.fromContext(RuleEnvironmentExtensions.getContextResource(G)).members((ContainerType)_declaredType_1), (Functions.Function1)_function_7));
                    for (TMember structMember : _concat) {
                        boolean _not_2;
                        boolean _not_1;
                        boolean _contains = structuralMembersWithDifferentTypeOrAlreadyContained.contains(structMember.getName());
                        boolean bl6 = _not_1 = !_contains;
                        if (!_not_1) continue;
                        TMember duplicate = (TMember)structuralMembersByName.get(structMember.getName());
                        if (duplicate == null) {
                            structuralMembersByName.put(structMember.getName(), structMember);
                            continue;
                        }
                        boolean _similarMember = this.similarMember(G, duplicate, structMember);
                        boolean bl7 = _not_2 = !_similarMember;
                        if (!_not_2) continue;
                        structuralMembersWithDifferentTypeOrAlreadyContained.add(structMember.getName());
                        structuralMembersByName.remove(structMember.getName());
                    }
                }
                Functions.Function1 _function_8 = it -> this.substituted(G, (TMember)it);
                Iterables.addAll((Collection)ptrs.getGenStructuralMembers(), (Iterable)Iterables.filter((Iterable)IterableExtensions.map(structuralMembersByName.values(), (Functions.Function1)_function_8), TStructMember.class));
                return ptrs;
            }
        }
        TypeRef _switchResult = null;
        int _size_3 = commonSuperTypesParameterized.size();
        switch (_size_3) {
            case 0: {
                throw new IllegalStateException("Error processing least common super type, parameterization removed all types");
            }
            case 1: {
                _switchResult = (TypeRef)IterableExtensions.head((Iterable)commonSuperTypesParameterized);
                break;
            }
            default: {
                IntersectionTypeExpression _xblockexpression = null;
                IntersectionTypeExpression intersectionTypeExpr = TypeRefsFactory.eINSTANCE.createIntersectionTypeExpression();
                Consumer<TypeRef> _function_9 = it -> intersectionTypeExpr.getTypeRefs().add((Object)((TypeRef)TypeUtils.copyIfContained((EObject)it)));
                commonSuperTypesParameterized.forEach(_function_9);
                _xblockexpression = intersectionTypeExpr;
                _switchResult = _xblockexpression;
            }
        }
        TypeRef singleLCST = _switchResult;
        return singleLCST;
    }

    private TMember _substituted(RuleEnvironment G, TMember member) {
        return member;
    }

    private TMember _substituted(RuleEnvironment G, TField member) {
        boolean _isParameterized = member.getTypeRef().isParameterized();
        if (_isParameterized) {
            boolean _tripleEquals;
            TStructField subst = TypesFactory.eINSTANCE.createTStructField();
            subst.setName(member.getName());
            subst.setTypeRef(this.ts.substTypeVariables(G, member.getTypeRef()));
            TypeRef _typeRef = subst.getTypeRef();
            boolean bl = _tripleEquals = _typeRef == null;
            if (_tripleEquals) {
                subst.setTypeRef((TypeRef)RuleEnvironmentExtensions.anyTypeRef(G));
            }
            return subst;
        }
        return member;
    }

    private TMember _substituted(RuleEnvironment G, TGetter member) {
        if (member.getDeclaredTypeRef() != null && member.getDeclaredTypeRef().isParameterized()) {
            boolean _tripleEquals;
            TStructGetter subst = TypesFactory.eINSTANCE.createTStructGetter();
            subst.setName(member.getName());
            subst.setDeclaredTypeRef(this.ts.substTypeVariables(G, member.getDeclaredTypeRef()));
            TypeRef _declaredTypeRef = subst.getDeclaredTypeRef();
            boolean bl = _tripleEquals = _declaredTypeRef == null;
            if (_tripleEquals) {
                subst.setDeclaredTypeRef((TypeRef)RuleEnvironmentExtensions.anyTypeRef(G));
            }
            return subst;
        }
        return member;
    }

    private TMember _substituted(RuleEnvironment G, TSetter member) {
        if (member.getFpar() != null && member.getFpar().getTypeRef() != null && member.getFpar().getTypeRef().isParameterized()) {
            TStructSetter subst = TypesFactory.eINSTANCE.createTStructSetter();
            subst.setName(member.getName());
            TypeRef tr = this.ts.substTypeVariables(G, member.getFpar().getTypeRef());
            if (tr == null) {
                tr = RuleEnvironmentExtensions.anyTypeRef(G);
            }
            subst.setFpar(TypesFactory.eINSTANCE.createTFormalParameter());
            TFormalParameter _fpar = subst.getFpar();
            _fpar.setName(member.getFpar().getName());
            TFormalParameter _fpar_1 = subst.getFpar();
            _fpar_1.setTypeRef((TypeRef)TypeUtils.copyIfContained((EObject)tr));
            return subst;
        }
        return member;
    }

    private TMember _substituted(RuleEnvironment G, TMethod member) {
        TypeRef _type = this.ts.type(G, (TypableElement)member);
        FunctionTypeExpression ftype = (FunctionTypeExpression)_type;
        TStructMethod subst = TypesFactory.eINSTANCE.createTStructMethod();
        subst.setName(member.getName());
        subst.getFpars().addAll((Collection)ftype.getFpars());
        subst.setReturnTypeRef(ftype.getReturnTypeRef());
        Functions.Function1 _function = it -> (TypeVariable)TypeUtils.copyIfContained((EObject)it);
        subst.getTypeVars().addAll((Collection)ListExtensions.map((List)member.getTypeVars(), (Functions.Function1)_function));
        return subst;
    }

    public boolean similarMember(RuleEnvironment G, TMember m1, TMember m2) {
        TypeRef t2;
        TypeRef t1 = this.ts.type(G, (TypableElement)m1);
        return this.ts.subtypeSucceeded(G, (TypeArgument)t1, (TypeArgument)(t2 = this.ts.type(G, (TypableElement)m2))) && this.ts.subtypeSucceeded(G, (TypeArgument)t2, (TypeArgument)t1);
    }

    private void removeAllSuperTypesOfType(List<TypeRef> orderedRefs, TypeRef ref, RuleEnvironment G) {
        SuperTypesList _collectAllDeclaredSuperTypesTypeargsIgnored = this._typeHelper.collectAllDeclaredSuperTypesTypeargsIgnored(ref, false);
        List<ParameterizedTypeRef> _collectAllImplicitSuperTypes = RuleEnvironmentExtensions.collectAllImplicitSuperTypes(G, ref);
        Iterable nonLeastSuperTypes = Iterables.concat((Iterable)_collectAllDeclaredSuperTypesTypeargsIgnored, _collectAllImplicitSuperTypes);
        for (TypeRef nonLeastSuperType : nonLeastSuperTypes) {
            boolean _not;
            boolean _removeTypeRef = this._typeHelper.removeTypeRef(orderedRefs, nonLeastSuperType);
            boolean bl = _not = !_removeTypeRef;
            if (!_not) continue;
            return;
        }
    }

    private Set<TypeRef> collectParameterizedSuperType(Iterable<? extends TypeRef> refs, Type rawSuperType, RuleEnvironment G) {
        TreeSet result = CollectionLiterals.newTreeSet((Comparator)this._typeCompareHelper.getTypeRefComparator());
        for (TypeRef typeRef : refs) {
            boolean _not;
            List<TypeRef> pathFromSuperType = this.computePathFromSuperTypeReflexive(typeRef, rawSuperType, CollectionLiterals.newHashSet());
            if (pathFromSuperType == null) {
                throw new IllegalStateException("Did not found " + rawSuperType + " in super types of " + typeRef);
            }
            TypeRef concreteSuperTypeRef = (TypeRef)IterableExtensions.head(pathFromSuperType);
            TypeRef _xifexpression = null;
            boolean _containsUnboundTypeVariables = concreteSuperTypeRef.containsUnboundTypeVariables();
            boolean bl = _not = !_containsUnboundTypeVariables;
            if (_not) {
                _xifexpression = concreteSuperTypeRef;
            } else {
                TypeRef _xblockexpression = null;
                RuleEnvironment Gnext = RuleEnvironmentExtensions.wrap(G);
                _xifexpression = _xblockexpression = this.genericsComputer.bindTypeVariables(Gnext, concreteSuperTypeRef);
            }
            result.add((TypeRef)TypeUtils.copyIfContained((EObject)_xifexpression));
        }
        return result;
    }

    private List<TypeRef> commonSuperTypesTypeargsIgnored(RuleEnvironment G, Iterable<? extends TypeRef> typeRefs) {
        ArrayList commonSuperTypes = CollectionLiterals.newArrayList();
        for (TypeRef typeRef : typeRefs) {
            boolean _not;
            boolean _addSuperTypesToCommonList = this.addSuperTypesToCommonList(G, typeRef, commonSuperTypes);
            boolean bl = _not = !_addSuperTypesToCommonList;
            if (!_not) continue;
            return Collections.emptyList();
        }
        return commonSuperTypes;
    }

    private void collectAllImplicitSuperTypes(TypeRef ref, RuleEnvironment G, SuperTypesList<TypeRef> superTypesList) {
        superTypesList.addAll(RuleEnvironmentExtensions.collectAllImplicitSuperTypes(G, ref));
    }

    private boolean _addSuperTypesToCommonList(RuleEnvironment G, TypeRef t, List<TypeRef> commonSuperTypes) {
        Type _declaredType = t.getDeclaredType();
        boolean _matched = false;
        if (_declaredType instanceof TClassifier) {
            _matched = true;
            SuperTypesList allDeclaredSuperTypes = SuperTypesList.newSuperTypesList((Comparator)this._typeCompareHelper.getTypeRefComparator());
            allDeclaredSuperTypes.add((Object)t);
            this._typeHelper.collectAllDeclaredSuperTypesTypeargsIgnored(t, allDeclaredSuperTypes);
            this.collectAllImplicitSuperTypes(t, G, (SuperTypesList<TypeRef>)allDeclaredSuperTypes);
            this.addOrIntersectTypes(G, commonSuperTypes, (SuperTypesList<TypeRef>)allDeclaredSuperTypes);
        }
        if (!_matched && _declaredType instanceof AnyType) {
            _matched = true;
            return false;
        }
        if (!_matched && _declaredType instanceof PrimitiveType) {
            _matched = true;
            this.addOrIntersectTypeWithAssignmentCompatibles(G, commonSuperTypes, t);
        }
        return true;
    }

    private boolean _addSuperTypesToCommonList(RuleEnvironment G, IntersectionTypeExpression t, List<TypeRef> commonSuperTypes) {
        SuperTypesList allDeclaredSuperTypes = SuperTypesList.newSuperTypesList((Comparator)this._typeCompareHelper.getTypeRefComparator());
        EList _typeRefs = t.getTypeRefs();
        for (TypeRef containedRef : _typeRefs) {
            allDeclaredSuperTypes.add((Object)containedRef);
            this._typeHelper.collectAllDeclaredSuperTypesTypeargsIgnored(containedRef, allDeclaredSuperTypes);
            this.collectAllImplicitSuperTypes(containedRef, G, (SuperTypesList<TypeRef>)allDeclaredSuperTypes);
        }
        this.addOrIntersectTypes(G, commonSuperTypes, (SuperTypesList<TypeRef>)allDeclaredSuperTypes);
        return true;
    }

    private boolean _addSuperTypesToCommonList(RuleEnvironment G, UnionTypeExpression t, List<TypeRef> commonSuperTypes) {
        SuperTypesList allDeclaredSuperTypes = SuperTypesList.newSuperTypesList((Comparator)this._typeCompareHelper.getTypeRefComparator());
        allDeclaredSuperTypes.add((Object)t);
        this.addOrIntersectTypes(G, commonSuperTypes, (SuperTypesList<TypeRef>)allDeclaredSuperTypes);
        return true;
    }

    private void addOrIntersectTypeWithAssignmentCompatibles(RuleEnvironment G, List<TypeRef> commonSuperTypes, TypeRef typeRef) {
        int index;
        boolean _isEmpty = commonSuperTypes.isEmpty();
        if (_isEmpty) {
            commonSuperTypes.add(typeRef);
            return;
        }
        boolean _containsByType = this._typeHelper.containsByType(commonSuperTypes, typeRef);
        if (_containsByType) {
            boolean _equals;
            int _size = commonSuperTypes.size();
            boolean bl = _equals = _size == 1;
            if (_equals) {
                return;
            }
            commonSuperTypes.clear();
            commonSuperTypes.add(typeRef);
            return;
        }
        Type type = typeRef.getDeclaredType();
        if (type instanceof PrimitiveType && (index = this._typeHelper.findTypeRefOrAssignmentCompatible(commonSuperTypes, typeRef)) >= 0) {
            boolean _tripleEquals;
            PrimitiveType _assignmentCompatible = ((PrimitiveType)type).getAssignmentCompatible();
            boolean bl = _tripleEquals = _assignmentCompatible == null;
            if (_tripleEquals) {
                commonSuperTypes.clear();
                commonSuperTypes.add(typeRef);
            } else {
                boolean _notEquals;
                int _size_1 = commonSuperTypes.size();
                boolean bl2 = _notEquals = _size_1 != 1;
                if (_notEquals) {
                    TypeRef tr = commonSuperTypes.get(index);
                    commonSuperTypes.clear();
                    commonSuperTypes.add(tr);
                }
            }
            return;
        }
        commonSuperTypes.clear();
    }

    private boolean _addSuperTypesToCommonList(RuleEnvironment G, FunctionTypeExprOrRef f, List<TypeRef> commonSuperTypes) {
        SuperTypesList allDeclaredSuperTypes = SuperTypesList.newSuperTypesList((Comparator)this._typeCompareHelper.getTypeRefComparator());
        allDeclaredSuperTypes.add((Object)f);
        this.collectAllImplicitSuperTypes((TypeRef)f, G, (SuperTypesList<TypeRef>)allDeclaredSuperTypes);
        this.addOrIntersectTypes(G, commonSuperTypes, (SuperTypesList<TypeRef>)allDeclaredSuperTypes);
        return true;
    }

    private List<TypeRef> _computePathFromSuperTypeReflexive(TypeRef ref, Type rawSuperType, Set<Type> processedTypes) {
        Type _declaredType = ref.getDeclaredType();
        boolean _equals = Objects.equal((Object)_declaredType, (Object)rawSuperType);
        if (_equals) {
            return CollectionLiterals.newArrayList((Object[])new TypeRef[]{ref});
        }
        Iterable _declaredSuperTypes = TypeUtils.declaredSuperTypes((Type)ref.getDeclaredType());
        for (ParameterizedTypeRef superTypeRef : _declaredSuperTypes) {
            List<TypeRef> superPath;
            boolean _add = processedTypes.add(superTypeRef.getDeclaredType());
            if (!_add || (superPath = this.computePathFromSuperTypeReflexive((TypeRef)superTypeRef, rawSuperType, processedTypes)) == null) continue;
            superPath.add(ref);
            return superPath;
        }
        return null;
    }

    private List<TypeRef> _computePathFromSuperTypeReflexive(IntersectionTypeExpression ref, Type rawSuperType, Set<Type> processedTypes) {
        EList _typeRefs = ref.getTypeRefs();
        for (TypeRef typeRef : _typeRefs) {
            List<TypeRef> path = this.computePathFromSuperTypeReflexive(typeRef, rawSuperType, processedTypes);
            if (path == null) continue;
            return path;
        }
        return null;
    }

    private void addOrIntersectTypes(RuleEnvironment G, List<TypeRef> commonSuperTypes, SuperTypesList<TypeRef> allDeclaredSuperTypes) {
        boolean _isEmpty = commonSuperTypes.isEmpty();
        if (_isEmpty) {
            commonSuperTypes.addAll((Collection<TypeRef>)allDeclaredSuperTypes);
        } else {
            FunctionTypeExprOrRef commonSuperFunction;
            boolean _notEquals;
            FunctionTypeExprOrRef currentSuperFunction = (FunctionTypeExprOrRef)IterableExtensions.head((Iterable)Iterables.filter(allDeclaredSuperTypes, FunctionTypeExprOrRef.class));
            FunctionTypeExprOrRef _xifexpression = null;
            _xifexpression = currentSuperFunction != null ? (FunctionTypeExprOrRef)IterableExtensions.head((Iterable)Iterables.filter(commonSuperTypes, FunctionTypeExprOrRef.class)) : null;
            FunctionTypeExprOrRef prevCommonSuperFunction = _xifexpression;
            this._typeHelper.retainAllTypeRefs(commonSuperTypes, allDeclaredSuperTypes);
            int _compare = this._typeCompareHelper.getTypeRefComparator().compare(prevCommonSuperFunction, currentSuperFunction);
            boolean bl = _notEquals = _compare != 0;
            if (_notEquals && (commonSuperFunction = this.joinFunctionTypeRefs(G, currentSuperFunction, prevCommonSuperFunction)) != null) {
                commonSuperTypes.add((TypeRef)commonSuperFunction);
            }
        }
    }

    private FunctionTypeExprOrRef joinFunctionTypeRefs(RuleEnvironment G, FunctionTypeExprOrRef f1, FunctionTypeExprOrRef f2) {
        FunctionTypeExpression joinedFunctionTypeExpr = TypeRefsFactory.eINSTANCE.createFunctionTypeExpression();
        if (f1.getReturnTypeRef() != null && f2.getReturnTypeRef() != null) {
            joinedFunctionTypeExpr.setReturnTypeRef((TypeRef)TypeUtils.copyIfContained((EObject)this.tsh.join(G, f1.getReturnTypeRef(), f2.getReturnTypeRef())));
        }
        joinedFunctionTypeExpr.setReturnValueMarkedOptional(f1.isReturnValueOptional() || f2.isReturnValueOptional());
        int maxParSize = Math.max(f1.getFpars().size(), f2.getFpars().size());
        int i = 0;
        boolean varOrOpt1 = false;
        boolean varOrOpt2 = false;
        while (i < maxParSize) {
            TFormalParameter par1 = this.getFParSmartAndFailSafe(f1, i);
            TFormalParameter par2 = this.getFParSmartAndFailSafe(f2, i);
            TFormalParameter fpar = null;
            if (par1 == null) {
                fpar = (TFormalParameter)TypeUtils.copy((EObject)par2);
            } else if (par2 == null) {
                fpar = (TFormalParameter)TypeUtils.copy((EObject)par1);
            } else {
                boolean _isVariadicOrOptional_1;
                boolean _isVariadicOrOptional = par1.isVariadicOrOptional();
                if (_isVariadicOrOptional) {
                    varOrOpt1 = true;
                }
                if (_isVariadicOrOptional_1 = par2.isVariadicOrOptional()) {
                    varOrOpt2 = true;
                }
                fpar = TypesFactory.eINSTANCE.createTFormalParameter();
                TypeRef meet = this.tsh.meet(G, par1.getTypeRef(), par2.getTypeRef());
                if (meet == null) {
                    if (varOrOpt1 && varOrOpt2) {
                        return joinedFunctionTypeExpr;
                    }
                    return null;
                }
                TypeRef parType = (TypeRef)TypeUtils.copyIfContained((EObject)meet);
                fpar.setTypeRef(parType);
                if (par1.isVariadic() && par2.isVariadic()) {
                    fpar.setVariadic(true);
                } else if (par1.isVariadicOrOptional() && par2.isVariadicOrOptional()) {
                    fpar.setHasInitializerAssignment(true);
                }
            }
            joinedFunctionTypeExpr.getFpars().add((Object)fpar);
            ++i;
        }
        return joinedFunctionTypeExpr;
    }

    private TFormalParameter getFParSmartAndFailSafe(FunctionTypeExprOrRef f, int index) {
        boolean _lessThan;
        boolean _equals;
        int _size = f.getFpars().size();
        boolean bl = _equals = _size == 0;
        if (_equals) {
            return null;
        }
        int _size_1 = f.getFpars().size();
        boolean bl2 = _lessThan = index < _size_1;
        if (_lessThan) {
            return (TFormalParameter)f.getFpars().get(index);
        }
        TFormalParameter last = (TFormalParameter)IterableExtensions.last((Iterable)f.getFpars());
        boolean _isVariadic = last.isVariadic();
        if (_isVariadic) {
            return last;
        }
        return null;
    }

    private TMember substituted(RuleEnvironment G, TMember member) {
        if (member instanceof TMethod) {
            return this._substituted(G, (TMethod)member);
        }
        if (member instanceof TGetter) {
            return this._substituted(G, (TGetter)member);
        }
        if (member instanceof TSetter) {
            return this._substituted(G, (TSetter)member);
        }
        if (member instanceof TField) {
            return this._substituted(G, (TField)member);
        }
        if (member != null) {
            return this._substituted(G, member);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(G, member).toString());
    }

    private boolean addSuperTypesToCommonList(RuleEnvironment G, TypeRef t, List<TypeRef> commonSuperTypes) {
        if (t instanceof IntersectionTypeExpression) {
            return this._addSuperTypesToCommonList(G, (IntersectionTypeExpression)t, commonSuperTypes);
        }
        if (t instanceof UnionTypeExpression) {
            return this._addSuperTypesToCommonList(G, (UnionTypeExpression)t, commonSuperTypes);
        }
        if (t instanceof FunctionTypeExprOrRef) {
            return this._addSuperTypesToCommonList(G, (FunctionTypeExprOrRef)t, commonSuperTypes);
        }
        if (t != null) {
            return this._addSuperTypesToCommonList(G, t, commonSuperTypes);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(G, t, commonSuperTypes).toString());
    }

    private List<TypeRef> computePathFromSuperTypeReflexive(TypeRef ref, Type rawSuperType, Set<Type> processedTypes) {
        if (ref instanceof IntersectionTypeExpression) {
            return this._computePathFromSuperTypeReflexive((IntersectionTypeExpression)ref, rawSuperType, processedTypes);
        }
        if (ref != null) {
            return this._computePathFromSuperTypeReflexive(ref, rawSuperType, processedTypes);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(ref, rawSuperType, processedTypes).toString());
    }
}

