/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.antlr;

import com.google.common.base.Strings;
import org.eclipse.xtext.xtext.generator.parser.antlr.AntlrGrammarGenUtil;

public class UnicodeKeywordHelper {
    public static String toUnicodeKeyword(String keyword) {
        if (keyword.equals("async ")) {
            keyword = "async";
        }
        if (UnicodeKeywordHelper.isIdentifier(keyword)) {
            StringBuilder result = new StringBuilder(keyword.length() * 30);
            char[] cArray = keyword.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                result.append("\n\t( '");
                result.append(c);
                result.append("' | '\\\\' 'u' ");
                String unicodeEscape = Strings.padStart((String)Integer.toHexString(c), (int)4, (char)'0');
                char[] cArray2 = unicodeEscape.toCharArray();
                int n3 = cArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    char u = cArray2[n4];
                    if ('0' <= u && u <= '9') {
                        result.append("'");
                        result.append(u);
                        result.append("'");
                    } else {
                        result.append("( '");
                        result.append(u);
                        result.append("' | '");
                        result.append(Character.toUpperCase(u));
                        result.append("' )");
                    }
                    ++n4;
                }
                result.append(" )");
                ++n2;
            }
            return result.toString();
        }
        return "'" + AntlrGrammarGenUtil.toAntlrString((String)keyword) + "'";
    }

    private static boolean isIdentifier(String keyword) {
        boolean wasTrue = false;
        char[] cArray = keyword.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (UnicodeKeywordHelper.isLetter(c)) {
                wasTrue = true;
            } else if (wasTrue) {
                throw new IllegalArgumentException(String.valueOf(keyword) + " starts with letter but is not alphanumeric. Surprise!");
            }
            ++n2;
        }
        return wasTrue;
    }

    private static boolean isLetter(int c) {
        int type = Character.getType(c);
        boolean result = type == 1 || type == 2 || type == 3 || type == 4 || type == 5 || type == 10;
        return result;
    }
}

