/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.resource;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.n4js.resource.N4JSResource;
import org.eclipse.n4js.validation.helper.IssuesProvider;
import org.eclipse.xtext.service.OperationCanceledError;
import org.eclipse.xtext.service.OperationCanceledManager;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.OnChangeEvictingCache;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class N4JSCache
extends OnChangeEvictingCache {
    @Inject
    private OperationCanceledManager operationCanceledManager;

    public OnChangeEvictingCache.CacheAdapter getOrCreate(Resource resource) {
        N4JSCacheAdapter adapter = (N4JSCacheAdapter)EcoreUtil.getAdapter((List)resource.eAdapters(), OnChangeEvictingCache.CacheAdapter.class);
        if (adapter == null) {
            adapter = new N4JSCacheAdapter();
            resource.eAdapters().add((Object)adapter);
            adapter.setResource(resource);
        }
        return adapter;
    }

    public List<Issue> getOrElseUpdateIssues(IResourceValidator resourceValidator, Resource res, CheckMode checkMode, CancelIndicator monitor) {
        try {
            List issues = (List)this.get("N4JS-IDE-AllIssues" + checkMode, res, new IssuesProvider(resourceValidator, res, checkMode, this.operationCanceledManager, monitor));
            return issues;
        }
        catch (OperationCanceledError oce) {
            return null;
        }
        catch (OperationCanceledException oce) {
            return null;
        }
    }

    private final class N4JSCacheAdapter
    extends OnChangeEvictingCache.CacheAdapter {
        private N4JSCacheAdapter() {
        }

        protected boolean resolve() {
            return false;
        }

        public boolean isAdapterForType(Object type) {
            return OnChangeEvictingCache.CacheAdapter.class.equals(type);
        }

        protected void setResource(Resource resource) {
            super.setResource(resource);
        }

        protected void setTarget(Resource target) {
            if (target instanceof N4JSResource) {
                this.basicSetTarget((Notifier)target);
                InternalEList contents = (InternalEList)target.getContents();
                int i = 0;
                int size = contents.size();
                while (i < size) {
                    Notifier notifier = (Notifier)contents.basicGet(i);
                    this.addAdapter(notifier);
                    ++i;
                }
            } else {
                super.setTarget(target);
            }
        }
    }
}

