/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.generator;

import com.google.common.base.Splitter;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.n4js.generator.ISubGenerator;

@Singleton
public class SubGeneratorRegistry {
    private static SubGeneratorRegistry singleton;
    private static final Logger LOGGER;
    private static final String SUBGENERATORS_EXTENSIONS_POINT_ID = "org.eclipse.n4js.generator.subgenerator";
    private static final String ATT_FILE_EXTENSIONS = "fileExtensions";
    private static final String ATT_SUB_GENERATOR_CLASS = "class";
    private volatile boolean isInitialized = false;
    private final Map<String, List<ISubGenerator>> generators = new HashMap<String, List<ISubGenerator>>();

    static {
        LOGGER = Logger.getLogger(SubGeneratorRegistry.class);
    }

    public static synchronized SubGeneratorRegistry getInstance() {
        if (singleton == null) {
            singleton = new SubGeneratorRegistry();
        }
        return singleton;
    }

    public void register(ISubGenerator generator, String fileExtension) {
        if (!this.generators.containsKey(fileExtension)) {
            ArrayList l = new ArrayList();
            this.generators.put(fileExtension, l);
        }
        this.generators.get(fileExtension).add(generator);
    }

    public Collection<ISubGenerator> getGenerators(String fileExtension) {
        if (!this.isInitialized) {
            this.initialize();
        }
        if (!this.generators.containsKey(fileExtension)) {
            return Collections.emptyList();
        }
        return this.generators.get(fileExtension);
    }

    public Collection<ISubGenerator> getGenerators() {
        if (!this.isInitialized) {
            this.initialize();
        }
        return this.generators.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private synchronized void initialize() {
        block9: {
            if (this.isInitialized) {
                return;
            }
            try {
                IExtension[] extensions;
                IExtensionRegistry registry = RegistryFactory.getRegistry();
                if (registry == null) break block9;
                IExtension[] iExtensionArray = extensions = registry.getExtensionPoint(SUBGENERATORS_EXTENSIONS_POINT_ID).getExtensions();
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement[] configElems;
                    IExtension extension = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = configElems = extension.getConfigurationElements();
                    int n3 = configElems.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement elem = iConfigurationElementArray[n4];
                        try {
                            String fileExtensions = elem.getAttribute(ATT_FILE_EXTENSIONS);
                            List fileExtensionList = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)fileExtensions);
                            ISubGenerator generator = (ISubGenerator)elem.createExecutableExtension(ATT_SUB_GENERATOR_CLASS);
                            for (String fileExtension : fileExtensionList) {
                                this.register(generator, fileExtension);
                            }
                        }
                        catch (Exception ex) {
                            LOGGER.error((Object)"Error while reading extensions for extension point org.eclipse.n4js.generator.subgenerator", (Throwable)ex);
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            finally {
                this.isInitialized = true;
            }
        }
    }

    public void reset() {
        this.isInitialized = false;
        this.generators.clear();
    }
}

