/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.dependencies;

import com.google.common.base.Strings;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.n4js.ui.utils.UIUtils;
import org.eclipse.n4js.ui.wizard.dependencies.InstallOptions;
import org.eclipse.n4js.ui.wizard.dependencies.RunnableSettingsFilesLocator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class SetupOptionsPage
extends WizardPage {
    private static final String NAME = "Install options page";
    private static final String DESCRIPTION = "Please select npm install options.";
    private static final Logger LOGGER = Logger.getLogger(SetupOptionsPage.class);
    private Table tNPMRC = null;
    private Composite configsContainer = null;
    private Composite container = null;

    public SetupOptionsPage() {
        super(NAME);
        this.setTitle(NAME);
        this.setDescription(DESCRIPTION);
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(1, true));
        this.container.setLayoutData((Object)new GridData(4, 4, true, true));
        new Label(this.container, 0).setText("Available options");
        new Label(this.container, 258).setLayoutData((Object)new GridData(768));
        Composite optionsContainer = new Composite(this.container, 0);
        optionsContainer.setLayout((Layout)new GridLayout(2, false));
        optionsContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.configsContainer = new Composite(this.container, 4);
        this.configsContainer.setLayout((Layout)new GridLayout(1, true));
        this.configsContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)this.container);
        this.setPageComplete(false);
    }

    private static Table createTable(Composite parent, Map<String, String> data, String toolTipText, String label) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        new Label(parent, 258).setLayoutData((Object)new GridData(768));
        new Label(parent, 0).setText(label);
        Table table = new Table(parent, 67588);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.setToolTipText(toolTipText);
        TableColumn nameColumn = new TableColumn(table, 0);
        nameColumn.setText("name");
        TableColumn locationColumn = new TableColumn(table, 0);
        locationColumn.setText("Location");
        TableItem defaultItem = new TableItem(table, 0);
        defaultItem.setText(0, "default");
        defaultItem.setText(1, "default settings");
        data.forEach((path, name) -> {
            TableItem item = new TableItem(table, 0);
            item.setText(0, name);
            item.setText(1, path);
        });
        table.getColumn(0).pack();
        table.getColumn(1).pack();
        table.pack(true);
        return table;
    }

    private void updateConfigs(Map<String, String> npmrcs) {
        this.configsContainer.setVisible(false);
        Control[] controlArray = this.configsContainer.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control kid = controlArray[n2];
            kid.dispose();
            ++n2;
        }
        this.configsContainer.pack(true);
        this.tNPMRC = SetupOptionsPage.createTable(this.configsContainer, npmrcs, ".npmrc configurations", "Please select configuration for '.npmrc'.");
        this.container.layout();
        this.configsContainer.setVisible(true);
    }

    public void setVisible(boolean visible) {
        this.setPageComplete(visible);
        if (visible) {
            this.discoverConfigFilesAndUpdate();
        }
        super.setVisible(visible);
    }

    public void saveOptions(InstallOptions options) {
        if (this.tNPMRC != null) {
            options.npmrc = this.getTableItem(this.tNPMRC);
        }
    }

    private void discoverConfigFilesAndUpdate() {
        RunnableSettingsFilesLocator runnableSettingsFilesLocator = new RunnableSettingsFilesLocator();
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)runnableSettingsFilesLocator);
        }
        catch (InterruptedException | InvocationTargetException e) {
            LOGGER.error((Object)"Error during configuration files discovery.", (Throwable)e);
            UIUtils.getDisplay().asyncExec(() -> {
                String title = "Error during configuration files discovery.";
                String message = "Error scanning files system for the configuration files..\n";
                message = String.valueOf(message) + "Please check your Error Log view for the detailed log about the failure.";
                MessageDialog.openError((Shell)UIUtils.getShell(), (String)title, (String)message);
            });
        }
        Collection<File> fNPMRCs = runnableSettingsFilesLocator.getCollectedConfigFiles();
        TreeMap<String, String> npmrcs = new TreeMap<String, String>((p1, p2) -> Integer.valueOf(p1.length()).compareTo(p2.length()));
        fNPMRCs.forEach(f -> {
            String string = npmrcs.put(f.getAbsolutePath(), f.getName());
        });
        this.updateConfigs(npmrcs);
    }

    private String getTableItem(Table table) {
        String result = "";
        if (table == null) {
            return result;
        }
        TableItem[] items = table.getSelection();
        if (items.length >= 2) {
            String text = Strings.nullToEmpty((String)table.getToolTipText());
            if (!text.isEmpty()) {
                text = " :: " + text;
            }
            throw new RuntimeException("Multiple selections are not supported" + text);
        }
        if (items.length == 1 && items[0] != null) {
            result = Strings.nullToEmpty((String)items[0].getText(1));
        }
        return result;
    }
}

