/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.xtext.lib.tests;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Binder;
import com.google.inject.Key;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xpect.XjmXpectMethod;
import org.eclipse.xpect.XpectFile;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.XpectInvocation;
import org.eclipse.xpect.XpectReplace;
import org.eclipse.xpect.registry.AbstractDelegatingModule;
import org.eclipse.xpect.registry.DefaultBinding;
import org.eclipse.xpect.setup.ISetupInitializer;
import org.eclipse.xpect.setup.XpectGuiceModule;
import org.eclipse.xpect.setup.XpectSetupFactory;
import org.eclipse.xpect.state.Configuration;
import org.eclipse.xpect.state.Creates;
import org.eclipse.xpect.state.XpectStateAnnotation;
import org.eclipse.xpect.text.IRegion;
import org.eclipse.xpect.text.Region;
import org.eclipse.xpect.ui.services.XtResourceValidator;
import org.eclipse.xpect.ui.util.XpectFileAccess;
import org.eclipse.xpect.util.JvmAnnotationUtil;
import org.eclipse.xpect.xtext.lib.setup.ThisResource;
import org.eclipse.xpect.xtext.lib.setup.XtextValidatingSetup;
import org.eclipse.xpect.xtext.lib.tests.ValidationTestConfig;
import org.eclipse.xpect.xtext.lib.util.IssueOverlapsRangePredicate;
import org.eclipse.xpect.xtext.lib.util.NextLine;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

@XpectGuiceModule
@XpectImport(value={IssuesByLineProvider.class})
public class ValidationTestModuleSetup
extends AbstractDelegatingModule {
    public static final IRegion UNMATCHED = new Region((CharSequence)"(unmatched)", -1, 0);

    public void configure(Binder binder) {
        binder.bind(IResourceValidator.class).to(TestingResourceValidator.class);
        binder.bind(IResourceValidator.class).annotatedWith(DefaultBinding.class).to(this.getOriginalType(Key.get(IResourceValidator.class)));
    }

    @XpectStateAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ConsumedIssues {
        public Severity[] value();
    }

    @XpectStateAnnotation
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface IssuesByLine {
    }

    @XpectSetupFactory
    @XpectReplace(value={XtextValidatingSetup.class})
    public static class IssuesByLineProvider
    extends XtextValidatingSetup {
        private Multimap<IRegion, Issue> issuesByLine = null;

        public IssuesByLineProvider(@ThisResource XtextResource resource) {
            super(resource);
        }

        @Override
        protected List<Issue> collectIssues() {
            return Lists.newArrayList((Iterable)this.collectIssuesByLine().get((Object)UNMATCHED));
        }

        @Creates(value=IssuesByLine.class)
        public Multimap<IRegion, Issue> collectIssuesByLine() {
            if (this.issuesByLine == null) {
                TestingResourceValidator validator = (TestingResourceValidator)this.getResource().getResourceServiceProvider().getResourceValidator();
                this.issuesByLine = validator.validateDelegateAndMapByOffset((Resource)this.getResource(), CheckMode.ALL, CancelIndicator.NullImpl, null);
            }
            return this.issuesByLine;
        }
    }

    public static class SeverityPredicate
    implements Predicate<Issue> {
        private Severity[] severities;

        public SeverityPredicate(Severity ... severity) {
            this.severities = severity;
        }

        public boolean apply(Issue input) {
            Severity e = input.getSeverity();
            Severity[] severityArray = this.severities;
            int n = this.severities.length;
            int n2 = 0;
            while (n2 < n) {
                Severity s = severityArray[n2];
                if (s == e) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    public static class TestingResourceValidator
    extends XtResourceValidator {
        protected Set<Severity> getExpectedSeverity(XpectInvocation inv) {
            if (inv == null || inv.eIsProxy()) {
                return null;
            }
            XjmXpectMethod method = inv.getMethod();
            if (method == null || method.eIsProxy()) {
                return null;
            }
            JvmOperation operation = method.getJvmMethod();
            if (operation == null || operation.eIsProxy()) {
                return null;
            }
            ConsumedIssues annotation = (ConsumedIssues)JvmAnnotationUtil.getJavaAnnotation((JvmAnnotationTarget)operation, ConsumedIssues.class);
            if (annotation == null) {
                return null;
            }
            EnumSet<Severity> result = EnumSet.copyOf(Lists.newArrayList((Object[])annotation.value()));
            return result;
        }

        public List<Issue> validateDelegate(Resource resource, CheckMode mode, CancelIndicator indicator, Configuration fileConfig) {
            return Lists.newArrayList((Iterable)this.validateDelegateAndMapByOffset(resource, mode, indicator, fileConfig).get((Object)UNMATCHED));
        }

        public Multimap<IRegion, Issue> validateDelegateAndMapByOffset(Resource resource, CheckMode mode, CancelIndicator indicator, Configuration fileConfig) {
            LinkedHashMultimap result = LinkedHashMultimap.create();
            List issuesFromDelegate = super.validateDelegate(resource, mode, indicator, fileConfig);
            if (resource instanceof XtextResource && ((XtextResource)resource).getParseResult() != null) {
                XtextResource xresource = (XtextResource)resource;
                if (issuesFromDelegate != null && !issuesFromDelegate.isEmpty()) {
                    XpectFile xpectFile = XpectFileAccess.getXpectFile((Resource)resource);
                    ValidationTestConfig config = new ValidationTestConfig((ISetupInitializer<ValidationTestConfig>)xpectFile.createSetupInitializer());
                    LinkedHashSet issues = Sets.newLinkedHashSet((Iterable)issuesFromDelegate);
                    HashSet matched = Sets.newHashSet();
                    for (XpectInvocation inv : xpectFile.getInvocations()) {
                        Set<Severity> severities = this.getExpectedSeverity(inv);
                        if (severities == null) continue;
                        IRegion region = new NextLine.NextLineProvider(xresource, inv).getNextLine();
                        ArrayList selected = Lists.newArrayList((Iterable)Iterables.filter((Iterable)issues, (Predicate)new IssueOverlapsRangePredicate(region, severities)));
                        result.putAll((Object)region, (Iterable)selected);
                        matched.addAll(selected);
                    }
                    issues.removeAll(matched);
                    result.putAll((Object)UNMATCHED, Iterables.filter((Iterable)issues, config.getIgnoreFilter()));
                }
            } else {
                result.putAll((Object)UNMATCHED, (Iterable)issuesFromDelegate);
            }
            if (fileConfig != null) {
                fileConfig.addValue(IssuesByLine.class, (Object)result);
            }
            return ImmutableMultimap.copyOf((Multimap)result);
        }
    }
}

