/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.IPreferenceConfigurationBlock;
import org.eclipse.ui.internal.editors.text.OverlayPreferenceStore;
import org.eclipse.ui.internal.editors.text.StatusInfo;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;
import org.eclipse.ui.texteditor.spelling.IPreferenceStatusMonitor;
import org.eclipse.ui.texteditor.spelling.ISpellingPreferenceBlock;
import org.eclipse.ui.texteditor.spelling.SpellingEngineDescriptor;

class SpellingConfigurationBlock
implements IPreferenceConfigurationBlock {
    private final OverlayPreferenceStore fStore;
    private Combo fProviderCombo;
    private Button fEnablementCheckbox;
    private ComboViewer fProviderViewer;
    private Composite fComboGroup;
    private Composite fGroup;
    private StackLayout fStackLayout;
    private final Map<String, SpellingEngineDescriptor> fProviderDescriptors;
    private final Map<String, ISpellingPreferenceBlock> fProviderPreferences;
    private final Map<String, Control> fProviderControls;
    private ForwardingStatusMonitor fStatusMonitor;
    private ISpellingPreferenceBlock fCurrentBlock;

    public SpellingConfigurationBlock(OverlayPreferenceStore store, IPreferenceStatusMonitor statusMonitor) {
        Assert.isNotNull((Object)store);
        this.fStore = store;
        this.fStore.addKeys(this.createOverlayStoreKeys());
        this.fStatusMonitor = new ForwardingStatusMonitor(statusMonitor);
        this.fProviderDescriptors = this.createListModel();
        this.fProviderPreferences = new HashMap<String, ISpellingPreferenceBlock>();
        this.fProviderControls = new HashMap<String, Control>();
    }

    private Map<String, SpellingEngineDescriptor> createListModel() {
        SpellingEngineDescriptor[] descs = EditorsUI.getSpellingService().getSpellingEngineDescriptors();
        HashMap<String, SpellingEngineDescriptor> map = new HashMap<String, SpellingEngineDescriptor>();
        SpellingEngineDescriptor[] spellingEngineDescriptorArray = descs;
        int n = descs.length;
        int n2 = 0;
        while (n2 < n) {
            SpellingEngineDescriptor desc = spellingEngineDescriptorArray[n2];
            map.put(desc.getId(), desc);
            ++n2;
        }
        return map;
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "spellingEnabled"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "spellingEngine"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    @Override
    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData(80);
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        PixelConverter pc = new PixelConverter((Control)composite);
        layout.verticalSpacing = pc.convertHeightInCharsToPixels(1) / 2;
        composite.setLayout((Layout)layout);
        if (EditorsUI.getSpellingService().getSpellingEngineDescriptors().length == 0) {
            Label label = new Label(composite, 0);
            label.setText(TextEditorMessages.SpellingConfigurationBlock_error_not_installed);
            return composite;
        }
        this.fEnablementCheckbox = new Button(composite, 32);
        this.fEnablementCheckbox.setText(TextEditorMessages.SpellingConfigurationBlock_enable);
        gd = new GridData(34);
        this.fEnablementCheckbox.setLayoutData((Object)gd);
        this.fEnablementCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = SpellingConfigurationBlock.this.fEnablementCheckbox.getSelection();
                SpellingConfigurationBlock.this.fStore.setValue("spellingEnabled", enabled);
                SpellingConfigurationBlock.this.updateCheckboxDependencies();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label label = new Label(composite, 0x1000000);
        gd = new GridData(770);
        label.setLayoutData((Object)gd);
        if (this.fProviderDescriptors.size() > 1) {
            this.fComboGroup = new Composite(composite, 0);
            gd = new GridData(770);
            gd.horizontalIndent = 10;
            this.fComboGroup.setLayoutData((Object)gd);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 0;
            this.fComboGroup.setLayout((Layout)gridLayout);
            Label comboLabel = new Label(this.fComboGroup, 0x1000000);
            gd = new GridData(36);
            comboLabel.setLayoutData((Object)gd);
            comboLabel.setText(TextEditorMessages.SpellingConfigurationBlock_combo_caption);
            label = new Label(composite, 0x1000000);
            gd = new GridData(770);
            label.setLayoutData((Object)gd);
            this.fProviderCombo = new Combo(this.fComboGroup, 12);
            gd = new GridData(132);
            this.fProviderCombo.setLayoutData((Object)gd);
            this.fProviderViewer = this.createProviderViewer();
        }
        Composite groupComp = new Composite(composite, 0);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        groupComp.setLayoutData((Object)gd);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        groupComp.setLayout((Layout)gridLayout);
        this.fGroup = new Composite(groupComp, 0);
        gd = new GridData(4, 4, true, true);
        gd.horizontalIndent = 10;
        this.fGroup.setLayoutData((Object)gd);
        this.fStackLayout = new StackLayout();
        this.fGroup.setLayout((Layout)this.fStackLayout);
        return composite;
    }

    @Override
    public void applyData(Object data) {
    }

    private ComboViewer createProviderViewer() {
        final ComboViewer viewer = new ComboViewer(this.fProviderCombo);
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return SpellingConfigurationBlock.this.fProviderDescriptors.values().toArray();
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                return ((SpellingEngineDescriptor)element).getLabel();
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = event.getStructuredSelection();
                if (sel.isEmpty()) {
                    return;
                }
                if (SpellingConfigurationBlock.this.fCurrentBlock != null && SpellingConfigurationBlock.this.fStatusMonitor.getStatus() != null && SpellingConfigurationBlock.this.fStatusMonitor.getStatus().matches(4)) {
                    if (this.isPerformRevert()) {
                        ISafeRunnable runnable = new ISafeRunnable(){

                            public void run() throws Exception {
                                SpellingConfigurationBlock.this.fCurrentBlock.performRevert();
                            }

                            public void handleException(Throwable x) {
                            }
                        };
                        SafeRunner.run((ISafeRunnable)runnable);
                    } else {
                        this.revertSelection();
                        return;
                    }
                }
                SpellingConfigurationBlock.this.fStore.setValue("spellingEngine", ((SpellingEngineDescriptor)sel.getFirstElement()).getId());
                SpellingConfigurationBlock.this.updateListDependencies();
            }

            private boolean isPerformRevert() {
                Shell shell = viewer.getControl().getShell();
                MessageDialog dialog = new MessageDialog(shell, TextEditorMessages.SpellingConfigurationBlock_error_title, null, TextEditorMessages.SpellingConfigurationBlock_error_message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1);
                return dialog.open() == 0;
            }

            private void revertSelection() {
                try {
                    viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
                    SpellingEngineDescriptor desc = EditorsUI.getSpellingService().getActiveSpellingEngineDescriptor((IPreferenceStore)SpellingConfigurationBlock.this.fStore);
                    if (desc != null) {
                        viewer.setSelection((ISelection)new StructuredSelection((Object)desc), true);
                    }
                }
                finally {
                    viewer.addSelectionChangedListener((ISelectionChangedListener)this);
                }
            }
        });
        viewer.setInput(this.fProviderDescriptors);
        viewer.refresh();
        return viewer;
    }

    private void updateCheckboxDependencies() {
        SpellingEngineDescriptor desc;
        String id;
        ISpellingPreferenceBlock preferenceBlock;
        final boolean enabled = this.fEnablementCheckbox.getSelection();
        if (this.fComboGroup != null) {
            this.setEnabled((Control)this.fComboGroup, enabled);
        }
        if ((preferenceBlock = this.fProviderPreferences.get(id = (desc = EditorsUI.getSpellingService().getActiveSpellingEngineDescriptor((IPreferenceStore)this.fStore)) != null ? desc.getId() : "")) != null) {
            ISafeRunnable runnable = new ISafeRunnable(){

                public void run() throws Exception {
                    preferenceBlock.setEnabled(enabled);
                }

                public void handleException(Throwable x) {
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
        }
    }

    private void setEnabled(Control control, boolean enabled) {
        if (control instanceof Composite) {
            Control[] children;
            Control[] controlArray = children = ((Composite)control).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                this.setEnabled(c, enabled);
                ++n2;
            }
        }
        control.setEnabled(enabled);
    }

    void updateListDependencies() {
        String id;
        SpellingEngineDescriptor desc = EditorsUI.getSpellingService().getActiveSpellingEngineDescriptor((IPreferenceStore)this.fStore);
        if (desc == null) {
            id = "";
            String message = TextEditorMessages.SpellingConfigurationBlock_error_not_exist;
            EditorsPlugin.log((IStatus)new Status(2, "org.eclipse.ui.editors", 0, message, null));
            this.fCurrentBlock = new ErrorPreferences(message);
        } else {
            id = desc.getId();
            this.fCurrentBlock = this.fProviderPreferences.get(id);
            if (this.fCurrentBlock == null) {
                try {
                    this.fCurrentBlock = desc.createPreferences();
                    this.fProviderPreferences.put(id, this.fCurrentBlock);
                }
                catch (CoreException e) {
                    EditorsPlugin.log(e);
                    this.fCurrentBlock = new ErrorPreferences(e.getLocalizedMessage());
                }
            }
        }
        Control control = this.fProviderControls.get(id);
        if (control == null) {
            final Control[] result = new Control[1];
            ISafeRunnable runnable = new ISafeRunnable(){

                public void run() throws Exception {
                    result[0] = SpellingConfigurationBlock.this.fCurrentBlock.createControl(SpellingConfigurationBlock.this.fGroup);
                }

                public void handleException(Throwable x) {
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
            control = result[0];
            if (control == null) {
                String message = TextEditorMessages.SpellingConfigurationBlock_info_no_preferences;
                EditorsPlugin.log((IStatus)new Status(2, "org.eclipse.ui.editors", 0, message, null));
                control = new ErrorPreferences(message).createControl(this.fGroup);
            } else {
                this.fProviderControls.put(id, control);
            }
        }
        Dialog.applyDialogFont((Control)control);
        this.fStackLayout.topControl = control;
        control.pack();
        this.fGroup.layout();
        this.fGroup.getParent().layout();
        this.fStatusMonitor.statusChanged(new StatusInfo());
        ISafeRunnable runnable = new ISafeRunnable(){

            public void run() throws Exception {
                SpellingConfigurationBlock.this.fCurrentBlock.initialize((IPreferenceStatusMonitor)SpellingConfigurationBlock.this.fStatusMonitor);
            }

            public void handleException(Throwable x) {
            }
        };
        SafeRunner.run((ISafeRunnable)runnable);
    }

    @Override
    public void initialize() {
        this.restoreFromPreferences();
    }

    @Override
    public boolean canPerformOk() {
        SpellingEngineDescriptor desc = EditorsUI.getSpellingService().getActiveSpellingEngineDescriptor((IPreferenceStore)this.fStore);
        String id = desc != null ? desc.getId() : "";
        final ISpellingPreferenceBlock block = this.fProviderPreferences.get(id);
        if (block == null) {
            return true;
        }
        final Boolean[] result = new Boolean[]{Boolean.TRUE};
        ISafeRunnable runnable = new ISafeRunnable(){

            public void run() throws Exception {
                result[0] = block.canPerformOk();
            }

            public void handleException(Throwable x) {
            }
        };
        SafeRunner.run((ISafeRunnable)runnable);
        return result[0];
    }

    @Override
    public void performOk() {
        for (final ISpellingPreferenceBlock block : this.fProviderPreferences.values()) {
            ISafeRunnable runnable = new ISafeRunnable(){

                public void run() throws Exception {
                    block.performOk();
                }

                public void handleException(Throwable x) {
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
        }
    }

    @Override
    public void performDefaults() {
        this.restoreFromPreferences();
        for (final ISpellingPreferenceBlock block : this.fProviderPreferences.values()) {
            ISafeRunnable runnable = new ISafeRunnable(){

                public void run() throws Exception {
                    block.performDefaults();
                }

                public void handleException(Throwable x) {
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
        }
    }

    @Override
    public void dispose() {
        for (final ISpellingPreferenceBlock block : this.fProviderPreferences.values()) {
            ISafeRunnable runnable = new ISafeRunnable(){

                public void run() throws Exception {
                    block.dispose();
                }

                public void handleException(Throwable x) {
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
        }
    }

    private void restoreFromPreferences() {
        if (this.fEnablementCheckbox == null) {
            return;
        }
        boolean enabled = this.fStore.getBoolean("spellingEnabled");
        this.fEnablementCheckbox.setSelection(enabled);
        if (this.fProviderViewer == null) {
            this.updateListDependencies();
        } else {
            SpellingEngineDescriptor desc = EditorsUI.getSpellingService().getActiveSpellingEngineDescriptor((IPreferenceStore)this.fStore);
            if (desc != null) {
                this.fProviderViewer.setSelection((ISelection)new StructuredSelection((Object)desc), true);
            }
        }
        this.updateCheckboxDependencies();
    }

    private static class ErrorPreferences
    implements ISpellingPreferenceBlock {
        private String fMessage;
        private Label fLabel;

        protected ErrorPreferences(String message) {
            this.fMessage = message;
        }

        public Control createControl(Composite composite) {
            Composite inner = new Composite(composite, 0);
            inner.setLayout((Layout)new FillLayout(512));
            this.fLabel = new Label(inner, 0x1000000);
            this.fLabel.setText(this.fMessage);
            return inner;
        }

        public void initialize(IPreferenceStatusMonitor statusMonitor) {
        }

        public boolean canPerformOk() {
            return true;
        }

        public void performOk() {
        }

        public void performDefaults() {
        }

        public void performRevert() {
        }

        public void dispose() {
        }

        public void setEnabled(boolean enabled) {
            this.fLabel.setEnabled(enabled);
        }
    }

    private static class ForwardingStatusMonitor
    implements IPreferenceStatusMonitor {
        private IPreferenceStatusMonitor fForwardedMonitor;
        private IStatus fStatus;

        public ForwardingStatusMonitor(IPreferenceStatusMonitor forwardedMonitor) {
            this.fForwardedMonitor = forwardedMonitor;
        }

        public void statusChanged(IStatus status) {
            this.fStatus = status;
            this.fForwardedMonitor.statusChanged(status);
        }

        public IStatus getStatus() {
            return this.fStatus;
        }
    }
}

