/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesystem.utils;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.ts.typeRefs.ComposedTypeRef;
import org.eclipse.n4js.ts.typeRefs.IntersectionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.UnionTypeExpression;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.PrimitiveType;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.util.AllSuperTypeRefsCollector;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.utils.TypeSystemHelperStrategy;
import org.eclipse.n4js.utils.ContainerTypesHelper;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class IterableComputer
extends TypeSystemHelperStrategy {
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    private ContainerTypesHelper containerTypesHelper;

    public Iterable<TypeRef> extractIterableElementTypesUBs(RuleEnvironment G, TypeRef typeRef) {
        Functions.Function1 _function = it -> this.ts.upperBound(G, (TypeArgument)it);
        return IterableExtensions.map(this.extractIterableElementTypes(G, typeRef), (Functions.Function1)_function);
    }

    public Iterable<? extends TypeRef> extractIterableElementTypes(RuleEnvironment G, TypeRef typeRef) {
        return this.extractIterableElementTypes(G, typeRef, true);
    }

    public TypeRef extractIterableElementTypeUB(RuleEnvironment G, TypeRef typeRef) {
        Functions.Function1 _function = it -> this.ts.upperBound(G, (TypeArgument)it);
        return (TypeRef)IterableExtensions.head((Iterable)IterableExtensions.map(this.extractIterableElementTypes(G, typeRef, false), (Functions.Function1)_function));
    }

    public TypeArgument extractIterableElementType(RuleEnvironment G, TypeRef typeRef) {
        return (TypeArgument)IterableExtensions.head(this.extractIterableElementTypes(G, typeRef, false));
    }

    private Iterable<? extends TypeRef> extractIterableElementTypes(RuleEnvironment G, TypeRef typeRef, boolean includeIterableN) {
        Type declType;
        Iterable<TypeRef> result = null;
        Type _declaredType = null;
        if (typeRef != null) {
            _declaredType = typeRef.getDeclaredType();
        }
        if ((declType = _declaredType) == RuleEnvironmentExtensions.iterableType(G) || includeIterableN && RuleEnvironmentExtensions.isIterableN(G, (EObject)declType)) {
            result = this.toUpperBounds((Iterable<TypeArgument>)typeRef.getTypeArgs(), G);
        } else if (declType instanceof PrimitiveType) {
            TypeRef elementType = ((PrimitiveType)declType).getElementType();
            if (elementType != null) {
                TypeRef _copy = (TypeRef)TypeUtils.copy((EObject)elementType);
                result = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TypeRef[]{_copy}));
            }
        } else if (typeRef instanceof ComposedTypeRef) {
            boolean _not;
            ArrayList results = CollectionLiterals.newArrayList();
            EList _typeRefs = ((ComposedTypeRef)typeRef).getTypeRefs();
            for (TypeRef containedTypeRef : _typeRefs) {
                Iterable<? extends TypeRef> currResult = this.extractIterableElementTypes(G, containedTypeRef, includeIterableN);
                boolean _isEmpty = IterableExtensions.isEmpty(currResult);
                if (_isEmpty) {
                    return Collections.unmodifiableList(CollectionLiterals.newArrayList());
                }
                results.add(currResult);
            }
            boolean _isEmpty = results.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                result = this.mergeListsOfTypeRefs(G, ((ComposedTypeRef)typeRef).getClass(), (Iterable[])Conversions.unwrapArray((Object)results, Iterable.class));
            }
        } else if (declType instanceof ContainerType) {
            boolean _not_1;
            ArrayList results_1 = CollectionLiterals.newArrayList();
            List _collect = AllSuperTypeRefsCollector.collect((ContainerType)((ContainerType)declType));
            for (ParameterizedTypeRef superTypeRef : _collect) {
                TInterface _iterableType;
                boolean _tripleEquals;
                boolean _or = false;
                Type _declaredType_1 = null;
                if (superTypeRef != null) {
                    _declaredType_1 = superTypeRef.getDeclaredType();
                }
                boolean bl = _tripleEquals = _declaredType_1 == (_iterableType = RuleEnvironmentExtensions.iterableType(G));
                if (_tripleEquals) {
                    _or = true;
                } else {
                    boolean bl2 = _or = includeIterableN && RuleEnvironmentExtensions.isIterableN(G, (EObject)superTypeRef);
                }
                if (!_or) continue;
                boolean isContainedInIterable = RuleEnvironmentExtensions.isIterableN(G, superTypeRef.eContainer());
                if (includeIterableN && isContainedInIterable) continue;
                results_1.add(this.toUpperBounds((Iterable<TypeArgument>)superTypeRef.getTypeArgs(), G));
            }
            boolean _isEmpty_1 = results_1.isEmpty();
            boolean bl = _not_1 = !_isEmpty_1;
            if (_not_1) {
                result = this.mergeListsOfTypeRefs(G, IntersectionTypeExpression.class, (Iterable[])Conversions.unwrapArray((Object)results_1, Iterable.class));
            }
            if (result == null) {
                Object res = G.get(Resource.class);
                if (res instanceof Resource) {
                    TMember m = this.containerTypesHelper.fromContext((Resource)res).findMember((ContainerType)declType, "#iterator", false, false);
                    if (m instanceof TMethod) {
                        TypeRef _returnTypeRef = ((TMethod)m).getReturnTypeRef();
                        EList _typeArgs = null;
                        if (_returnTypeRef != null) {
                            _typeArgs = _returnTypeRef.getTypeArgs();
                        }
                        result = this.toUpperBounds((Iterable<TypeArgument>)_typeArgs, G);
                    } else if (m instanceof TGetter) {
                        TypeRef _declaredTypeRef = ((TGetter)m).getDeclaredTypeRef();
                        EList _typeArgs_1 = null;
                        if (_declaredTypeRef != null) {
                            _typeArgs_1 = _declaredTypeRef.getTypeArgs();
                        }
                        result = this.toUpperBounds((Iterable<TypeArgument>)_typeArgs_1, G);
                    }
                } else {
                    throw new IllegalArgumentException("no or invalid Resource defined in rule environment G");
                }
            }
        }
        if (result == null || IterableExtensions.isEmpty(result)) {
            return Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        RuleEnvironment G2 = RuleEnvironmentExtensions.wrap(G);
        this.tsh.addSubstitutions(G2, typeRef);
        Functions.Function1 _function = it -> this.ts.substTypeVariables(G2, (TypeRef)it);
        Iterable resultSubst = Iterables.filter((Iterable)IterableExtensions.map(result, (Functions.Function1)_function), TypeRef.class);
        return resultSubst;
    }

    private Iterable<TypeRef> toUpperBounds(Iterable<TypeArgument> typeArgs, RuleEnvironment G) {
        Functions.Function1 _function = it -> this.ts.upperBound(G, (TypeArgument)it);
        return IterableExtensions.map(typeArgs, (Functions.Function1)_function);
    }

    private Iterable<? extends TypeRef> mergeListsOfTypeRefs(RuleEnvironment G, Class<? extends ComposedTypeRef> type, Iterable<? extends TypeRef> ... iterablesToMerge) {
        int rs = ((List)Conversions.doWrapArray(iterablesToMerge)).size();
        if (rs == 0) {
            return CollectionLiterals.emptyList();
        }
        if (rs == 1) {
            return (Iterable)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray(iterablesToMerge)));
        }
        Functions.Function1 _function = it -> IterableExtensions.toList((Iterable)it);
        List listsToMerge = IterableExtensions.toList((Iterable)ListExtensions.map((List)((List)Conversions.doWrapArray(iterablesToMerge)), (Functions.Function1)_function));
        Functions.Function1 _function_1 = it -> it.size();
        Functions.Function2 _function_2 = (a, b) -> Math.max(a, b);
        int maxNumOfElems = (Integer)IterableExtensions.reduce((Iterable)ListExtensions.map((List)listsToMerge, (Functions.Function1)_function_1), (Functions.Function2)_function_2);
        ArrayList result = CollectionLiterals.newArrayList();
        TypeRef[] types_of_element_i_across_results = new TypeRef[rs];
        int i = 0;
        while (i < maxNumOfElems) {
            int j = 0;
            while (j < rs) {
                TypeRef type_of_element_i_in_result_j;
                List result_j = (List)listsToMerge.get(j);
                if (result_j == null || result_j.isEmpty()) {
                    throw new IllegalArgumentException("iterablesToMerge may not contain null values or empty iterables");
                }
                int _size = result_j.size();
                int _minus = _size - 1;
                int idxSafe = Math.min(i, _minus);
                types_of_element_i_across_results[j] = type_of_element_i_in_result_j = (TypeRef)result_j.get(idxSafe);
                ++j;
            }
            TypeRef _xifexpression = null;
            boolean _isAssignableFrom = UnionTypeExpression.class.isAssignableFrom(type);
            if (_isAssignableFrom) {
                _xifexpression = this.tsh.createUnionType(G, types_of_element_i_across_results);
            } else {
                TypeRef _xifexpression_1 = null;
                boolean _isAssignableFrom_1 = IntersectionTypeExpression.class.isAssignableFrom(type);
                if (!_isAssignableFrom_1) {
                    String _name = null;
                    if (type != null) {
                        _name = type.getName();
                    }
                    String _plus = "unknown subtype of ComposedTypeRef: " + _name;
                    throw new IllegalArgumentException(_plus);
                }
                _xifexpression_1 = this.tsh.createIntersectionType(G, types_of_element_i_across_results);
                _xifexpression = _xifexpression_1;
            }
            TypeRef type_of_element_i = _xifexpression;
            result.add(type_of_element_i);
            ++i;
        }
        return result;
    }
}

