/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.documentation;

import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.ExportDeclaration;
import org.eclipse.n4js.n4JS.ExportableElement;
import org.eclipse.n4js.n4JS.ExportedVariableDeclaration;
import org.eclipse.n4js.n4JS.ExportedVariableStatement;
import org.eclipse.n4js.n4JS.N4JSASTUtils;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.xtext.documentation.impl.MultiLineCommentDocumentationProvider;
import org.eclipse.xtext.nodemodel.BidiTreeIterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.LeafNode;
import org.eclipse.xtext.nodemodel.impl.LeafNodeWithSyntaxError;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class N4JSDocumentationProvider
extends MultiLineCommentDocumentationProvider {
    private static final Logger logger = Logger.getLogger(N4JSDocumentationProvider.class);

    public List<INode> getDocumentationNodes(EObject object) {
        EObject astNode = N4JSASTUtils.getCorrespondingASTNode((EObject)object);
        if (astNode != null) {
            ICompositeNode ptNodeOfASTNode;
            LeafNode lNode;
            TypeRef typeRef;
            List nodes = super.getDocumentationNodes(astNode);
            if (nodes.isEmpty() && astNode instanceof VariableDeclaration && (typeRef = ((VariableDeclaration)astNode).getDeclaredTypeRef()) != null) {
                nodes = this.getDocumentationNodes((EObject)typeRef);
            }
            if (nodes.isEmpty()) {
                EList decls;
                if (astNode instanceof ExportedVariableDeclaration && astNode.eContainer() instanceof ExportedVariableStatement && (decls = ((ExportedVariableStatement)astNode.eContainer()).getVarDecl()).size() == 1) {
                    return this.getDocumentationNodes(astNode.eContainer());
                }
                if (astNode instanceof ExportableElement && astNode.eContainer() instanceof ExportDeclaration) {
                    nodes = super.getDocumentationNodes(astNode.eContainer());
                }
            }
            if (nodes.isEmpty() && (lNode = this.searchLeafNodeDocumentation(ptNodeOfASTNode = NodeModelUtils.getNode((EObject)astNode))) != null) {
                return Collections.singletonList(lNode);
            }
            return nodes;
        }
        return super.getDocumentationNodes(object);
    }

    private LeafNode searchLeafNodeDocumentation(ICompositeNode ptNodeOfASTNode) {
        BidiTreeIterator rootIterator = ptNodeOfASTNode.getRootNode().getAsTreeIterable().iterator();
        int counter = 0;
        boolean found = false;
        while (rootIterator.hasNext()) {
            INode next = (INode)rootIterator.next();
            this.dump(++counter, next);
            if (next != ptNodeOfASTNode) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalStateException("Node model broken. Unable to find the current node in the node model by traversing from root.");
        }
        ICompositeNode directParent = ptNodeOfASTNode;
        boolean beforeDirectParentNode = false;
        while (rootIterator.hasPrevious()) {
            INode prev = (INode)rootIterator.previous();
            this.dump(--counter, prev);
            if (!beforeDirectParentNode) {
                if (this.hasAsParent(prev, directParent)) continue;
                beforeDirectParentNode = true;
            }
            if (prev instanceof LeafNodeWithSyntaxError) {
                if (((LeafNodeWithSyntaxError)prev).getSyntaxErrorMessage().getIssueCode() != "InternalSemicolonInjectingParser.ASI") {
                    return null;
                }
                String text = prev.getText();
                if (!this.isDocumentationStyle(text)) continue;
                return (LeafNodeWithSyntaxError)prev;
            }
            if (!(prev instanceof LeafNode)) continue;
            LeafNode ln = (LeafNode)prev;
            if (!ln.isHidden()) {
                return null;
            }
            String text = prev.getText();
            if (!this.isDocumentationStyle(text)) continue;
            return (LeafNode)prev;
        }
        return null;
    }

    private boolean hasAsParent(INode child, ICompositeNode directParent) {
        INode parent = child;
        while (parent != null) {
            if (parent == directParent) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    private void dump(int counter, INode next) {
        if (!logger.isTraceEnabled()) {
            return;
        }
        String leafText = this.leafText(next);
        logger.trace((Object)String.format("%4d: %90s - %s", counter, next.toString(), leafText));
    }

    private String leafText(INode next) {
        String leafText = "";
        if (next instanceof LeafNode) {
            leafText = ((LeafNode)next).getText();
        }
        return leafText;
    }

    public boolean isDocumentationStyle(String text) {
        if (text == null) {
            return false;
        }
        boolean a = this.commentStartTagRegex.matcher(text).matches();
        boolean b = this.endTagRegex.matcher(text).find();
        return a && b;
    }
}

