/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli;

import com.google.common.base.Objects;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.n4js.cli.N4JSCmdLineParser;
import org.eclipse.n4js.cli.N4jscGoal;
import org.eclipse.n4js.cli.N4jscOptions;
import org.kohsuke.args4j.NamedOptionDef;
import org.kohsuke.args4j.Option;

public class N4jscTestOptions
extends N4jscOptions {
    private final Map<String, N4JSCmdLineParser.ParsedOption> definedOptions = new LinkedHashMap<String, N4JSCmdLineParser.ParsedOption>();

    public static N4jscTestOptions COMPILE(File ... files) {
        return N4jscTestOptions.COMPILE(true, Arrays.asList(files));
    }

    public static N4jscTestOptions COMPILE(boolean cleanNoPersist, File ... files) {
        return N4jscTestOptions.COMPILE(cleanNoPersist, Arrays.asList(files));
    }

    public static N4jscTestOptions COMPILE(List<File> files) {
        return N4jscTestOptions.COMPILE(true, files);
    }

    public static N4jscTestOptions COMPILE(boolean cleanNoPersist, List<File> files) {
        N4jscTestOptions instance = new N4jscTestOptions();
        instance.options.goal = N4jscGoal.compile;
        instance.f(files);
        if (cleanNoPersist) {
            instance.clean().noPersist();
        }
        return instance;
    }

    public static N4jscTestOptions CLEAN(File ... files) {
        return N4jscTestOptions.CLEAN(Arrays.asList(files));
    }

    public static N4jscTestOptions CLEAN(List<File> files) {
        N4jscTestOptions instance = new N4jscTestOptions();
        instance.options.goal = N4jscGoal.clean;
        return instance.f(files);
    }

    public static N4jscTestOptions WATCH(File ... files) {
        return N4jscTestOptions.COMPILE(Arrays.asList(files));
    }

    public static N4jscTestOptions WATCH(List<File> files) {
        N4jscTestOptions instance = new N4jscTestOptions();
        instance.options.goal = N4jscGoal.watch;
        return instance.f(files);
    }

    public static N4jscTestOptions API(File ... files) {
        return N4jscTestOptions.API(Arrays.asList(files));
    }

    public static N4jscTestOptions API(List<File> files) {
        N4jscTestOptions instance = new N4jscTestOptions();
        instance.options.goal = N4jscGoal.api;
        return instance.f(files);
    }

    public static N4jscTestOptions HELP() {
        N4jscTestOptions instance = new N4jscTestOptions();
        instance.options.goal = N4jscGoal.help;
        return instance;
    }

    public static N4jscTestOptions LSP() {
        N4jscTestOptions instance = new N4jscTestOptions();
        instance.options.goal = N4jscGoal.lsp;
        return instance;
    }

    public N4jscTestOptions f(File ... files) {
        return this.f(Arrays.asList(files));
    }

    public N4jscTestOptions f(List<File> files) {
        this.options.dirs = files = files.stream().map(f -> {
            try {
                return f.getCanonicalFile();
            }
            catch (IOException e) {
                return null;
            }
        }).filter(f -> f != null).collect(Collectors.toList());
        return this;
    }

    public N4jscTestOptions verbose() {
        this.setDefinedOption(() -> {
            boolean bl = this.options.verbose = true;
        });
        return this;
    }

    public N4jscTestOptions showSetup() {
        this.setDefinedOption(() -> {
            boolean bl = this.options.showSetup = true;
        });
        return this;
    }

    public N4jscTestOptions clean() {
        this.setDefinedOption(() -> {
            boolean bl = this.options.clean = true;
        });
        return this;
    }

    public N4jscTestOptions noPersist() {
        this.setDefinedOption(() -> {
            boolean bl = this.options.noPersist = true;
        });
        return this;
    }

    public N4jscTestOptions testOnly() {
        this.setDefinedOption(() -> {
            boolean bl = this.options.testOnly = true;
        });
        return this;
    }

    public N4jscTestOptions noTests() {
        this.setDefinedOption(() -> {
            boolean bl = this.options.noTests = true;
        });
        return this;
    }

    public N4jscTestOptions log() {
        this.setDefinedOption(() -> {
            boolean bl = this.options.log = true;
        });
        return this;
    }

    public N4jscTestOptions logFile(String pLogFile) {
        this.setDefinedOption(() -> {
            String string2 = this.options.logFile = pLogFile;
        });
        return this;
    }

    public N4jscTestOptions maxErrs(int pMaxErrs) {
        this.setDefinedOption(() -> {
            int n2 = this.options.maxErrs = pMaxErrs;
        });
        return this;
    }

    public N4jscTestOptions maxWarns(int pMaxWarns) {
        this.setDefinedOption(() -> {
            int n2 = this.options.maxWarns = pMaxWarns;
        });
        return this;
    }

    public N4jscTestOptions port(int pPort) {
        this.setDefinedOption(() -> {
            int n2 = this.options.port = pPort;
        });
        return this;
    }

    public N4jscTestOptions testCatalog(File pTestCatalog) {
        this.setDefinedOption(() -> {
            File file2 = this.options.testCatalog = pTestCatalog;
        });
        return this;
    }

    public N4jscTestOptions performanceKey(String pPerformanceKey) {
        this.setDefinedOption(() -> {
            String string2 = this.options.performanceKey = pPerformanceKey;
        });
        return this;
    }

    public N4jscTestOptions performanceReport(File pPerformanceReport) {
        this.setDefinedOption(() -> {
            File file2 = this.options.performanceReport = pPerformanceReport;
        });
        return this;
    }

    public Map<String, N4JSCmdLineParser.ParsedOption> getDefinedOptions() {
        return this.definedOptions;
    }

    private boolean setDefinedOption(Runnable setter) {
        int definedOptionsCount = this.definedOptions.size();
        LinkedHashMap<Field, Object> optionFieldValues = new LinkedHashMap<Field, Object>();
        try {
            Option annotationOption;
            Object currentValue;
            Field field;
            Field[] fields;
            Field[] fieldArray = fields = this.options.getClass().getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                field = fieldArray[n2];
                currentValue = field.get(this.options);
                if (currentValue != null && currentValue != Boolean.FALSE && (annotationOption = field.getAnnotation(Option.class)) != null) {
                    optionFieldValues.put(field, currentValue);
                }
                ++n2;
            }
            setter.run();
            fieldArray = fields;
            n = fields.length;
            n2 = 0;
            while (n2 < n) {
                Object lastValue;
                field = fieldArray[n2];
                currentValue = field.get(this.options);
                if (currentValue != null && currentValue != Boolean.FALSE && (annotationOption = field.getAnnotation(Option.class)) != null && !Objects.equal(lastValue = optionFieldValues.get(field), (Object)currentValue)) {
                    NamedOptionDef nod = new NamedOptionDef(annotationOption);
                    String lastValueStr = lastValue == null ? "" : String.valueOf(lastValue);
                    String currentValueStr = currentValue == Boolean.TRUE ? null : String.valueOf(currentValue);
                    N4JSCmdLineParser.ParsedOption pOption = new N4JSCmdLineParser.ParsedOption(nod, lastValueStr, currentValueStr);
                    this.definedOptions.put(nod.name(), pOption);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return definedOptionsCount < this.definedOptions.size();
    }
}

