/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.factories;

import java.util.LinkedList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.flowgraphs.factories.ASTUtils;
import org.eclipse.n4js.flowgraphs.factories.DelegatingNodeFactory;
import org.eclipse.n4js.flowgraphs.factories.ReentrantASTIterator;
import org.eclipse.n4js.flowgraphs.model.CatchToken;
import org.eclipse.n4js.flowgraphs.model.ComplexNode;
import org.eclipse.n4js.flowgraphs.model.DelegatingNode;
import org.eclipse.n4js.flowgraphs.model.HelperNode;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.n4JS.AbstractCaseClause;
import org.eclipse.n4js.n4JS.CaseClause;
import org.eclipse.n4js.n4JS.ControlFlowElement;
import org.eclipse.n4js.n4JS.DefaultClause;
import org.eclipse.n4js.n4JS.LabelledStatement;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.SwitchStatement;

class SwitchFactory {
    SwitchFactory() {
    }

    /*
     * WARNING - void declaration
     */
    static ComplexNode buildComplexNode(ReentrantASTIterator astpp, SwitchStatement switchStmt) {
        ComplexNode cNode = new ComplexNode(astpp.container(), (ControlFlowElement)switchStmt);
        HelperNode entryNode = new HelperNode("entry", astpp.pos(), (ControlFlowElement)switchStmt);
        Node pivotNode = DelegatingNodeFactory.createOrHelper(astpp, "pivot", (ControlFlowElement)switchStmt, (ControlFlowElement)switchStmt.getExpression());
        cNode.addNode(entryNode);
        cNode.addNode(pivotNode);
        LinkedList<void> caseNodes = new LinkedList<void>();
        EList caseClauses = switchStmt.getCases();
        int n = 0;
        while (n < caseClauses.size()) {
            void var9_10;
            AbstractCaseClause cc = (AbstractCaseClause)caseClauses.get(n);
            Object var9_11 = null;
            if (cc instanceof CaseClause) {
                DelegatingNode delegatingNode = DelegatingNodeFactory.create(astpp, "case_" + n, (ControlFlowElement)switchStmt, (ControlFlowElement)cc);
            }
            if (cc instanceof DefaultClause) {
                DelegatingNode delegatingNode = DelegatingNodeFactory.create(astpp, "default", (ControlFlowElement)switchStmt, (ControlFlowElement)cc);
            }
            caseNodes.add(var9_10);
            cNode.addNode((Node)var9_10);
            ++n;
        }
        HelperNode exitNode = new HelperNode("exit", astpp.pos(), (ControlFlowElement)switchStmt);
        cNode.addNode(exitNode);
        LinkedList<Node> cfs = new LinkedList<Node>();
        cfs.add(entryNode);
        cfs.add(pivotNode);
        cNode.connectInternalSucc(cfs);
        for (Node node : caseNodes) {
            cNode.connectInternalSucc(pivotNode, node);
        }
        cfs.clear();
        cfs.addAll(caseNodes);
        cfs.add(exitNode);
        cNode.connectInternalSucc(cfs);
        if (switchStmt.getDefaultClause() == null) {
            cNode.connectInternalSucc(pivotNode, exitNode);
        }
        cNode.setEntryNode(entryNode);
        cNode.setExitNode(exitNode);
        LabelledStatement labelledStatement = ASTUtils.getLabelledStatement((Statement)switchStmt);
        exitNode.addCatchToken(new CatchToken(ControlFlowType.Break, labelledStatement));
        return cNode;
    }
}

