/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.n4js.N4JSLanguageConstants;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.n4JS.N4FieldDeclaration;
import org.eclipse.n4js.n4JS.N4JSFeatureUtils;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.n4JS.N4MemberAnnotationList;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4TypeDeclaration;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.Variable;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.TypesPackage;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.utils.N4JSLanguageHelper;
import org.eclipse.n4js.validation.AbstractN4JSDeclarativeValidator;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class N4JSNameValidator
extends AbstractN4JSDeclarativeValidator {
    @Inject
    private N4JSLanguageHelper languageHelper;
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    private JavaScriptVariantHelper jsVariantHelper;

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkN4TypeDeclaration(N4TypeDeclaration n4TypeDeclaration) {
        if (this.isNotChecked(n4TypeDeclaration)) {
            return;
        }
        if (Character.isUpperCase(n4TypeDeclaration.getName().charAt(0))) {
            return;
        }
        if (this.holdsTypeNameNotIndistinguishable(n4TypeDeclaration, "getter/setter", N4JSLanguageConstants.GETTER_SETTER) && this.holdsTypeNameNotIndistinguishable(n4TypeDeclaration, "access modifier", N4JSLanguageConstants.ACCESS_MODIFIERS) && this.holdsTypeNameNotIndistinguishable(n4TypeDeclaration, "boolean literal", N4JSLanguageConstants.BOOLEAN_LITERALS) && this.holdsTypeNameNotIndistinguishable(n4TypeDeclaration, "base type", N4JSLanguageConstants.BASE_TYPES) && this.holdsTypeNameNotIndistinguishable(n4TypeDeclaration, "keyword", this.languageHelper.getECMAKeywords())) {
            this.holdsDoesNotStartWithLowerCaseLetter(n4TypeDeclaration);
        }
    }

    private boolean isNotChecked(N4TypeDeclaration n4TypeDeclaration) {
        if (n4TypeDeclaration.getDefinedType() == null) {
            return true;
        }
        if (org.eclipse.xtext.util.Strings.isEmpty((String)n4TypeDeclaration.getName())) {
            return true;
        }
        if (!this.jsVariantHelper.checkTypeDeclaration((EObject)n4TypeDeclaration)) {
            return true;
        }
        return n4TypeDeclaration.isExternal();
    }

    private boolean holdsTypeNameNotIndistinguishable(N4TypeDeclaration element, String suffix, Collection<String> category) {
        if (category.contains(element.getName()) && !"yield".equals(element.getName())) {
            String message = IssueCodes.getMessageForCLF_NAME_INDISTINGUISHABLE(this.validatorMessageHelper.description((EObject)element), suffix);
            this.addIssue(org.eclipse.xtext.util.Strings.toFirstUpper((String)message), (EObject)element, (EStructuralFeature)N4JSPackage.Literals.N4_TYPE_DECLARATION__NAME, "CLF_NAME_INDISTINGUISHABLE", new String[0]);
            return false;
        }
        return true;
    }

    private boolean holdsDoesNotStartWithLowerCaseLetter(N4TypeDeclaration declaration) {
        if (Character.isLowerCase(declaration.getName().charAt(0))) {
            String msg = IssueCodes.getMessageForCLF_NAME_DOES_NOT_START_UPPERCASE(this.keywordProvider.keyword(declaration));
            this.addIssue(org.eclipse.xtext.util.Strings.toFirstUpper((String)msg), (EObject)declaration, (EStructuralFeature)N4JSPackage.Literals.N4_TYPE_DECLARATION__NAME, "CLF_NAME_DOES_NOT_START_UPPERCASE", new String[0]);
            return false;
        }
        return true;
    }

    @Check
    public void checkN4MemberDeclaration(N4MemberDeclaration n4Member) {
        if (this.isNotChecked(n4Member)) {
            return;
        }
        if (this.holdsDoesNotEqualWithConstructor(n4Member) && this.holdsNameMayNotBeConfusedWith((NamedElement)n4Member, "future reserved word", N4JSLanguageConstants.FUTURE_RESERVED_WORDS) && this.holdsNameMayNotBeConfusedWith((NamedElement)n4Member, "boolean literal", N4JSLanguageConstants.BOOLEAN_LITERALS) && !(n4Member instanceof Variable) && this.holdsDoesNotStartWithUpperCaseLetter(n4Member) && this.holdsNoTypeNameOrNameEqualsType((NamedElement)n4Member) && this.holdsDoesNotContainDiscouragedCharacter(n4Member)) {
            this.holdsNameMayNotBeConfusedWith((NamedElement)n4Member, "access modifier", N4JSLanguageConstants.ACCESS_MODIFIERS);
        }
    }

    private boolean holdsDoesNotEqualWithConstructor(N4MemberDeclaration n4Member) {
        if (n4Member.isStatic() && "constructor".equals(this.getDeclarationName(n4Member))) {
            String message = IssueCodes.getMessageForCLF_NAME_CONFLICTS_WITH_CONSTRUCTOR();
            this.addIssue(message, (EObject)n4Member, N4JSFeatureUtils.attributeOfNameFeature((NamedElement)n4Member), "CLF_NAME_CONFLICTS_WITH_CONSTRUCTOR", new String[0]);
            return false;
        }
        return true;
    }

    private boolean holdsDoesNotContainDiscouragedCharacter(N4MemberDeclaration n4Member) {
        for (String discouragedCharacter : N4JSLanguageConstants.DISCOURAGED_CHARACTERS.keySet()) {
            String declarationName = this.getDeclarationName(n4Member);
            if (declarationName.startsWith("$") || !declarationName.contains(discouragedCharacter)) continue;
            String discouragedCharacterLabel = N4JSLanguageConstants.DISCOURAGED_CHARACTERS.get(discouragedCharacter);
            String message = IssueCodes.getMessageForCLF_NAME_CONTAINS_DISCOURAGED_CHARACTER(discouragedCharacterLabel);
            this.addIssue(message, (EObject)n4Member, N4JSFeatureUtils.attributeOfNameFeature((NamedElement)n4Member), "CLF_NAME_CONTAINS_DISCOURAGED_CHARACTER", new String[0]);
            return false;
        }
        return true;
    }

    private String getDeclarationName(N4MemberDeclaration n4Member) {
        return Strings.nullToEmpty((String)n4Member.getName());
    }

    private boolean isNotChecked(N4MemberDeclaration n4Member) {
        if (n4Member.getDefinedTypeElement() == null) {
            return true;
        }
        if (n4Member instanceof N4MemberAnnotationList) {
            return true;
        }
        if (org.eclipse.xtext.util.Strings.isEmpty((String)n4Member.getName()) || n4Member.getOwner() == null) {
            return true;
        }
        if (!this.jsVariantHelper.checkMemberDeclaration((EObject)n4Member)) {
            return true;
        }
        return n4Member.getOwner().isExternal();
    }

    private boolean holdsDoesNotStartWithUpperCaseLetter(N4MemberDeclaration n4Member) {
        if (n4Member.isStatic()) {
            return true;
        }
        if (this.isConstFieldDeclaration(n4Member)) {
            return true;
        }
        if (Character.isUpperCase(n4Member.getName().charAt(0))) {
            String msg = IssueCodes.getMessageForCLF_NAME_DOES_NOT_START_LOWERCASE(this.keywordProvider.keyword(n4Member));
            this.addIssue(org.eclipse.xtext.util.Strings.toFirstUpper((String)msg), (EObject)n4Member, N4JSFeatureUtils.attributeOfNameFeature((NamedElement)n4Member), "CLF_NAME_DOES_NOT_START_LOWERCASE", new String[0]);
            return false;
        }
        return true;
    }

    private boolean isConstFieldDeclaration(N4MemberDeclaration memberDeclaration) {
        return memberDeclaration instanceof N4FieldDeclaration ? ((N4FieldDeclaration)memberDeclaration).isConst() : false;
    }

    @Check
    public void checkVariable(Variable variable) {
        if (this.isNotChecked(variable)) {
            return;
        }
        if (this.holdsDoesNotStartWithDollarSign(variable) && this.holdsDoesNotEqualWithConstructor(variable) && this.holdsStartWithLowercaseLetter(variable) && this.holdsNameMayNotBeConfusedWith((NamedElement)variable, "access modifier", N4JSLanguageConstants.ACCESS_MODIFIERS) && this.holdsNoTypeNameOrNameEqualsType((NamedElement)variable)) {
            this.holdsDoesNotContainDiscouragedCharacter(variable);
        }
    }

    private boolean holdsDoesNotEqualWithConstructor(Variable variable) {
        if ("constructor".equals(this.getVariableName(variable))) {
            String message = IssueCodes.getMessageForCLF_NAME_CONFLICTS_WITH_CONSTRUCTOR();
            this.addIssue(message, (EObject)variable, (EStructuralFeature)TypesPackage.Literals.IDENTIFIABLE_ELEMENT__NAME, "CLF_NAME_CONFLICTS_WITH_CONSTRUCTOR", new String[0]);
            return false;
        }
        return true;
    }

    private boolean holdsDoesNotStartWithDollarSign(Variable variable) {
        if (this.getVariableName(variable).startsWith("$")) {
            String message = IssueCodes.getMessageForCLF_NAME_DOLLAR();
            this.addIssue(message, (EObject)variable, (EStructuralFeature)TypesPackage.Literals.IDENTIFIABLE_ELEMENT__NAME, "CLF_NAME_DOLLAR", new String[0]);
            return false;
        }
        return true;
    }

    private String getVariableName(Variable variable) {
        return Strings.nullToEmpty((String)variable.getName());
    }

    private boolean isNotChecked(Variable variable) {
        if (org.eclipse.xtext.util.Strings.isEmpty((String)variable.getName())) {
            return true;
        }
        return !this.jsVariantHelper.checkVariable((EObject)variable);
    }

    private boolean holdsStartWithLowercaseLetter(Variable variable) {
        if (variable.isConst()) {
            return true;
        }
        char first = variable.getName().charAt(0);
        if (Character.isLetter(first) && !Character.isLowerCase(first)) {
            String msg = IssueCodes.getMessageForCLF_NAME_DOES_NOT_START_LOWERCASE(this.keywordProvider.keyword(variable));
            this.addIssue(org.eclipse.xtext.util.Strings.toFirstUpper((String)msg), (EObject)variable, (EStructuralFeature)TypesPackage.Literals.IDENTIFIABLE_ELEMENT__NAME, "CLF_NAME_DOES_NOT_START_LOWERCASE", new String[0]);
            return false;
        }
        return true;
    }

    private boolean holdsNoTypeNameOrNameEqualsType(NamedElement namedElement) {
        String typeName;
        TypeRef typeRef;
        String name;
        if (namedElement instanceof TypableElement && N4JSLanguageConstants.BASE_TYPES.contains(name = namedElement.getName()) && (typeRef = this.ts.tau((TypableElement)namedElement)) != null && typeRef.getDeclaredType() != null && !org.eclipse.xtext.util.Strings.isEmpty((String)(typeName = typeRef.getDeclaredType().getName())) && !name.equals(typeName)) {
            String message = IssueCodes.getMessageForCLF_NAME_DIFFERS_TYPE(this.validatorMessageHelper.description((EObject)namedElement), name, typeName);
            this.addIssue(org.eclipse.xtext.util.Strings.toFirstUpper((String)message), (EObject)namedElement, N4JSFeatureUtils.attributeOfNameFeature((NamedElement)namedElement), "CLF_NAME_DIFFERS_TYPE", new String[0]);
            return false;
        }
        return true;
    }

    private boolean holdsNameMayNotBeConfusedWith(NamedElement element, String suffix, Collection<String> category) {
        if (category.contains(element.getName()) && !(element instanceof FunctionDefinition)) {
            String message = IssueCodes.getMessageForCLF_NAME_RESERVED(this.validatorMessageHelper.description((EObject)element), suffix);
            this.addIssue(org.eclipse.xtext.util.Strings.toFirstUpper((String)message), (EObject)element, N4JSFeatureUtils.attributeOfNameFeature((NamedElement)element), "CLF_NAME_RESERVED", new String[0]);
            return false;
        }
        return true;
    }

    private boolean holdsDoesNotContainDiscouragedCharacter(Variable variable) {
        for (String discouragedCharacter : N4JSLanguageConstants.DISCOURAGED_CHARACTERS.keySet()) {
            String declarationName = this.getVariableName(variable);
            if (declarationName.startsWith(discouragedCharacter) || !declarationName.contains(discouragedCharacter)) continue;
            String discouragedCharacterLabel = N4JSLanguageConstants.DISCOURAGED_CHARACTERS.get(discouragedCharacter);
            String message = IssueCodes.getMessageForCLF_NAME_CONTAINS_DISCOURAGED_CHARACTER(discouragedCharacterLabel);
            this.addIssue(message, (EObject)variable, (EStructuralFeature)TypesPackage.Literals.IDENTIFIABLE_ELEMENT__NAME, "CLF_NAME_CONTAINS_DISCOURAGED_CHARACTER", new String[0]);
            return false;
        }
        return true;
    }
}

