/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.commands;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.ExecuteCommandCapabilities;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.Registration;
import org.eclipse.lsp4j.RegistrationParams;
import org.eclipse.lsp4j.Unregistration;
import org.eclipse.lsp4j.UnregistrationParams;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.ide.server.ILanguageServerAccess;
import org.eclipse.xtext.ide.server.commands.IExecutableCommandService;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IDisposable;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

@Log
public class ExecutableCommandRegistry {
    private static final String METHOD = "workspace/executeCommand";
    private Multimap<String, IExecutableCommandService> registeredCommands;
    private LanguageClient client;
    private static final Logger LOG = Logger.getLogger(ExecutableCommandRegistry.class);

    public void initialize(Iterable<? extends IResourceServiceProvider> allLanguages, ClientCapabilities capabilities, LanguageClient client) {
        this.client = client;
        this.registeredCommands = HashMultimap.create();
        Boolean _elvis = null;
        WorkspaceClientCapabilities _workspace = capabilities.getWorkspace();
        ExecuteCommandCapabilities _executeCommand = null;
        if (_workspace != null) {
            _executeCommand = _workspace.getExecuteCommand();
        }
        Boolean _dynamicRegistration = null;
        if (_executeCommand != null) {
            _dynamicRegistration = _executeCommand.getDynamicRegistration();
        }
        _elvis = _dynamicRegistration != null ? _dynamicRegistration : Boolean.valueOf(false);
        boolean hasDynamicRegistration = _elvis;
        for (IResourceServiceProvider iResourceServiceProvider : allLanguages) {
            IExecutableCommandService service = (IExecutableCommandService)iResourceServiceProvider.get(IExecutableCommandService.class);
            if (service == null) continue;
            List<String> commands = service.initialize();
            for (String c : commands) {
                this.registeredCommands.put((Object)c, (Object)service);
            }
            if (!hasDynamicRegistration) continue;
            Functions.Function1 _function = command -> this.register((String)command, service);
            service.initializeDynamicRegistration((Functions.Function1<? super String, ? extends IDisposable>)_function);
        }
    }

    protected IDisposable register(String command, IExecutableCommandService service) {
        String requestId = UUID.randomUUID().toString();
        Registration _registration = new Registration();
        Procedures.Procedure1 _function = it -> {
            it.setId(requestId);
            it.setMethod(METHOD);
            ExecuteCommandOptions _executeCommandOptions = new ExecuteCommandOptions();
            Procedures.Procedure1 _function_1 = it_1 -> it_1.setCommands(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{command})));
            ExecuteCommandOptions _doubleArrow = (ExecuteCommandOptions)ObjectExtensions.operator_doubleArrow((Object)_executeCommandOptions, (Procedures.Procedure1)_function_1);
            it.setRegisterOptions((Object)_doubleArrow);
        };
        Registration reg = (Registration)ObjectExtensions.operator_doubleArrow((Object)_registration, (Procedures.Procedure1)_function);
        RegistrationParams _registrationParams = new RegistrationParams();
        Procedures.Procedure1 _function_1 = it -> it.setRegistrations((List)CollectionLiterals.newArrayList((Object[])new Registration[]{reg}));
        RegistrationParams _doubleArrow = (RegistrationParams)ObjectExtensions.operator_doubleArrow((Object)_registrationParams, (Procedures.Procedure1)_function_1);
        this.client.registerCapability(_doubleArrow);
        this.registeredCommands.put((Object)command, (Object)service);
        IDisposable _function_2 = () -> {
            Unregistration _unregistration = new Unregistration();
            Procedures.Procedure1 _function_3 = it -> {
                it.setId(requestId);
                it.setMethod(METHOD);
            };
            Unregistration unReg = (Unregistration)ObjectExtensions.operator_doubleArrow((Object)_unregistration, (Procedures.Procedure1)_function_3);
            UnregistrationParams _unregistrationParams = new UnregistrationParams();
            Procedures.Procedure1 _function_4 = it -> it.setUnregisterations((List)CollectionLiterals.newArrayList((Object[])new Unregistration[]{unReg}));
            UnregistrationParams _doubleArrow_1 = (UnregistrationParams)ObjectExtensions.operator_doubleArrow((Object)_unregistrationParams, (Procedures.Procedure1)_function_4);
            this.client.unregisterCapability(_doubleArrow_1);
            this.registeredCommands.remove((Object)command, (Object)service);
        };
        return _function_2;
    }

    public Object executeCommand(ExecuteCommandParams params, ILanguageServerAccess access, CancelIndicator cancelIndicator) {
        Object result = null;
        Collection _get = this.registeredCommands.get((Object)params.getCommand());
        for (IExecutableCommandService service : _get) {
            Object localResult = service.execute(params, access, cancelIndicator);
            if (localResult == null) continue;
            if (result != null) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Multiple commands '");
                String _command = params.getCommand();
                _builder.append(_command);
                _builder.append("' have been registered. All are executed but only one result will be send back.");
                LOG.error((Object)_builder);
                continue;
            }
            result = localResult;
        }
        return result;
    }

    public List<String> getCommands() {
        return IterableExtensions.toList((Iterable)this.registeredCommands.keySet());
    }
}

