/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.expressions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.egit.core.internal.IRepositoryCommit;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.expressions.AbstractPropertyTester;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revwalk.RevCommit;

public class GitPropertyTester
extends AbstractPropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if ("parentCount".equals(property)) {
            RevCommit commit = (RevCommit)Adapters.adapt((Object)receiver, RevCommit.class);
            if (commit == null) {
                return false;
            }
            if (expectedValue instanceof Integer) {
                return commit.getParentCount() <= (Integer)expectedValue;
            }
            return this.computeResult(expectedValue, commit.getParentCount() > 0);
        }
        if ("isBare".equals(property)) {
            Repository repository = (Repository)Adapters.adapt((Object)receiver, Repository.class);
            if (repository != null) {
                return this.computeResult(expectedValue, repository.isBare());
            }
        } else if ("isSafe".equals(property)) {
            Repository repository = (Repository)Adapters.adapt((Object)receiver, Repository.class);
            if (repository != null) {
                return this.computeResult(expectedValue, repository.getRepositoryState().equals((Object)RepositoryState.SAFE));
            }
        } else if ("canCommit".equals(property)) {
            Repository repository = (Repository)Adapters.adapt((Object)receiver, Repository.class);
            if (repository != null) {
                return this.computeResult(expectedValue, repository.getRepositoryState().canCommit());
            }
        } else if ("hasMultipleRefs".equals(property)) {
            IRepositoryCommit commit = (IRepositoryCommit)Adapters.adapt((Object)receiver, IRepositoryCommit.class);
            if (commit != null) {
                return this.computeResult(expectedValue, this.hasMultipleRefs(commit, this.toRefNames(args)));
            }
        } else if ("hasRef".equals(property)) {
            IRepositoryCommit commit = (IRepositoryCommit)Adapters.adapt((Object)receiver, IRepositoryCommit.class);
            if (commit != null) {
                return this.computeResult(expectedValue, this.hasRef(commit, this.toRefNames(args)));
            }
        } else if ("isStash".equals(property)) {
            RepositoryCommit commit = (RepositoryCommit)((Object)Adapters.adapt((Object)receiver, RepositoryCommit.class));
            return this.computeResult(expectedValue, commit != null && commit.isStash());
        }
        return false;
    }

    private Collection<String> toRefNames(Object[] args) {
        ArrayList<String> names = new ArrayList<String>(2);
        if (args != null) {
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Object arg = objectArray[n2];
                String name = arg.toString();
                if (name.startsWith("refs/")) {
                    names.add(name);
                }
                ++n2;
            }
        }
        if (names.isEmpty()) {
            names.add("refs/heads/");
        }
        return names;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean hasMultipleRefs(IRepositoryCommit commit, Collection<String> names) {
        Repository repository = commit.getRepository();
        if (repository == null) {
            return false;
        }
        int count = 0;
        RevCommit revCommit = commit.getRevCommit();
        if (revCommit instanceof PlotCommit) {
            int n = ((PlotCommit)revCommit).getRefCount();
            int i = 0;
            while (i < n) {
                Ref ref = ((PlotCommit)revCommit).getRef(i);
                for (String name : names) {
                    if (ref.getName().startsWith(name) && ++count > 1) break;
                }
                if (count > 1) {
                    return true;
                }
                ++i;
            }
        } else {
            try {
                ObjectId selectedId = commit.getRevCommit().getId();
                for (String name : names) {
                    for (Ref branch : repository.getRefDatabase().getRefsByPrefix(name)) {
                        ObjectId objectId = branch.getLeaf().getObjectId();
                        if (objectId == null || !objectId.equals((AnyObjectId)selectedId) || ++count <= 1) continue;
                        return true;
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean hasRef(IRepositoryCommit commit, Collection<String> names) {
        Repository repository = commit.getRepository();
        if (repository == null) {
            return false;
        }
        RevCommit revCommit = commit.getRevCommit();
        if (revCommit instanceof PlotCommit) {
            int n = ((PlotCommit)revCommit).getRefCount();
            int i = 0;
            while (i < n) {
                Ref ref = ((PlotCommit)revCommit).getRef(i);
                for (String name : names) {
                    if (!ref.getName().startsWith(name)) continue;
                    return true;
                }
                ++i;
            }
        } else {
            try {
                ObjectId selectedId = commit.getRevCommit().getId();
                for (String name : names) {
                    for (Ref branch : repository.getRefDatabase().getRefsByPrefix(name)) {
                        ObjectId objectId = branch.getLeaf().getObjectId();
                        if (objectId == null || !objectId.equals((AnyObjectId)selectedId)) continue;
                        return true;
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }
}

